/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.iiop;

import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.iiop.ObjectKey;
import com.ibm.CORBA.ras.ORBRas;
import com.ibm.jtc.orb.nio.ByteBufferUtils;
import com.ibm.rmi.IOR;
import com.ibm.rmi.ServiceContext;
import com.ibm.rmi.iiop.GIOPMessageContextBase;
import com.ibm.rmi.iiop.Message;
import com.ibm.rmi.iiop.RequestMessage;
import com.ibm.rmi.iiop.ServiceContextList;
import com.ibm.rmi.util.buffer.ByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.tcp.channel.TCPWriteCompletedCallback;
import java.io.IOException;
import java.io.ObjectInput;

public final class GIOPRequestContext
extends GIOPMessageContextBase
implements GIOPMessageContext,
TCPWriteCompletedCallback {
    private RequestMessage reqMsg;
    private WsByteBuffer[] sendingContextBytes = null;

    public GIOPRequestContext(RequestMessage requestMessage, ByteBuffer byteBuffer) throws Exception {
        super((Message)requestMessage, byteBuffer);
        this.reqMsg = requestMessage;
        this.initialIOR = requestMessage.getInitialIOR();
        this.currentIOR = this.targetIOR = requestMessage.getIOR();
        this.initialObjectKey = this.initialIOR.getProfile().getObjectKeyObject();
        this.targetObjectKey = this.targetIOR.getProfile().getObjectKeyObject();
        this.initSendingContextBytes();
    }

    public GIOPRequestContext(RequestMessage requestMessage, WsByteBuffer[] wsByteBufferArray, int n) {
        super(requestMessage, wsByteBufferArray, n);
        this.reqMsg = requestMessage;
        this.targetIOR = this.initialIOR = requestMessage.getInitialIOR();
        this.targetObjectKey = this.initialObjectKey = requestMessage.getObjectKeyObject();
        this.initSendingContextBytes();
    }

    public GIOPRequestContext() {
    }

    private void initSendingContextBytes() {
        com.ibm.CORBA.iiop.ServiceContext serviceContext = this.reqMsg.getServiceContext(6);
        if (serviceContext != null) {
            if (serviceContext instanceof ServiceContext) {
                this.sendingContextBytes = ((ServiceContext)serviceContext).getContextBuffer();
            } else {
                byte[] byArray = serviceContext.getContextData();
                this.sendingContextBytes = new WsByteBuffer[]{ByteBufferUtils.fastWrap(byArray, 0, byArray.length, true)};
            }
        }
    }

    public boolean isRequest() {
        return true;
    }

    public boolean isResponseExpected() {
        return this.reqMsg.isResponseExpected();
    }

    public com.ibm.CORBA.iiop.Message getMessage() {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(4112L, this, "getMessage:148", "msg = " + this.reqMsg);
        }
        return this.reqMsg;
    }

    public ObjectKey getInitialObjectKeyObject() {
        return this.initialObjectKey;
    }

    public ObjectKey getObjectKeyObject() {
        return this.targetObjectKey;
    }

    public void setObjectKeyObject(ObjectKey objectKey) throws UnsupportedOperationException {
        if (ORBRas.isTrcLogging) {
            ORBRas.orbTrcLogger.trace(8208L, this, "setObjectKeyObject:180", "ObjectKey changed from " + this.targetObjectKey + " to  " + objectKey);
        }
        this.reqMsg.setObjectKey(objectKey);
        this.targetObjectKey = objectKey;
    }

    public com.ibm.CORBA.iiop.IOR getInitialIOR() {
        return this.initialIOR;
    }

    public com.ibm.CORBA.iiop.IOR getTargetIOR() {
        return this.targetIOR;
    }

    public com.ibm.CORBA.iiop.IOR getCurrentIOR() {
        return this.currentIOR;
    }

    public void setCurrentIOR(com.ibm.CORBA.iiop.IOR iOR) throws UnsupportedOperationException {
        if (this.targetIOR != null) {
            if (ORBRas.isTrcLogging) {
                ORBRas.orbTrcLogger.trace(8208L, this, "setCurrentIOR:226", "currentIOR changed from " + this.currentIOR + " to " + iOR);
            }
        } else {
            throw new UnsupportedOperationException("IOR cannot be set for Target Discrimination" + this.reqMsg.getAddressingDisposition());
        }
        this.currentIOR = iOR;
        this.reqMsg.setIOR((IOR)iOR);
    }

    public com.ibm.CORBA.iiop.ServiceContextList getServiceContexts() throws UnsupportedOperationException {
        return this.reqMsg.getServiceContexts();
    }

    public void setServiceContexts(com.ibm.CORBA.iiop.ServiceContextList serviceContextList) throws UnsupportedOperationException {
        this.reqMsg.setServiceContexts((ServiceContextList)serviceContextList);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.reqMsg = (RequestMessage)super.getMessage();
    }

    public WsByteBuffer[] getSendingContextBytes() throws UnsupportedOperationException {
        return this.sendingContextBytes;
    }

    public void setSendingContextBytes(WsByteBuffer[] wsByteBufferArray) {
        this.sendingContextBytes = wsByteBufferArray;
    }
}

