/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.orb;

import com.ibm.CORBA.channel.giop.GIOPChannelHelper;
import com.ibm.CORBA.channel.giop.GIOPConnectionContext;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.channel.giop.GIOPMessageContext;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.iiop.ClientResponseHandler;
import com.ibm.jtc.orb.iiop.IIOPInputHandler;
import com.ibm.jtc.orb.iiop.MessageHandler;
import com.ibm.jtc.orb.iiop.ServerRequestHandler;
import com.ibm.rmi.iiop.CDRReader;
import com.ibm.rmi.iiop.Connection;
import com.ibm.rmi.iiop.GIOPImpl;
import com.ibm.rmi.iiop.ORB;
import java.util.Map;

public class ORBChannelHelper {
    private static final String CLASS = ORBChannelHelper.class.getName();
    public static String ORB = "ORB";
    private ORB orb = null;
    private GIOPImpl giopImpl;

    protected ORBChannelHelper(Map map) {
        this.orb = (ORB)map.get(ORB);
    }

    protected int getTimeout(int n) {
        return n == 0 ? -1 : n;
    }

    protected ORB getOrb() {
        return this.orb;
    }

    private ORB getORBForJVM() {
        return GIOPChannelHelper.getOrb();
    }

    protected void setORBForChain(GIOPConnectionKey gIOPConnectionKey) {
        this.orb = this.getORBForJVM();
        if (this.orb == null) {
            this.orb = GIOPChannelHelper.getOrb(gIOPConnectionKey.getVirtualConnectionFactory().getName());
            if (this.orb == null) {
                Trc.warn("ORB not set for ", gIOPConnectionKey.toString(), CLASS, "setORBForChain:132");
                return;
            }
        } else {
            Trc.info("ORB for JVM ", gIOPConnectionKey.toString(), CLASS, "setORBForChain:137");
        }
    }

    protected void processCall(Connection connection, GIOPConnectionContext gIOPConnectionContext, GIOPMessageContext gIOPMessageContext) throws Exception {
        Trc.info("connCtx=", gIOPConnectionContext, " msgCtx=", gIOPMessageContext, " conn=", connection, CLASS, "processCall:157");
        MessageHandler messageHandler = new MessageHandler(this.orb, connection, gIOPMessageContext);
        IIOPInputHandler iIOPInputHandler = null;
        switch (gIOPMessageContext.getType()) {
            case 0: {
                iIOPInputHandler = new ServerRequestHandler(messageHandler);
                break;
            }
            case 1: {
                iIOPInputHandler = new ClientResponseHandler(messageHandler);
                break;
            }
            default: {
                iIOPInputHandler = new IIOPInputHandler(messageHandler);
            }
        }
        try {
            ((CDRReader)iIOPInputHandler).setCodeBaseRefBytes(gIOPMessageContext.getSendingContextBytes());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        connection.processInput(iIOPInputHandler);
    }
}

