/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi.channel.giop;

import com.ibm.CORBA.channel.giop.GIOPChannelHelper;
import com.ibm.CORBA.channel.giop.GIOPChannelPlugin;
import com.ibm.CORBA.channel.giop.GIOPConnectionKey;
import com.ibm.CORBA.channel.orb.ORBConfigConstants;
import com.ibm.CORBA.ras.Trc;
import com.ibm.rmi.ServerGIOP;
import com.ibm.rmi.channel.giop.GIOPConnectionTable;
import com.ibm.rmi.iiop.ORB;
import com.ibm.rmi.iiop.TransportService;
import java.util.Map;

public class GIOPChannelConfig
implements ORBConfigConstants {
    private static final String CLASS = GIOPChannelConfig.class.getName();
    public static String CONNECTION = "Connection";
    private ORB orb = null;
    private GIOPChannelPlugin giopPlugin;
    private ServerGIOP giopImpl;
    private TransportService transportService;
    private int bufferSize;

    GIOPChannelConfig(Map map) {
        this.orb = (ORB)map.get("ORB");
        if (this.orb != null) {
            this.bufferSize = this.orb.getReceiveBufferSize();
            this.transportService = (TransportService)this.orb.getTransport();
        }
    }

    GIOPChannelPlugin getGIOPChannelPlugin() {
        if (this.giopPlugin == null) {
            this.giopPlugin = (GIOPChannelPlugin)this.getOrb().getPlugin(GIOPChannelPlugin.class.getName());
        }
        if (this.giopPlugin == null) {
            String string = "GIOPChannelPlugin not set on registered ORB";
            Trc.ffdc(string, CLASS, "getGIOPPlugin:97");
            throw new Error(string);
        }
        return this.giopPlugin;
    }

    protected ORB getOrb() {
        return this.orb;
    }

    private ORB getORBForJVM() {
        return GIOPChannelHelper.getOrb();
    }

    protected void setORBForChain(GIOPConnectionKey gIOPConnectionKey) {
        this.orb = this.getORBForJVM();
        if (this.orb == null) {
            this.orb = GIOPChannelHelper.getOrb(gIOPConnectionKey.getVirtualConnectionFactory().getName());
            if (this.orb == null) {
                Trc.warn("ORB not set for ", gIOPConnectionKey.toString(), CLASS, "setORBForChain:137");
                return;
            }
        } else {
            Trc.info("ORB for JVM ", gIOPConnectionKey.toString(), CLASS, "setORBForChain:142");
        }
        this.bufferSize = this.orb.getReceiveBufferSize();
        this.transportService = (TransportService)this.orb.getTransport();
    }

    public synchronized GIOPConnectionTable getConnectionTable() {
        if (this.transportService == null) {
            this.transportService = (TransportService)this.getOrb().getTransport();
        }
        return this.transportService.getConnectionTable();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }
}

