/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rmi;

import com.ibm.jtc.orb.nio.BufferHandler;
import com.ibm.jtc.orb.nio.BufferMarker;
import com.ibm.jtc.orb.nio.ByteBufferUtils;
import com.ibm.jtc.orb.nio.CDRInputHandler;
import com.ibm.rmi.iiop.CDRInputStream;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class ServiceContext
implements com.ibm.CORBA.iiop.ServiceContext {
    private int id;
    private byte[] data = null;
    private WsByteBuffer[] dataBuffer = null;
    private int len;

    public ServiceContext() {
    }

    public ServiceContext(int n, byte[] byArray) {
        if (byArray == null) {
            throw new BAD_PARAM("ServiceContext data cannot be null", 1229124119, CompletionStatus.COMPLETED_MAYBE);
        }
        this.id = n;
        this.data = byArray;
    }

    public int getId() {
        return this.id;
    }

    public byte[] getContextData() {
        if (this.data == null && this.dataBuffer != null) {
            this.data = WsByteBufferUtils.asByteArray((WsByteBuffer[])this.dataBuffer);
        }
        return this.data;
    }

    public WsByteBuffer[] getContextBuffer() {
        if (this.dataBuffer == null && this.data != null) {
            this.dataBuffer = new WsByteBuffer[]{ByteBufferUtils.fastWrap(this.data, 0, this.len, false)};
        }
        return this.dataBuffer;
    }

    public void write(OutputStream outputStream) throws SystemException {
        outputStream.write_long(this.id);
        outputStream.write_long(this.data.length);
        outputStream.write_octet_array(this.data, 0, this.data.length);
    }

    public void read(InputStream inputStream) throws SystemException {
        this.id = inputStream.read_long();
        this.len = inputStream.read_long();
        if (inputStream instanceof CDRInputStream) {
            try {
                this.data = new byte[this.len];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new MARSHAL("Encountered malformed request while reading service context of len " + this.len, 1229126034, CompletionStatus.COMPLETED_NO);
            }
            inputStream.read_octet_array(this.data, 0, this.len);
        } else {
            assert (inputStream instanceof CDRInputHandler);
            CDRInputHandler cDRInputHandler = (CDRInputHandler)inputStream;
            BufferHandler bufferHandler = cDRInputHandler.getBufferHandler();
            BufferMarker bufferMarker = bufferHandler.startRecord();
            cDRInputHandler.skip(this.len);
            this.dataBuffer = bufferHandler.endRecord(bufferMarker);
        }
    }

    protected void finalize() throws Throwable {
        if (this.dataBuffer != null) {
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.dataBuffer);
            this.dataBuffer = null;
        }
    }
}

