/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.nio;

import com.ibm.CORBA.ras.HexFormatter;
import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.BufferHandler;
import com.ibm.jtc.orb.nio.BufferHandlerHelper;
import com.ibm.jtc.orb.nio.BufferMarker;
import com.ibm.rmi.iiop.Connection;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import com.ibm.wsspi.buffermgmt.WsByteBufferUtils;
import java.nio.ByteOrder;
import org.omg.CORBA.ORB;

public class SimpleBufferHandler
implements BufferHandler {
    private static final String CLASS = SimpleBufferHandler.class.getName();
    private final Connection conn;
    private final ORB orb;
    private WsByteBuffer[] buffers;
    private int bufferIndex;
    private int streamPosAtBufferStart;
    private int streamSize;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;

    public SimpleBufferHandler(ORB oRB, Connection connection) {
        this.orb = oRB;
        this.conn = connection;
    }

    public SimpleBufferHandler(ORB oRB, Connection connection, WsByteBuffer[] wsByteBufferArray) {
        this.orb = oRB;
        this.conn = connection;
        this.setBuffers(wsByteBufferArray);
    }

    public void setBuffer(WsByteBuffer wsByteBuffer) {
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[]{wsByteBuffer};
        wsByteBuffer.order(this.byteOrder);
        if (wsByteBuffer.position() != 0) {
            wsByteBufferArray[0] = wsByteBuffer.slice();
            wsByteBuffer.release();
            wsByteBuffer = wsByteBufferArray[0];
        }
        this.streamSize = wsByteBuffer.limit();
        this.bufferIndex = 0;
        this.streamPosAtBufferStart = 0;
        this.buffers = wsByteBufferArray;
    }

    public void setBuffers(WsByteBuffer[] wsByteBufferArray) {
        BufferHandlerHelper.setByteOrder(wsByteBufferArray, this.byteOrder);
        BufferHandlerHelper.slice(wsByteBufferArray);
        this.streamSize = WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
        this.bufferIndex = 0;
        this.streamPosAtBufferStart = 0;
        this.streamSize = WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
        this.buffers = wsByteBufferArray;
    }

    public void addNextBuffer(WsByteBuffer wsByteBuffer) {
        wsByteBuffer.order(this.buffers[0].order());
        if (wsByteBuffer.position() != 0) {
            WsByteBuffer wsByteBuffer2 = wsByteBuffer.slice();
            wsByteBuffer.release();
            wsByteBuffer = wsByteBuffer2;
        }
        this.streamSize += wsByteBuffer.limit();
        this.buffers = WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.buffers, (WsByteBuffer)wsByteBuffer);
        this.getNextBuffer(1);
        Trc.info(Trc.array(this.buffers), CLASS, "addNextBuffer:126");
    }

    public void addNextBuffers(WsByteBuffer[] wsByteBufferArray) {
        BufferHandlerHelper.setByteOrder(wsByteBufferArray, this.byteOrder);
        BufferHandlerHelper.slice(wsByteBufferArray);
        this.streamSize += WsByteBufferUtils.lengthOf((WsByteBuffer[])wsByteBufferArray);
        this.buffers = WsByteBufferUtils.expandBufferArray((WsByteBuffer[])this.buffers, (WsByteBuffer[])wsByteBufferArray);
        this.getNextBuffer(1);
    }

    public BufferMarker startRecord() {
        return this.mark();
    }

    public WsByteBuffer[] endRecord(BufferMarker bufferMarker) {
        BufferMarker bufferMarker2 = this.mark();
        return BufferHandlerHelper.getRecord(this, bufferMarker, bufferMarker2);
    }

    public WsByteBuffer getBuffer() {
        return this.buffers == null ? null : this.buffers[this.bufferIndex];
    }

    public WsByteBuffer getNextBuffer(int n) {
        while (this.getBuffer().remaining() == 0) {
            if (this.bufferIndex == this.buffers.length - 1) {
                return null;
            }
            this.streamPosAtBufferStart += this.getBuffer().limit();
            ++this.bufferIndex;
        }
        return this.buffers[this.bufferIndex];
    }

    public WsByteBuffer getPreviousBuffer() {
        if (this.bufferIndex == 0) {
            return null;
        }
        this.getBuffer().rewind();
        WsByteBuffer wsByteBuffer = this.buffers[--this.bufferIndex];
        this.streamPosAtBufferStart -= wsByteBuffer.limit();
        return wsByteBuffer;
    }

    public void releaseBuffer() {
        if (this.buffers != null) {
            WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.buffers);
            this.buffers = null;
            this.streamPosAtBufferStart = 0;
        }
    }

    public int getStreamPosition() {
        return this.streamPosAtBufferStart + (this.getBuffer() == null ? 0 : this.getBuffer().position());
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        BufferHandlerHelper.setByteOrder(this.buffers, byteOrder);
    }

    public int available() {
        return this.getSize() - this.getStreamPosition();
    }

    public int getSize() {
        return this.streamSize;
    }

    public void mark(BufferMarker bufferMarker) {
        int n = this.getBuffer().position();
        int n2 = this.getStreamPosition();
        bufferMarker.setMark(n2, this.bufferIndex, n);
    }

    public void reset(BufferMarker bufferMarker) {
        int n = bufferMarker.getArrayIndex();
        assert (n <= this.bufferIndex);
        while (this.bufferIndex >= 0 && n < this.bufferIndex) {
            this.getPreviousBuffer();
        }
        this.getBuffer().position(bufferMarker.getBufferIndex());
    }

    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public WsByteBuffer[] getFlippedBuffers() {
        WsByteBufferUtils.flip((WsByteBuffer[])this.buffers);
        return this.buffers;
    }

    public WsByteBuffer[] getFlippedReadOnlyBuffers() {
        WsByteBuffer[] wsByteBufferArray = new WsByteBuffer[this.bufferIndex + 1];
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            wsByteBufferArray[i] = this.buffers[i].duplicate().flip();
            wsByteBufferArray[i].setReadOnly(true);
        }
        return wsByteBufferArray;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public ORB getORB() {
        return this.orb;
    }

    private BufferMarker mark() {
        int n = this.getBuffer().position();
        int n2 = this.getStreamPosition();
        return new BufferMarker(n2, this.bufferIndex, n);
    }

    public String toString() {
        return HexFormatter.format(this.getBuffers(), this.getBuffer());
    }
}

