/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.nio;

import com.ibm.CORBA.ras.Trc;
import com.ibm.jtc.orb.nio.BufferHandler;
import com.ibm.jtc.orb.nio.BufferMarker;
import com.ibm.jtc.orb.nio.ByteBufferUtils;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class BufferHandlerHelper {
    private static final String CLASS = BufferHandlerHelper.class.getName();
    private static WsByteBuffer NULL_BUF = WsByteBufferPoolManagerImpl.getRef().wrap(ByteBuffer.allocate(0));

    public static void setByteOrder(WsByteBuffer[] wsByteBufferArray, ByteOrder byteOrder) {
        if (wsByteBufferArray[0].order() != byteOrder) {
            ByteBufferUtils.setByteOrder(wsByteBufferArray, byteOrder);
        }
    }

    public static void slice(WsByteBuffer[] wsByteBufferArray) {
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            if (wsByteBufferArray[i].position() == 0) continue;
            WsByteBuffer wsByteBuffer = wsByteBufferArray[i];
            wsByteBufferArray[i] = wsByteBuffer.slice();
            wsByteBuffer.release();
        }
    }

    public static WsByteBuffer ensureCapacity(BufferHandler bufferHandler, int n) {
        WsByteBuffer wsByteBuffer = bufferHandler.getBuffer();
        if (wsByteBuffer.remaining() < n) {
            wsByteBuffer.limit(wsByteBuffer.position());
            wsByteBuffer = bufferHandler.getNextBuffer(n);
        }
        return wsByteBuffer;
    }

    public static int skip(BufferHandler bufferHandler, int n) {
        int n2 = 0;
        WsByteBuffer wsByteBuffer = bufferHandler.getBuffer();
        if (wsByteBuffer == null) {
            return 0;
        }
        if (n > 0) {
            int n3 = wsByteBuffer.remaining();
            while (n > n3) {
                wsByteBuffer.position(wsByteBuffer.limit());
                n2 += n3;
                Trc.info("only ", Trc.str(n3), " bytes in current buffer.  Need to skip a further ", Trc.str(n -= n3), " bytes.", CLASS, "skip:109");
                wsByteBuffer = bufferHandler.getNextBuffer(n);
                if (wsByteBuffer == null) {
                    return n2;
                }
                n3 = wsByteBuffer.remaining();
            }
            wsByteBuffer.position(wsByteBuffer.position() + n);
            n2 += n;
            Trc.info("Skipped ", Trc.str(n), " out of ", Trc.str(n3), " bytes into current buffer", CLASS, "skip:122");
        } else if (n < 0) {
            n2 = n;
            while (true) {
                int n4;
                if ((n4 = wsByteBuffer.position()) + n >= 0) {
                    wsByteBuffer.position(n4 + n);
                    n = 0;
                    break;
                }
                n += n4;
                wsByteBuffer.rewind();
                wsByteBuffer = bufferHandler.getPreviousBuffer();
            }
        }
        return n2;
    }

    public static WsByteBuffer[] copyRecord(WsByteBuffer[] wsByteBufferArray, int n, int n2, int n3) {
        int n4 = wsByteBufferArray[n3].position();
        Trc.info("sourceData ", Trc.array(wsByteBufferArray), " startPosition=", Trc.str(n), " startOffset=", Trc.str(n2), " endOffset=", Trc.str(n3), " endPosition=", Trc.str(n4), CLASS, "copyRecord:156");
        WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[n3 - n2 + 1];
        int n5 = n2;
        int n6 = 0;
        int n7 = wsByteBufferArray[n5].position();
        wsByteBufferArray[n5].position(n);
        wsByteBufferArray2[n6] = wsByteBufferArray[n5].slice();
        wsByteBufferArray[n5].position(n7);
        if (n2 != n3) {
            do {
                wsByteBufferArray2[++n6] = wsByteBufferArray[++n5].duplicate().position(0);
            } while (n5 < n3);
        } else {
            n4 -= n;
        }
        wsByteBufferArray2[n6].limit(n4);
        Trc.info("return ", Trc.array(wsByteBufferArray2), CLASS, "copyRecord:187");
        return wsByteBufferArray2;
    }

    public static WsByteBuffer[] cutRecord(WsByteBuffer[] wsByteBufferArray, int n, int n2, int n3) {
        return BufferHandlerHelper.getRecord(wsByteBufferArray, n, n2, n3, false);
    }

    private static WsByteBuffer[] getRecord(WsByteBuffer[] wsByteBufferArray, int n, int n2, int n3, boolean bl) {
        int n4;
        WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[n3 - n2 + 1];
        int n5 = wsByteBufferArray[n3].position();
        if (n == 0) {
            wsByteBufferArray2[0] = wsByteBufferArray[n2];
            if (bl) {
                wsByteBufferArray2[0] = wsByteBufferArray2[0].duplicate();
            } else {
                wsByteBufferArray[n2] = NULL_BUF;
            }
        } else {
            wsByteBufferArray[n2].position(n);
            wsByteBufferArray2[0] = wsByteBufferArray[n2].slice();
            wsByteBufferArray2[0].position(wsByteBufferArray2[0].limit());
            if (bl) {
                wsByteBufferArray[n2].position(wsByteBufferArray[n2].limit());
            } else {
                wsByteBufferArray[n2].limit(n);
            }
        }
        if (n2 != n3) {
            for (n4 = 1; n4 < n3 - n2 - 1; ++n4) {
                wsByteBufferArray2[n4] = wsByteBufferArray[n4 + n2];
                if (bl) {
                    wsByteBufferArray2[n4] = wsByteBufferArray2[n4].duplicate();
                    continue;
                }
                wsByteBufferArray[n4 + n2] = NULL_BUF;
            }
            wsByteBufferArray2[n4] = wsByteBufferArray[n3];
        } else {
            wsByteBufferArray[n3].position(n5);
        }
        n4 = wsByteBufferArray2.length - 1;
        if (n3 == n2) {
            n5 -= n;
        }
        if (n5 == wsByteBufferArray2[n4].limit()) {
            if (bl) {
                wsByteBufferArray2[n4] = wsByteBufferArray2[n4].duplicate();
            } else {
                wsByteBufferArray[n3] = NULL_BUF;
            }
        } else {
            if (bl) {
                wsByteBufferArray2[n4] = wsByteBufferArray2[n4].duplicate();
            } else {
                wsByteBufferArray[n3] = wsByteBufferArray2[n4].slice();
            }
            wsByteBufferArray2[n4].limit(n5);
        }
        return wsByteBufferArray2;
    }

    public static WsByteBuffer[] getRecord(BufferHandler bufferHandler, BufferMarker bufferMarker, BufferMarker bufferMarker2) {
        WsByteBuffer[] wsByteBufferArray = BufferHandlerHelper.copyRecord(bufferHandler.getBuffers(), bufferMarker.getBufferIndex(), bufferMarker.getArrayIndex(), bufferMarker2.getArrayIndex());
        return wsByteBufferArray;
    }
}

