/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.internal.rowset;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.RowSetInternal;
import javax.sql.RowSetWriter;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.spi.SyncProviderException;
import org.apache.harmony.sql.internal.rowset.CachedRowSetImpl;

public class CachedRowSetWriter
implements RowSetWriter {
    private CachedRowSet originalRowSet;
    private CachedRowSetImpl currentRowSet;
    private Connection originalConnection;
    private String tableName;
    private String[] colNames;
    private int columnCount;

    public void setConnection(Connection connection) {
        this.originalConnection = connection;
    }

    public Connection getConnection() {
        return this.originalConnection;
    }

    @Override
    public boolean writeData(RowSetInternal rowSetInternal) throws SQLException {
        this.initial(rowSetInternal);
        this.currentRowSet.beforeFirst();
        this.originalRowSet.beforeFirst();
        while (this.currentRowSet.next()) {
            if (this.currentRowSet.rowInserted()) {
                this.insertCurrentRow();
                continue;
            }
            if (this.currentRowSet.rowDeleted()) {
                if (this.isConflictExistForCurrentRow()) {
                    throw new SyncProviderException();
                }
                this.deleteCurrentRow();
                continue;
            }
            if (!this.currentRowSet.rowUpdated()) continue;
            if (this.isConflictExistForCurrentRow()) {
                throw new SyncProviderException();
            }
            this.updateCurrentRow();
        }
        return true;
    }

    private void insertCurrentRow() throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("INSERT INTO " + this.tableName + "(");
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        Object[] objectArray = new Object[this.columnCount];
        int n2 = 0;
        for (int i = 1; i <= this.columnCount; ++i) {
            n = this.currentRowSet.columnUpdated(i);
            if (n == 0) continue;
            stringBuffer2.append(this.colNames[i - 1] + ",");
            stringBuffer3.append("?,");
            objectArray[n2] = this.currentRowSet.getObject(i);
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        stringBuffer.append(this.subStringN(stringBuffer2.toString(), 1));
        stringBuffer.append(") values (");
        stringBuffer.append(this.subStringN(stringBuffer3.toString(), 1));
        stringBuffer.append(")");
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(stringBuffer.toString());
        for (n = 0; n < n2; ++n) {
            preparedStatement.setObject(n + 1, objectArray[n]);
        }
        try {
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException();
        }
        finally {
            preparedStatement.close();
        }
    }

    private void deleteCurrentRow() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("DELETE FROM " + this.tableName + " WHERE ");
        stringBuffer.append(this.generateQueryCondition());
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(stringBuffer.toString());
        this.fillParamInPreStatement(preparedStatement, 1);
        preparedStatement.executeUpdate();
    }

    private void updateCurrentRow() throws SQLException {
        int n;
        StringBuffer stringBuffer = new StringBuffer("UPDATE " + this.tableName + " SET ");
        StringBuffer stringBuffer2 = new StringBuffer();
        Object[] objectArray = new Object[this.columnCount];
        int[] nArray = new int[this.columnCount];
        int n2 = 0;
        for (int i = 1; i <= this.columnCount; ++i) {
            n = this.currentRowSet.columnUpdated(i);
            if (n == 0) continue;
            stringBuffer2.append(this.colNames[i - 1] + " = ?, ");
            objectArray[n2] = this.currentRowSet.getObject(i);
            nArray[n2] = i;
            ++n2;
        }
        if (n2 == 0) {
            return;
        }
        stringBuffer.append(this.subStringN(stringBuffer2.toString(), 2));
        stringBuffer.append(" WHERE ");
        stringBuffer.append(this.generateQueryCondition());
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(stringBuffer.toString());
        for (n = 0; n < n2; ++n) {
            if (objectArray[n] == null) {
                preparedStatement.setNull(n + 1, this.currentRowSet.getMetaData().getColumnType(nArray[n]));
                continue;
            }
            preparedStatement.setObject(n + 1, objectArray[n]);
        }
        this.fillParamInPreStatement(preparedStatement, n2 + 1);
        try {
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw new SyncProviderException();
        }
        finally {
            preparedStatement.close();
        }
    }

    private void initial(RowSetInternal rowSetInternal) throws SQLException {
        this.currentRowSet = (CachedRowSetImpl)rowSetInternal;
        this.originalRowSet = (CachedRowSet)this.currentRowSet.getOriginal();
        this.tableName = this.currentRowSet.getTableName();
        this.columnCount = this.currentRowSet.getMetaData().getColumnCount();
        this.colNames = new String[this.columnCount];
        for (int i = 1; i <= this.columnCount; ++i) {
            this.colNames[i - 1] = this.currentRowSet.getMetaData().getColumnName(i);
        }
    }

    private boolean isConflictExistForCurrentRow() throws SQLException {
        boolean bl = true;
        this.originalRowSet.absolute(this.currentRowSet.getRow());
        StringBuffer stringBuffer = new StringBuffer("SELECT COUNT(*) FROM " + this.tableName + " WHERE ");
        stringBuffer.append(this.generateQueryCondition());
        PreparedStatement preparedStatement = this.getConnection().prepareStatement(stringBuffer.toString());
        this.fillParamInPreStatement(preparedStatement, 1);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next() && resultSet.getInt(1) == 1) {
            bl = false;
        }
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    private String generateQueryCondition() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(" ");
        for (int i = 0; i < this.colNames.length; ++i) {
            if (this.originalRowSet.getObject(i + 1) == null) {
                stringBuffer.append(this.colNames[i] + " is null ");
            } else {
                stringBuffer.append(this.colNames[i] + " = ? ");
            }
            if (i == this.colNames.length - 1) continue;
            stringBuffer.append(" and ");
        }
        return stringBuffer.toString();
    }

    private void fillParamInPreStatement(PreparedStatement preparedStatement, int n) throws SQLException {
        int n2 = n;
        for (int i = 1; i <= this.columnCount; ++i) {
            if (this.originalRowSet.getObject(i) == null) continue;
            preparedStatement.setObject(n2, this.originalRowSet.getObject(i));
            ++n2;
        }
    }

    private String subStringN(String string, int n) {
        return string.substring(0, string.length() - n);
    }
}

