/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.sql.internal.rowset;

import java.sql.SQLException;
import java.util.BitSet;

public class CachedRow
implements Cloneable {
    private Object[] columnData;
    private Object[] originalColumnData;
    private BitSet mask;
    private boolean isDelete;
    private boolean isInsert;
    private boolean isUpdate;
    private boolean nonUpdateable = false;

    public CachedRow(Object[] objectArray) {
        this.columnData = (Object[])objectArray.clone();
        this.originalColumnData = (Object[])objectArray.clone();
        this.mask = new BitSet(objectArray.length);
    }

    public boolean getUpdateMask(int n) {
        return this.mask.get(n);
    }

    public void setUpdateMask(int n) {
        this.mask.set(n);
    }

    public void setUnavailable() {
        this.setDelete();
        this.setInsert();
        this.mask.clear();
        this.mask.flip(0, this.columnData.length);
    }

    public void setNonUpdateable() {
        this.nonUpdateable = true;
    }

    public boolean getNonUpdateable() {
        return this.nonUpdateable;
    }

    public void setDelete() {
        this.isDelete = true;
        this.isUpdate = false;
        this.isInsert = false;
    }

    public void undoDelete() {
        this.isDelete = false;
    }

    public boolean isDelete() {
        return this.isDelete;
    }

    public void setInsert() {
        this.isInsert = true;
        this.isUpdate = false;
        this.isDelete = false;
    }

    public boolean isInsert() {
        return this.isInsert;
    }

    public void setUpdate() {
        this.isUpdate = true;
        this.isInsert = false;
        this.isDelete = false;
    }

    public void undoUpdate() {
        this.isUpdate = false;
        this.mask.flip(0, this.columnData.length);
        this.columnData = (Object[])this.originalColumnData.clone();
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void updateObject(int n, Object object) throws SQLException {
        if (this.nonUpdateable) {
            throw new SQLException("Not Updateable of the CurrentRow");
        }
        this.columnData[n - 1] = object;
        this.setUpdateMask(n - 1);
    }

    public CachedRow getOriginal() {
        return new CachedRow(this.originalColumnData);
    }

    public Object getObject(int n) {
        return this.columnData[n - 1];
    }

    public CachedRow createClone() throws CloneNotSupportedException {
        CachedRow cachedRow = (CachedRow)super.clone();
        Object[] objectArray = new Object[this.columnData.length];
        for (int i = 0; i < this.columnData.length; ++i) {
            objectArray[i] = this.columnData[i];
        }
        cachedRow.columnData = objectArray;
        cachedRow.isInsert = this.isInsert;
        cachedRow.isDelete = this.isDelete;
        cachedRow.isUpdate = this.isUpdate;
        cachedRow.mask = (BitSet)this.mask.clone();
        cachedRow.nonUpdateable = this.nonUpdateable;
        return cachedRow;
    }
}

