/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.spi;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.sql.rowset.spi.ProviderImpl;
import javax.sql.rowset.spi.SyncFactoryException;
import javax.sql.rowset.spi.SyncProvider;
import org.apache.harmony.sql.internal.nls.Messages;

public class SyncFactory {
    public static String ROWSET_SYNC_PROVIDER = "rowset.provider.classname";
    public static String ROWSET_SYNC_VENDOR = "rowset.provider.vendor";
    public static String ROWSET_SYNC_PROVIDER_VERSION = "rowset.provider.version";
    private static SyncFactory instance = new SyncFactory();
    private static final String ROWSET_PROPERTIES = "javax/sql/rowset/rowset.properties";
    private static Hashtable<String, SyncProvider> providers = new Hashtable();
    private static Context ctx;
    private static String resLocation;
    private static String defaultProviderName;
    private static ProviderImpl defaultProvider;
    private static Logger logger;
    private static boolean initialized;

    private static String getProviderProperties(Properties properties, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(".");
        stringBuilder.append(n);
        return properties.getProperty(stringBuilder.toString());
    }

    private static Enumeration<SyncProvider> getRegisteredProvidersImpl() {
        if (!initialized) {
            Object object;
            Object object2;
            String string = System.getProperty(ROWSET_SYNC_PROVIDER);
            if (string != null) {
                for (Object object3 : object2 = string.split(":")) {
                    providers.put((String)object3, new ProviderImpl((String)object3));
                }
            }
            object2 = new Properties();
            try {
                JarFile jarFile = new JarFile(resLocation);
                InputStream inputStream = jarFile.getInputStream(jarFile.getJarEntry(ROWSET_PROPERTIES));
                ((Properties)object2).load(inputStream);
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int n = 0;
            while (null != (object = SyncFactory.getProviderProperties((Properties)object2, ROWSET_SYNC_PROVIDER, n))) {
                Object object3;
                String string2 = SyncFactory.getProviderProperties((Properties)object2, ROWSET_SYNC_VENDOR, n);
                object3 = SyncFactory.getProviderProperties((Properties)object2, ROWSET_SYNC_PROVIDER_VERSION, n);
                providers.put((String)object, new ProviderImpl((String)object, string2, (String)object3));
                ++n;
            }
            if (ctx != null) {
                try {
                    object = ctx.listBindings("");
                    while (object.hasMore()) {
                        Binding binding = (Binding)object.next();
                        providers.put(binding.getName(), (SyncProvider)binding.getObject());
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            initialized = true;
        }
        return providers.elements();
    }

    private static void initProviders() {
        if (providers.isEmpty()) {
            SyncFactory.getRegisteredProvidersImpl();
        }
    }

    private SyncFactory() {
    }

    public static void registerProvider(String string) throws SyncFactoryException {
        if (null == string || string.length() == 0) {
            throw new SyncFactoryException();
        }
        SyncFactory.initProviders();
        providers.put(string, new ProviderImpl(string));
    }

    public static SyncFactory getSyncFactory() {
        return instance;
    }

    public static void unregisterProvider(String string) throws SyncFactoryException {
        SyncFactory.initProviders();
        if (null == providers.remove(string)) {
            throw new SyncFactoryException();
        }
    }

    public static SyncProvider getInstance(String string) throws SyncFactoryException {
        SyncFactory.initProviders();
        SyncProvider syncProvider = providers.get(string);
        if (null == syncProvider) {
            return defaultProvider.getImpl();
        }
        return ((ProviderImpl)syncProvider).getImpl();
    }

    public static Enumeration<SyncProvider> getRegisteredProviders() throws SyncFactoryException {
        return SyncFactory.getRegisteredProvidersImpl();
    }

    public static void setLogger(Logger logger) {
        SyncFactory.logger = logger;
    }

    public static void setLogger(Logger logger, Level level) {
        SyncFactory.logger = logger;
        SyncFactory.logger.setLevel(level);
    }

    public static Logger getLogger() throws SyncFactoryException {
        if (null == logger) {
            throw new SyncFactoryException(Messages.getString("sql.44"));
        }
        return logger;
    }

    public static void setJNDIContext(Context context) throws SyncFactoryException {
        if (null == context) {
            throw new SyncFactoryException(Messages.getString("sql.41"));
        }
        ctx = context;
    }

    static {
        defaultProviderName = "com.sun.rowset.providers.RIOptimisticProvider";
        defaultProvider = new ProviderImpl(defaultProviderName);
        resLocation = System.getProperty("java.home") + System.getProperty("file.separator") + "lib" + System.getProperty("file.separator") + "resources.jar";
    }
}

