/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import javax.sql.rowset.serial.SerialException;
import org.apache.harmony.sql.internal.nls.Messages;

public class SerialClob
implements Clob,
Serializable,
Cloneable {
    private static final long serialVersionUID = -1662519690087375313L;
    private char[] buf;
    private Clob clob;
    private long len;
    private long origLen;

    public SerialClob(char[] cArray) throws SerialException, SQLException {
        this.buf = new char[cArray.length];
        this.len = this.origLen = (long)cArray.length;
        System.arraycopy(cArray, 0, this.buf, 0, (int)this.len);
    }

    public SerialClob(Clob clob) throws SerialException, SQLException {
        if (clob == null) {
            throw new SQLException(Messages.getString("sql.19"));
        }
        Reader reader = clob.getCharacterStream();
        if (reader == null && clob.getAsciiStream() == null) {
            throw new SQLException(Messages.getString("sql.20"));
        }
        this.clob = clob;
        this.len = this.origLen = clob.length();
        this.buf = new char[(int)this.len];
        try {
            reader.read(this.buf);
        }
        catch (IOException iOException) {
            SerialException serialException = new SerialException("SerialClob: " + iOException.getMessage());
            serialException.initCause(iOException);
            throw serialException;
        }
    }

    @Override
    public long length() throws SerialException {
        this.checkValidation();
        return this.len;
    }

    @Override
    public InputStream getAsciiStream() throws SerialException, SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new SerialException(Messages.getString("sql.25"));
        }
        return this.clob.getAsciiStream();
    }

    @Override
    public Reader getCharacterStream() throws SerialException {
        this.checkValidation();
        return new CharArrayReader(this.buf);
    }

    @Override
    public String getSubString(long l, int n) throws SerialException {
        this.checkValidation();
        if (l < 1L || l > this.len) {
            throw new SerialException(Messages.getString("sql.21"));
        }
        if (n < 0 || l + (long)n > this.len + 1L) {
            throw new SerialException(Messages.getString("sql.22"));
        }
        try {
            return new String(this.buf, (int)(l - 1L), n);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new SerialException();
        }
    }

    @Override
    public long position(Clob clob, long l) throws SerialException, SQLException {
        this.checkValidation();
        String string = clob.getSubString(1L, (int)clob.length());
        return this.position(string, l);
    }

    @Override
    public long position(String string, long l) throws SerialException, SQLException {
        this.checkValidation();
        if (l < 1L || this.len - (l - 1L) < (long)string.length()) {
            return -1L;
        }
        char[] cArray = string.toCharArray();
        int n = (int)l - 1;
        while ((long)n < this.len) {
            if (this.match(this.buf, n, cArray)) {
                return n + 1;
            }
            ++n;
        }
        return -1L;
    }

    private boolean match(char[] cArray, int n, char[] cArray2) {
        int n2 = 0;
        while (n2 < cArray2.length) {
            if (cArray[n++] == cArray2[n2++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public OutputStream setAsciiStream(long l) throws SerialException, SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new SerialException(Messages.getString("sql.25"));
        }
        OutputStream outputStream = this.clob.setAsciiStream(l);
        if (outputStream == null) {
            throw new SerialException(Messages.getString("sql.46"));
        }
        return outputStream;
    }

    @Override
    public Writer setCharacterStream(long l) throws SerialException, SQLException {
        this.checkValidation();
        if (this.clob == null) {
            throw new SerialException(Messages.getString("sql.25"));
        }
        Writer writer = this.clob.setCharacterStream(l);
        if (writer == null) {
            throw new SerialException(Messages.getString("sql.45"));
        }
        return writer;
    }

    @Override
    public int setString(long l, String string) throws SerialException {
        this.checkValidation();
        return this.setString(l, string, 0, string.length());
    }

    @Override
    public int setString(long l, String string, int n, int n2) throws SerialException {
        this.checkValidation();
        if (l < 1L || n2 < 0 || l > this.len - (long)n2 + 1L) {
            throw new SerialException(Messages.getString("sql.21"));
        }
        if (n < 0 || n > string.length() - n2) {
            throw new SerialException(Messages.getString("sql.21"));
        }
        if ((long)n2 > this.len + (long)n) {
            throw new SerialException(Messages.getString("sql.23"));
        }
        string.getChars(n, n + n2, this.buf, (int)l - 1);
        return n2;
    }

    @Override
    public void truncate(long l) throws SerialException {
        this.checkValidation();
        if (l > this.len || l < 0L) {
            throw new SerialException(Messages.getString("sql.24"));
        }
        char[] cArray = new char[(int)l];
        System.arraycopy(this.buf, 0, cArray, 0, (int)l);
        this.buf = cArray;
        this.len = l;
    }

    @Override
    public void free() throws SQLException {
        if (this.len != -1L) {
            this.len = -1L;
            this.clob = null;
            this.buf = null;
        }
    }

    @Override
    public Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkValidation();
        return new CharArrayReader(this.buf, (int)l, (int)l2);
    }

    private void checkValidation() throws SerialException {
        if (this.len == -1L) {
            throw new SerialException(Messages.getString("sql.38"));
        }
    }
}

