/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialDatalink;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.serial.SerialStruct;
import org.apache.harmony.sql.internal.nls.Messages;

public class SQLOutputImpl
implements SQLOutput {
    private Vector attributes;
    private Map map;

    public SQLOutputImpl(Vector<?> vector, Map<String, ?> map) throws SQLException {
        if (null == vector || null == map) {
            throw new SQLException(Messages.getString("sql.33"));
        }
        this.attributes = vector;
        this.map = map;
    }

    @Override
    public void writeArray(Array array) throws SQLException {
        if (array != null) {
            SerialArray serialArray = new SerialArray(array, this.map);
            this.attributes.addElement(serialArray);
        } else {
            this.attributes.addElement(array);
        }
    }

    @Override
    public void writeAsciiStream(InputStream inputStream) throws SQLException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            this.attributes.addElement(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new SQLException();
        }
    }

    @Override
    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.attributes.addElement(bigDecimal);
    }

    @Override
    public void writeBinaryStream(InputStream inputStream) throws SQLException {
        this.writeAsciiStream(inputStream);
    }

    @Override
    public void writeBlob(Blob blob) throws SQLException {
        if (blob != null) {
            SerialBlob serialBlob = new SerialBlob(blob);
            this.attributes.addElement(serialBlob);
        } else {
            this.attributes.addElement(blob);
        }
    }

    @Override
    public void writeBoolean(boolean bl) throws SQLException {
        this.attributes.addElement(bl);
    }

    @Override
    public void writeByte(byte by) throws SQLException {
        this.attributes.addElement(by);
    }

    @Override
    public void writeBytes(byte[] byArray) throws SQLException {
        this.attributes.addElement(byArray);
    }

    @Override
    public void writeCharacterStream(Reader reader) throws SQLException {
        BufferedReader bufferedReader = new BufferedReader(reader);
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string);
                string = bufferedReader.readLine();
            }
            this.attributes.addElement(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw new SQLException();
        }
    }

    @Override
    public void writeClob(Clob clob) throws SQLException {
        if (clob != null) {
            SerialClob serialClob = new SerialClob(clob);
            this.attributes.addElement(serialClob);
        } else {
            this.attributes.addElement(clob);
        }
    }

    @Override
    public void writeDate(Date date) throws SQLException {
        this.attributes.addElement(date);
    }

    @Override
    public void writeDouble(double d) throws SQLException {
        this.attributes.addElement(d);
    }

    @Override
    public void writeFloat(float f) throws SQLException {
        this.attributes.addElement(Float.valueOf(f));
    }

    @Override
    public void writeInt(int n) throws SQLException {
        this.attributes.addElement(n);
    }

    @Override
    public void writeLong(long l) throws SQLException {
        this.attributes.addElement(l);
    }

    @Override
    public void writeObject(SQLData sQLData) throws SQLException {
        if (sQLData == null) {
            this.attributes.addElement(null);
        } else {
            this.attributes.addElement(new SerialStruct(sQLData, new HashMap(this.map)));
        }
    }

    @Override
    public void writeRef(Ref ref) throws SQLException {
        if (ref != null) {
            SerialRef serialRef = new SerialRef(ref);
            this.attributes.addElement(serialRef);
        } else {
            this.attributes.addElement(ref);
        }
    }

    @Override
    public void writeShort(short s) throws SQLException {
        this.attributes.addElement(s);
    }

    @Override
    public void writeString(String string) throws SQLException {
        this.attributes.addElement(string);
    }

    @Override
    public void writeStruct(Struct struct) throws SQLException {
        if (struct != null) {
            SerialStruct serialStruct = new SerialStruct(struct, this.map);
            this.attributes.addElement(serialStruct);
        } else {
            this.attributes.addElement(struct);
        }
    }

    @Override
    public void writeTime(Time time) throws SQLException {
        this.attributes.addElement(time);
    }

    @Override
    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.attributes.addElement(timestamp);
    }

    @Override
    public void writeURL(URL uRL) throws SQLException {
        if (uRL != null) {
            SerialDatalink serialDatalink = new SerialDatalink(uRL);
            this.attributes.addElement(serialDatalink);
        } else {
            this.attributes.addElement(uRL);
        }
    }

    @Override
    public void writeNClob(NClob nClob) throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("sql.37"));
    }

    @Override
    public void writeNString(String string) throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("sql.37"));
    }

    @Override
    public void writeRowId(RowId rowId) throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("sql.37"));
    }

    @Override
    public void writeSQLXML(SQLXML sQLXML) throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("sql.37"));
    }
}

