/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.harmony.sql.internal.nls.Messages;

public class SQLInputImpl
implements SQLInput {
    private Object[] attributes;
    private Map<String, Class<?>> map;
    private int readPosition = 0;

    public SQLInputImpl(Object[] objectArray, Map<String, Class<?>> map) throws SQLException {
        if (null == objectArray || null == map) {
            throw new SQLException(Messages.getString("sql.34"));
        }
        this.attributes = objectArray;
        this.map = map;
    }

    @Override
    public Array readArray() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (Array)object;
    }

    @Override
    public InputStream readAsciiStream() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (InputStream)object;
    }

    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (BigDecimal)object;
    }

    @Override
    public InputStream readBinaryStream() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (InputStream)object;
    }

    @Override
    public Blob readBlob() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (Blob)object;
    }

    @Override
    public boolean readBoolean() throws SQLException {
        Object object;
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        return (object = this.attributes[this.readPosition++]) == null ? false : (Boolean)object;
    }

    @Override
    public byte readByte() throws SQLException {
        Object object;
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        return (object = this.attributes[this.readPosition++]) == null ? (byte)0 : (Byte)object;
    }

    @Override
    public byte[] readBytes() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (byte[])object;
    }

    @Override
    public Reader readCharacterStream() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (Reader)object;
    }

    @Override
    public Clob readClob() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (Clob)object;
    }

    @Override
    public Date readDate() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (Date)object;
    }

    @Override
    public double readDouble() throws SQLException {
        Object object;
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        return (object = this.attributes[this.readPosition++]) == null ? 0.0 : (Double)object;
    }

    @Override
    public float readFloat() throws SQLException {
        Object object;
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        return (object = this.attributes[this.readPosition++]) == null ? 0.0f : ((Float)object).floatValue();
    }

    @Override
    public int readInt() throws SQLException {
        Object object;
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        return (object = this.attributes[this.readPosition++]) == null ? 0 : (Integer)object;
    }

    @Override
    public long readLong() throws SQLException {
        Object object;
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        return (object = this.attributes[this.readPosition++]) == null ? 0L : (Long)object;
    }

    @Override
    public Object readObject() throws SQLException {
        Struct struct;
        String string;
        Class<?> clazz;
        Object object;
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        if ((object = this.attributes[this.readPosition++]) instanceof Struct && (clazz = this.map.get(string = (struct = (Struct)object).getSQLTypeName())) != null) {
            try {
                SQLData sQLData = (SQLData)clazz.newInstance();
                SQLInputImpl sQLInputImpl = new SQLInputImpl(struct.getAttributes(), this.map);
                sQLData.readSQL(sQLInputImpl, string);
                return sQLData;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(illegalAccessException);
            }
            catch (InstantiationException instantiationException) {
                throw new SQLException(instantiationException);
            }
        }
        return object;
    }

    @Override
    public Ref readRef() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (Ref)object;
    }

    @Override
    public short readShort() throws SQLException {
        Object object;
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        return (object = this.attributes[this.readPosition++]) == null ? (short)0 : (Short)object;
    }

    @Override
    public String readString() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (String)object;
    }

    @Override
    public Time readTime() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (Time)object;
    }

    @Override
    public Timestamp readTimestamp() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        Object object = this.attributes[this.readPosition++];
        return (Timestamp)object;
    }

    @Override
    public URL readURL() throws SQLException {
        if (this.readPosition >= this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        throw new SQLException(Messages.getString("sql.37"));
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.readPosition > this.attributes.length) {
            throw new SQLException(Messages.getString("sql.35"));
        }
        return this.readPosition == 0 ? false : this.attributes[this.readPosition - 1] == null;
    }

    @Override
    public NClob readNClob() throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("sql.37"));
    }

    @Override
    public String readNString() throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("sql.37"));
    }

    @Override
    public RowId readRowId() throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("sql.37"));
    }

    @Override
    public SQLXML readSQLXML() throws SQLException {
        throw new UnsupportedOperationException(Messages.getString("sql.37"));
    }
}

