/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;

public abstract class BaseRowSet
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4886719666485113312L;
    public static final int UNICODE_STREAM_PARAM = 0;
    public static final int BINARY_STREAM_PARAM = 1;
    public static final int ASCII_STREAM_PARAM = 2;
    protected InputStream binaryStream;
    protected InputStream unicodeStream;
    protected InputStream asciiStream;
    protected Reader charStream;
    private String command;
    private String URL;
    private String dataSource;
    private int rowSetType = 1004;
    private boolean showDeleted;
    private int queryTimeout;
    private int maxRows;
    private int maxFieldSize;
    private int concurrency = 1008;
    private boolean readOnly;
    private boolean escapeProcessing;
    private int isolation;
    private int fetchDir = 1000;
    private int fetchSize;
    private Map<String, Class<?>> map;
    private Vector<RowSetListener> listeners = new Vector();
    private Hashtable<Object, Object> params;
    private transient String username;
    private transient String password;

    protected void initParams() {
        this.params = new Hashtable();
    }

    public void addRowSetListener(RowSetListener rowSetListener) {
        if (rowSetListener == null) {
            return;
        }
        this.listeners.add(rowSetListener);
    }

    public void removeRowSetListener(RowSetListener rowSetListener) {
        if (rowSetListener == null) {
            return;
        }
        this.listeners.remove(rowSetListener);
    }

    protected void notifyCursorMoved() throws SQLException {
        if (!(this instanceof RowSet)) {
            throw new SQLException();
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RowSetListener rowSetListener : this.listeners) {
            rowSetListener.cursorMoved(new RowSetEvent((RowSet)((Object)this)));
        }
    }

    protected void notifyRowChanged() throws SQLException {
        if (!(this instanceof RowSet)) {
            throw new SQLException();
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RowSetListener rowSetListener : this.listeners) {
            rowSetListener.rowChanged(new RowSetEvent((RowSet)((Object)this)));
        }
    }

    protected void notifyRowSetChanged() throws SQLException {
        if (!(this instanceof RowSet)) {
            throw new SQLException();
        }
        if (this.listeners.isEmpty()) {
            return;
        }
        for (RowSetListener rowSetListener : this.listeners) {
            rowSetListener.rowSetChanged(new RowSetEvent((RowSet)((Object)this)));
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) throws SQLException {
        if (string != null && string.length() == 0) {
            throw new SQLException();
        }
        this.command = string;
    }

    public String getUrl() throws SQLException {
        return this.URL;
    }

    public void setUrl(String string) throws SQLException {
        if (string != null && string.length() == 0) {
            throw new SQLException();
        }
        this.URL = string;
        this.dataSource = null;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public void setDataSourceName(String string) throws SQLException {
        if (string != null && string.length() == 0) {
            throw new SQLException();
        }
        this.dataSource = string;
        this.URL = null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String string) {
        this.username = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setType(int n) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.rowSetType = n;
                return;
            }
        }
        throw new SQLException();
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public void setConcurrency(int n) throws SQLException {
        switch (n) {
            case 1007: 
            case 1008: {
                this.concurrency = n;
                return;
            }
        }
        throw new SQLException();
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public void setTransactionIsolation(int n) throws SQLException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                this.isolation = n;
                return;
            }
        }
        throw new SQLException();
    }

    public Map<String, Class<?>> getTypeMap() {
        return this.map;
    }

    public void setTypeMap(Map<String, Class<?>> map) {
        this.map = map;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException();
        }
        this.queryTimeout = n;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public void setShowDeleted(boolean bl) throws SQLException {
        this.showDeleted = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        switch (n) {
            case 1001: 
            case 1002: {
                if (this.rowSetType == 1003) {
                    throw new SQLException();
                }
            }
            case 1000: {
                this.fetchDir = n;
                return;
            }
        }
        throw new SQLException();
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public void setFetchSize(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException();
        }
        if (n > this.maxRows) {
            throw new SQLException();
        }
        this.fetchSize = n;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public void setNull(int n, int n2) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[2];
        objectArray[1] = n2;
        this.params.put(n - 1, objectArray);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[3];
        objectArray[1] = n2;
        objectArray[2] = string;
        this.params.put(n - 1, objectArray);
    }

    public void setNull(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNull(String string, int n, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, bl);
    }

    public void setBoolean(String string, boolean bl) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setByte(int n, byte by) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, by);
    }

    public void setByte(String string, byte by) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBytes(String string, byte[] byArray) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setShort(int n, short s) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, s);
    }

    public void setShort(String string, short s) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setInt(int n, int n2) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, n2);
    }

    public void setInt(String string, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setLong(int n, long l) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, l);
    }

    public void setLong(String string, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setFloat(int n, float f) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, Float.valueOf(f));
    }

    public void setFloat(String string, float f) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setDouble(int n, double d) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, d);
    }

    public void setDouble(String string, double d) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, bigDecimal);
    }

    public void setString(int n, String string) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, string);
    }

    public void setString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, byArray);
    }

    public void setDate(int n, Date date) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, date);
    }

    public void setDate(String string, Date date) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setTime(int n, Time time) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, time);
    }

    public void setTime(String string, Time time) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, timestamp);
    }

    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{inputStream, n2, 2};
        this.params.put(n - 1, objectArray);
    }

    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{inputStream, n2, 1};
        this.params.put(n - 1, objectArray);
    }

    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{inputStream, n2, 0};
        this.params.put(n - 1, objectArray);
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{reader, n2};
        this.params.put(n - 1, objectArray);
    }

    public void setCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNCharacterStream(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNString(int n, String string) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNString(String string, String string2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{object, n2, n3};
        this.params.put(n - 1, objectArray);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{object, n2};
        this.params.put(n - 1, objectArray);
    }

    public void setObject(int n, Object object) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, object);
    }

    public void setObject(String string, Object object) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setObject(String string, Object object, int n) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setObject(String string, Object object, int n, int n2) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setRef(int n, Ref ref) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, new SerialRef(ref));
    }

    public void setRowId(int n, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setRowId(String string, RowId rowId) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setSQLXML(int n, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, new SerialBlob(blob));
    }

    public void setBlob(int n, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(String string, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setBlob(String string, Blob blob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(int n, Clob clob) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, new SerialClob(clob));
    }

    public void setClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setClob(String string, Clob clob) throws SQLException {
        if (string == null || this.params == null) {
            throw new SQLException();
        }
        this.params.put(string, clob);
    }

    public void setNClob(int n, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(int n, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(int n, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String string, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String string, Reader reader, long l) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setNClob(String string, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setArray(int n, Array array) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        this.params.put(n - 1, new SerialArray(array));
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{date, calendar};
        this.params.put(n - 1, objectArray);
    }

    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{time, calendar};
        this.params.put(n - 1, objectArray);
    }

    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        if (n < 1) {
            throw new SQLException();
        }
        if (this.params == null) {
            throw new SQLException();
        }
        Object[] objectArray = new Object[]{timestamp, calendar};
        this.params.put(n - 1, objectArray);
    }

    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public void clearParameters() throws SQLException {
        if (this.params == null) {
            return;
        }
        this.params.clear();
    }

    public Object[] getParams() throws SQLException {
        if (this.params == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[this.params.size()];
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = this.params.get(i);
            if (object == null) {
                throw new SQLException();
            }
            objectArray[i] = object;
        }
        return objectArray;
    }
}

