/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.harmony.sql.internal.nls.Messages;

public class Timestamp
extends Date {
    private static final long serialVersionUID = 2745179027874758501L;
    private int nanos;
    private static final String PADDING = "000000000";

    @Deprecated
    public Timestamp(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        super(n, n2, n3, n4, n5, n6);
        if (n7 < 0 || n7 > 999999999) {
            throw new IllegalArgumentException();
        }
        this.nanos = n7;
    }

    public Timestamp(long l) {
        super(l);
        this.setTime(l);
    }

    public boolean after(Timestamp timestamp) {
        long l;
        long l2 = this.getTime();
        if (l2 > (l = timestamp.getTime())) {
            return true;
        }
        if (l2 < l) {
            return false;
        }
        return this.getNanos() > timestamp.getNanos();
    }

    public boolean before(Timestamp timestamp) {
        long l;
        long l2 = this.getTime();
        if (l2 < (l = timestamp.getTime())) {
            return true;
        }
        if (l2 > l) {
            return false;
        }
        return this.getNanos() < timestamp.getNanos();
    }

    @Override
    public int compareTo(Date date) {
        return this.compareTo((Timestamp)date);
    }

    @Override
    public int compareTo(Timestamp timestamp) {
        int n = super.compareTo(timestamp);
        if (n == 0) {
            int n2;
            int n3 = this.getNanos();
            if (n3 > (n2 = timestamp.getNanos())) {
                return 1;
            }
            if (n3 == n2) {
                return 0;
            }
            return -1;
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof Timestamp) {
            return this.equals((Timestamp)object);
        }
        return false;
    }

    public boolean equals(Timestamp timestamp) {
        if (timestamp == null) {
            return false;
        }
        return this.getTime() == timestamp.getTime() && this.getNanos() == timestamp.getNanos();
    }

    public int getNanos() {
        return this.nanos;
    }

    @Override
    public long getTime() {
        long l = super.getTime();
        return l += (long)(this.nanos / 1000000);
    }

    public void setNanos(int n) {
        if (n < 0 || n > 999999999) {
            throw new IllegalArgumentException(Messages.getString("sql.0"));
        }
        this.nanos = n;
    }

    @Override
    public void setTime(long l) {
        int n = (int)(l % 1000L);
        l -= (long)n;
        if (n < 0) {
            l -= 1000L;
            n = 1000 + n;
        }
        super.setTime(l);
        this.setNanos(n * 1000000);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(29);
        this.format(this.getYear() + 1900, 4, stringBuilder);
        stringBuilder.append('-');
        this.format(this.getMonth() + 1, 2, stringBuilder);
        stringBuilder.append('-');
        this.format(this.getDate(), 2, stringBuilder);
        stringBuilder.append(' ');
        this.format(this.getHours(), 2, stringBuilder);
        stringBuilder.append(':');
        this.format(this.getMinutes(), 2, stringBuilder);
        stringBuilder.append(':');
        this.format(this.getSeconds(), 2, stringBuilder);
        stringBuilder.append('.');
        if (this.nanos == 0) {
            stringBuilder.append('0');
        } else {
            this.format(this.nanos, 9, stringBuilder);
            while (stringBuilder.charAt(stringBuilder.length() - 1) == '0') {
                stringBuilder.setLength(stringBuilder.length() - 1);
            }
        }
        return stringBuilder.toString();
    }

    private void format(int n, int n2, StringBuilder stringBuilder) {
        String string = String.valueOf(n);
        if (n2 - string.length() > 0) {
            stringBuilder.append(PADDING.substring(0, n2 - string.length()));
        }
        stringBuilder.append(string);
    }

    public static Timestamp valueOf(String string) {
        int n;
        Date date;
        if (string == null) {
            throw new IllegalArgumentException(Messages.getString("sql.3"));
        }
        string = string.trim();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        ParsePosition parsePosition = new ParsePosition(0);
        try {
            date = simpleDateFormat.parse(string, parsePosition);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(Messages.getString("sql.2"));
        }
        if (date == null) {
            throw new IllegalArgumentException(Messages.getString("sql.2"));
        }
        int n2 = parsePosition.getIndex();
        int n3 = string.length() - n2;
        if (n3 == 0) {
            n = 0;
        } else {
            if (string.length() - n2 < ".n".length()) {
                throw new IllegalArgumentException(Messages.getString("sql.2"));
            }
            if (string.length() - n2 > ".nnnnnnnnn".length()) {
                throw new IllegalArgumentException(Messages.getString("sql.2"));
            }
            if (string.charAt(n2) != '.') {
                throw new NumberFormatException(Messages.getString("sql.4", string.charAt(n2)));
            }
            int n4 = string.length() - n2 - 1;
            String string2 = string.substring(n2 + 1, n2 + 1 + n4);
            string2 = string2 + PADDING;
            string2 = string2.substring(0, 9);
            try {
                n = Integer.parseInt(string2);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException(Messages.getString("sql.2"));
            }
        }
        if (n < 0 || n > 999999999) {
            throw new IllegalArgumentException(Messages.getString("sql.2"));
        }
        Timestamp timestamp = new Timestamp(date.getTime());
        timestamp.setNanos(n);
        return timestamp;
    }
}

