/*
 * Decompiled with CFR 0.152.
 */
package java.sql;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.harmony.kernel.vm.VM;
import org.apache.harmony.sql.internal.nls.Messages;

public class DriverManager {
    private static PrintStream thePrintStream;
    private static PrintWriter thePrintWriter;
    private static int loginTimeout;
    private static final List<Driver> theDrivers;
    private static final SQLPermission logPermission;
    private static final String DRIVER_LIST = "META-INF/services/java.sql.Driver";
    private static final String RESOURCE_JAR_FILE = "resources.jar";

    private static void loadInitialDrivers() {
        String[] stringArray;
        DriverManager.loadDriversFromFiles();
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jdbc.drivers", null);
            }
        });
        if (string == null) {
            return;
        }
        for (String string2 : stringArray = string.split(":")) {
            try {
                Class.forName(string2, true, ClassLoader.getSystemClassLoader());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void loadDriversFromFiles() {
        String[] stringArray;
        String[] stringArray2 = AccessController.doPrivileged(new PrivilegedAction<String[]>(){

            @Override
            public String[] run() {
                return new String[]{System.getProperty("java.home"), System.getProperty("file.separator"), System.getProperty("java.ext.dirs"), System.getProperty("java.class.path"), System.getProperty("path.separator")};
            }
        });
        String string = stringArray2[0];
        String string2 = stringArray2[1];
        String string3 = stringArray2[2];
        String string4 = stringArray2[3];
        String string5 = stringArray2[4];
        String string6 = string + string2 + "lib" + string2 + RESOURCE_JAR_FILE;
        DriverManager.loadDrivers(string6, ClassLoader.getSystemClassLoader());
        String[] stringArray3 = string3.split(string5);
        if (stringArray3 != null) {
            stringArray = stringArray3;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string7 = stringArray[i];
                try {
                    File exception = new File(string7).getAbsoluteFile();
                    File[] fileArray = exception.listFiles();
                    for (int j = 0; j < fileArray.length; ++j) {
                        String string8 = fileArray[j].getAbsolutePath();
                        if (!string8.endsWith(".jar")) continue;
                        DriverManager.loadDrivers(string8, ClassLoader.getSystemClassLoader().getParent());
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if ((stringArray = string4.split(string5)) != null) {
            for (String string9 : stringArray) {
                if (!string9.endsWith(".jar")) continue;
                DriverManager.loadDrivers(string9, ClassLoader.getSystemClassLoader());
            }
        }
    }

    private static void loadDrivers(final String string, ClassLoader classLoader) {
        HashSet<String> hashSet = new HashSet<String>();
        JarFile jarFile = AccessController.doPrivileged(new PrivilegedAction<JarFile>(){

            @Override
            public JarFile run() {
                try {
                    return new JarFile(string);
                }
                catch (Exception exception) {
                    return null;
                }
            }
        });
        if (jarFile == null) {
            return;
        }
        JarEntry jarEntry = jarFile.getJarEntry(DRIVER_LIST);
        try {
            if (jarEntry != null) {
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                Properties object = new Properties();
                object.load(inputStream);
                hashSet.addAll(object.stringPropertyNames());
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (String string2 : hashSet) {
            try {
                Class.forName(string2, true, classLoader);
            }
            catch (Throwable throwable) {}
        }
    }

    private DriverManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterDriver(Driver driver) throws SQLException {
        if (driver == null) {
            return;
        }
        ClassLoader classLoader = VM.callerClassLoader();
        if (!DriverManager.isClassFromClassLoader(driver, classLoader)) {
            throw new SecurityException(Messages.getString("sql.1"));
        }
        List<Driver> list = theDrivers;
        synchronized (list) {
            theDrivers.remove(driver);
        }
    }

    public static Connection getConnection(String string) throws SQLException {
        return DriverManager.getConnection(string, new Properties());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Connection getConnection(String string, Properties properties) throws SQLException {
        String string2 = "08001";
        if (string == null) {
            throw new SQLException(Messages.getString("sql.5"), string2);
        }
        List<Driver> list = theDrivers;
        synchronized (list) {
            for (Driver driver : theDrivers) {
                Connection connection = driver.connect(string, properties);
                if (connection == null) continue;
                return connection;
            }
        }
        throw new SQLException(Messages.getString("sql.6"), string2);
    }

    public static Connection getConnection(String string, String string2, String string3) throws SQLException {
        Properties properties = new Properties();
        if (null != string2) {
            properties.setProperty("user", string2);
        }
        if (null != string3) {
            properties.setProperty("password", string3);
        }
        return DriverManager.getConnection(string, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Driver getDriver(String string) throws SQLException {
        ClassLoader classLoader = VM.callerClassLoader();
        List<Driver> list = theDrivers;
        synchronized (list) {
            for (Driver driver : theDrivers) {
                if (!driver.acceptsURL(string) || !DriverManager.isClassFromClassLoader(driver, classLoader)) continue;
                return driver;
            }
        }
        throw new SQLException(Messages.getString("sql.6"), "08001");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Enumeration<Driver> getDrivers() {
        ClassLoader classLoader = VM.callerClassLoader();
        List<Driver> list = theDrivers;
        synchronized (list) {
            Vector<Driver> vector = new Vector<Driver>();
            for (Driver driver : theDrivers) {
                if (!DriverManager.isClassFromClassLoader(driver, classLoader)) continue;
                vector.add(driver);
            }
            return vector.elements();
        }
    }

    public static int getLoginTimeout() {
        return loginTimeout;
    }

    public static PrintStream getLogStream() {
        return thePrintStream;
    }

    public static PrintWriter getLogWriter() {
        return thePrintWriter;
    }

    public static void println(String string) {
        if (thePrintWriter != null) {
            thePrintWriter.println(string);
            thePrintWriter.flush();
        } else if (thePrintStream != null) {
            thePrintStream.println(string);
            thePrintStream.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDriver(Driver driver) throws SQLException {
        if (driver == null) {
            throw new NullPointerException();
        }
        List<Driver> list = theDrivers;
        synchronized (list) {
            theDrivers.add(driver);
        }
    }

    public static void setLoginTimeout(int n) {
        loginTimeout = n;
    }

    public static void setLogStream(PrintStream printStream) {
        DriverManager.checkLogSecurity();
        thePrintStream = printStream;
    }

    public static void setLogWriter(PrintWriter printWriter) {
        DriverManager.checkLogSecurity();
        thePrintWriter = printWriter;
    }

    private static void checkLogSecurity() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(logPermission);
        }
    }

    private static boolean isClassFromClassLoader(Object object, ClassLoader classLoader) {
        if (object == null || classLoader == null) {
            return false;
        }
        Class<?> clazz = object.getClass();
        try {
            Class<?> clazz2 = Class.forName(clazz.getName(), true, classLoader);
            if (clazz2 == clazz) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    static {
        loginTimeout = 0;
        theDrivers = new ArrayList<Driver>(10);
        logPermission = new SQLPermission("setLog");
        DriverManager.loadInitialDrivers();
    }
}

