/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.TransformContext;
import com.ibm.xml.crypto.dsig.dom.Unmarshalling;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public abstract class TransformBase
extends TransformService {
    protected AlgorithmParameterSpec spec = null;
    protected Node node;
    static /* synthetic */ Class class$com$ibm$xml$crypto$dsig$dom$TransformContext;

    protected TransformBase() {
    }

    protected TransformContext getContext(XMLCryptoContext xcontext) {
        if (xcontext == null) {
            return null;
        }
        return (TransformContext)xcontext.get(class$com$ibm$xml$crypto$dsig$dom$TransformContext == null ? (class$com$ibm$xml$crypto$dsig$dom$TransformContext = TransformBase.class$("com.ibm.xml.crypto.dsig.dom.TransformContext")) : class$com$ibm$xml$crypto$dsig$dom$TransformContext);
    }

    protected NodeSetData toNodeSet(Data in, XMLCryptoContext xcontext) throws ParserConfigurationException, SAXException, IOException, URIReferenceException {
        Document doc;
        if (in instanceof NodeSetData) {
            return (NodeSetData)in;
        }
        if (!(in instanceof OctetStreamData)) {
            throw new RuntimeException("Internal Error: Unknown Data: " + in.getClass().getName());
        }
        OctetStreamData osd = (OctetStreamData)in;
        TransformContext tcontext = this.getContext(xcontext);
        if (tcontext != null) {
            AlgorithmFactory afactory = tcontext.afactory;
            doc = afactory.parse(osd.getOctetStream());
            tcontext.mightFixTree(doc);
        } else {
            AlgorithmFactory afactory = AlgorithmFactory.getInstance();
            doc = afactory.parse(osd.getOctetStream());
            TransformUtil.fixTree(doc);
        }
        return TransformUtil.toNodeSet(doc, true);
    }

    public void setNode(Node n) {
        this.node = n;
    }

    public Node getNode() {
        return this.node;
    }

    public Data transform(Data in, XMLCryptoContext xcontext, OutputStream os) throws TransformException {
        return TransformUtil.transform(this, in, xcontext, os);
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.spec;
    }

    public void init(TransformParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("This transform can not have any parameters.");
        }
    }

    public void marshalParams(XMLStructure parent, XMLCryptoContext xcontext) throws MarshalException {
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
    }

    public void init(XMLStructure parent, XMLCryptoContext xcontext) throws InvalidAlgorithmParameterException {
        if (parent == null) {
            throw new NullPointerException("XMLStructure must not be null.");
        }
        try {
            if (!Unmarshalling.confirmEmpty(((DOMStructure)parent).getNode())) {
                throw new InvalidAlgorithmParameterException("This transform can not have any parameters.");
            }
        }
        catch (MarshalException me) {
            throw new InvalidAlgorithmParameterException(me.getMessage());
        }
        this.init(null);
    }

    public boolean isFeatureSupported(String feature) {
        if (feature == null) {
            throw new NullPointerException("feature must not be null.");
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

