/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom.transform;

import com.ibm.xml.crypto.dsig.dom.NodeSetDataImpl;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import com.ibm.xml.crypto.dsig.dom.transform.TreeNodeSetData;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.crypto.Data;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import org.w3c.dom.Node;

public class Enveloped
extends TransformBase {
    public Data transform(Data in, XMLCryptoContext xcontext) throws TransformException {
        TreeNodeSetData tree;
        Node n;
        NodeSetData nodeSet;
        if (in == null) {
            throw new NullPointerException("The Data parameter is null.");
        }
        try {
            nodeSet = this.toNodeSet(in, xcontext);
        }
        catch (Exception ex) {
            throw new TransformException(ex);
        }
        Node signature = this.searchForSignatureNode();
        if (nodeSet instanceof TreeNodeSetData && ((n = (tree = (TreeNodeSetData)nodeSet).getOmittedNode()) == null || n == signature)) {
            if (signature != null && TransformUtil.isAncestorOrSelf(tree.getTopNode(), signature)) {
                return new NodeSetDataImpl(TransformUtil.EMPTY_ITERATOR);
            }
            return new TreeNodeSetData(tree.getTopNode(), tree.isWithComments(), signature);
        }
        if (nodeSet instanceof NodeSetDataImpl) {
            OmittingIterator iter = nodeSet.iterator();
            if (signature != null) {
                iter = new OmittingIterator(iter, signature);
            }
            return new NodeSetDataImpl(iter);
        }
        throw new UnsupportedOperationException("Internal Error");
    }

    private Node searchForSignatureNode() {
        if (this.node == null) {
            return null;
        }
        Node sig = this.node;
        do {
            if ((sig = sig.getParentNode()) != null) continue;
            return null;
        } while (!sig.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || !sig.getLocalName().equals("Signature"));
        return sig;
    }

    static class OmittingIterator
    implements Iterator {
        Iterator base;
        Node omittedNode;
        Object nextCache;

        OmittingIterator(Iterator i, Node omitted) {
            if (omitted == null || i == null) {
                throw new NullPointerException();
            }
            this.base = i;
            this.omittedNode = omitted;
            this.nextCache = null;
        }

        public Object next() throws NoSuchElementException {
            if (this.nextCache != null) {
                Object ret = this.nextCache;
                this.nextCache = null;
                return ret;
            }
            Object ret = this.base.next();
            if (TransformUtil.isAncestorOrSelf((Node)ret, this.omittedNode)) {
                return this.next();
            }
            return ret;
        }

        public boolean hasNext() {
            Object n;
            if (this.nextCache != null) {
                return true;
            }
            if (!this.base.hasNext()) {
                return false;
            }
            try {
                n = this.next();
            }
            catch (NoSuchElementException nse) {
                return false;
            }
            this.nextCache = n;
            return true;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

