/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.XMLStructureImpl;
import javax.xml.crypto.dom.DOMURIReference;
import org.w3c.dom.Node;

abstract class URIReferenceImpl
extends XMLStructureImpl
implements DOMURIReference {
    private String uri;
    private String type;
    protected Node signatureNode;
    private Node hereNode;

    URIReferenceImpl(AlgorithmFactory f, String uri, String type) {
        super(f);
        if (!this.afactory.checkURI(uri)) {
            throw new IllegalArgumentException("Invalid URI: " + uri);
        }
        this.uri = uri;
        this.type = type;
        this.hereNode = null;
    }

    URIReferenceImpl(AlgorithmFactory f, String uri, String type, boolean bypass) {
        super(f);
        if (!bypass || uri != null) {
            if (uri == null) {
                throw new NullPointerException("URI is null.");
            }
            if (!this.afactory.checkURI(uri)) {
                throw new IllegalArgumentException("Invalid URI: " + uri);
            }
        }
        this.uri = uri;
        this.type = type;
        this.hereNode = null;
    }

    public String getURI() {
        return this.uri;
    }

    public String getType() {
        return this.type;
    }

    void setSignatureNode(Node n) {
        this.signatureNode = n;
    }

    AlgorithmFactory getFactory() {
        return this.afactory;
    }

    void setHere(Node h) {
        this.hereNode = h;
    }

    public Node getHere() {
        return this.hereNode;
    }
}

