/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.TransformContext;
import com.ibm.xml.crypto.dsig.dom.URIReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class URIDereferencerImpl
implements URIDereferencer {
    private static final String[][] KNOWN_IDATTRS = new String[][]{{"http://www.w3.org/2000/09/xmldsig#", "*", "Id"}, {"http://www.w3.org/2001/04/xmlenc#", "*", "Id"}, {"urn:oasis:names:tc:SAML:1.0:assertion", "Assertion", "AssertionID"}, {"urn:oasis:names:tc:SAML:1.0:protocol", "Request", "RequestID"}, {"urn:oasis:names:tc:SAML:1.0:protocol", "Response", "ResponseID"}, {"http://www.ebxml.org/BusinessProcess", "ProcessSpecification", "name"}, {"http://www.ebxml.org/BusinessProcess", "*", "nameID"}, {"http://www.w3.org/1999/xhtml", "*", "id"}};
    private static final String[][] KNOWN_GLOBAL_IDATTRS = new String[][]{{"http://schemas.xmlsoap.org/ws/2002/07/utility", "Id"}, {"http://schemas.xmlsoap.org/ws/2003/06/utility", "Id"}, {"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"}, {"http://www.w3.org/XML/1998/namespace", "id"}};
    static URIDereferencer s_one;
    static /* synthetic */ Class class$com$ibm$xml$crypto$dsig$dom$TransformContext;

    static synchronized URIDereferencer getInstance() {
        if (s_one == null) {
            s_one = new URIDereferencerImpl();
        }
        return s_one;
    }

    private URIDereferencerImpl() {
    }

    /*
     * WARNING - void declaration
     */
    public Data dereference(URIReference reference, XMLCryptoContext context) throws URIReferenceException {
        Element targetNode;
        Document targetDoc;
        String id;
        String uri;
        void var7_5;
        Node node;
        TransformContext tcontext = (TransformContext)context.get(class$com$ibm$xml$crypto$dsig$dom$TransformContext == null ? (class$com$ibm$xml$crypto$dsig$dom$TransformContext = URIDereferencerImpl.class$("com.ibm.xml.crypto.dsig.dom.TransformContext")) : class$com$ibm$xml$crypto$dsig$dom$TransformContext);
        String uriRef = reference.getURI();
        if (uriRef == null) {
            throw new URIReferenceException("Null URI is not supported by this implementation.  Implement your own URIDereferencer.");
        }
        if (context instanceof DOMSignContext) {
            node = ((DOMSignContext)context).getParent();
        } else if (context instanceof DOMValidateContext) {
            node = ((DOMValidateContext)context).getNode();
        } else {
            throw new URIReferenceException("This URIDereferencer implementation requires DOMSignContext or DOMValidateContext: " + context.getClass().getName());
        }
        if (node.getNodeType() != 9) {
            node = node.getOwnerDocument();
        }
        Document thisDoc = (Document)var7_5;
        int ind = uriRef.indexOf(35);
        if (ind >= 0) {
            uri = uriRef.substring(0, ind);
            id = uriRef.substring(ind + 1);
            if (id.length() == 0) {
                id = null;
            }
        } else {
            uri = uriRef;
            id = null;
        }
        if (uri.length() > 0) {
            try {
                URL u = context.getBaseURI() != null ? new URL(new URL(context.getBaseURI()), uri) : new URL(uri);
                if (id == null) {
                    URLConnection conn = u.openConnection();
                    conn.connect();
                    InputStream stream = conn.getInputStream();
                    return new OctetStreamData(stream, u.toExternalForm(), conn.getContentType());
                }
                AlgorithmFactory factory = reference instanceof URIReferenceImpl ? ((URIReferenceImpl)reference).getFactory() : AlgorithmFactory.getInstance();
                targetDoc = factory.parse(u.toExternalForm());
            }
            catch (Exception ex) {
                throw new URIReferenceException(ex);
            }
        } else {
            targetDoc = thisDoc;
            if (id == null) {
                if (tcontext != null) {
                    tcontext.mightFixTree(targetDoc);
                }
                return TransformUtil.toNodeSet(targetDoc, false);
            }
        }
        if (id.equals("xpointer(/)")) {
            if (tcontext != null) {
                tcontext.mightFixTree(targetDoc);
            }
            return TransformUtil.toNodeSet(targetDoc, true);
        }
        if (id.startsWith("xpointer(")) {
            String realId = URIDereferencerImpl.getIdFromXPointer(id);
            if (realId == null) {
                throw new URIReferenceException("No support for specified XPointer expression: '" + id + "'");
            }
            id = realId;
            targetNode = URIDereferencerImpl.resolveId((DOMCryptoContext)context, thisDoc, targetDoc, id);
            if (targetNode == null) {
                throw new URIReferenceException("Can't resolve ID: '" + id + "' in '" + uri + "'");
            }
            if (tcontext != null) {
                tcontext.mightFixTree(targetNode);
            }
            return TransformUtil.toNodeSet(targetNode, true);
        }
        targetNode = URIDereferencerImpl.resolveId((DOMCryptoContext)context, thisDoc, targetDoc, id);
        if (targetNode == null) {
            throw new URIReferenceException("Can't resolve ID: '" + id + "' in '" + uri + "'");
        }
        if (tcontext != null) {
            tcontext.mightFixTree(targetNode);
        }
        return TransformUtil.toNodeSet(targetNode, false);
    }

    public static Element resolveId(DOMCryptoContext idMap, Document thisDoc, Document doc, String id) {
        Element el;
        if (doc == thisDoc && idMap != null && (el = idMap.getElementById(id)) != null) {
            return el;
        }
        el = doc.getElementById(id);
        if (el != null) {
            return el;
        }
        return URIDereferencerImpl.traverseElement(doc.getDocumentElement(), id);
    }

    public static Element traverseElement(Element el, String id) {
        if (id.equals(URIDereferencerImpl.getIdAttributeValue(el))) {
            return el;
        }
        Node child = DOMUtil.getFirstChild2(el);
        while (child != null) {
            Element elem;
            if (child.getNodeType() == 1 && (elem = URIDereferencerImpl.traverseElement((Element)child, id)) != null) {
                return elem;
            }
            child = DOMUtil.getNextSibling2(child);
        }
        return null;
    }

    public static String getIdAttributeValue(Element el) {
        Attr a;
        int i;
        String ns = el.getNamespaceURI();
        String local = el.getLocalName();
        for (i = 0; i < KNOWN_IDATTRS.length; ++i) {
            if (!KNOWN_IDATTRS[i][0].equals(ns) || !"*".equals(KNOWN_IDATTRS[i][1]) && !KNOWN_IDATTRS[i][1].equals(local) || !el.hasAttribute(KNOWN_IDATTRS[i][2]) || (a = el.getAttributeNode(KNOWN_IDATTRS[i][2])) == null) continue;
            return a.getNodeValue();
        }
        for (i = 0; i < KNOWN_GLOBAL_IDATTRS.length; ++i) {
            a = el.getAttributeNodeNS(KNOWN_GLOBAL_IDATTRS[i][0], KNOWN_GLOBAL_IDATTRS[i][1]);
            if (a == null) continue;
            return a.getNodeValue();
        }
        return null;
    }

    private static String getIdFromXPointer(String xpointer) {
        if (!xpointer.endsWith(")")) {
            return null;
        }
        if (!(xpointer = xpointer.substring("xpointer(".length(), xpointer.length() - 1).trim()).startsWith("id(") || !xpointer.endsWith(")")) {
            return null;
        }
        if ((xpointer = xpointer.substring("id(".length(), xpointer.length() - 1).trim()).length() < 3) {
            return null;
        }
        char first = xpointer.charAt(0);
        char last = xpointer.charAt(xpointer.length() - 1);
        if ((first == '\"' || first == '\'') && first == last) {
            return xpointer.substring(1, xpointer.length() - 1);
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

