/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.DOMUtil;
import com.ibm.xml.crypto.dsig.dom.Marshalling;
import com.ibm.xml.crypto.dsig.dom.NodeSetDataImpl;
import com.ibm.xml.crypto.dsig.dom.TransformContext;
import com.ibm.xml.crypto.dsig.dom.URIDereferencerImpl;
import com.ibm.xml.crypto.dsig.dom.URIReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.transform.BinaryData;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.dsig.dom.transform.TransformUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.crypto.Data;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.XMLSignContext;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLValidateContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import org.w3c.dom.Node;

class ReferenceImpl
extends URIReferenceImpl
implements Reference {
    static String PROP_CACHEREFERENCE = "javax.xml.crypto.dsig.cacheReference";
    private static final int FETCH_BUFFER_SIZE = 1024;
    private DigestMethod digestMethod;
    List transforms;
    private int applied;
    private Data appliedData;
    private String id;
    private byte[] digest;
    private byte[] calculated;
    private boolean cachedResult;
    private Node digestValueNode;
    private Object dereferencedData;
    private byte[] digestInput;
    static /* synthetic */ Class class$com$ibm$xml$crypto$dsig$dom$TransformContext;

    ReferenceImpl(AlgorithmFactory f, String uri, DigestMethod dm, List applied, Data result, List transforms, String type, String id, byte[] digestValue) {
        super(f, uri, type, true);
        if (dm == null) {
            throw new NullPointerException("DigestMethod is null.");
        }
        this.digestMethod = dm;
        if (!(applied != null && applied.size() != 0 || transforms != null && transforms.size() != 0)) {
            this.transforms = Collections.EMPTY_LIST;
            this.applied = 0;
        } else if (applied != null && applied.size() > 0) {
            if (transforms != null) {
                Transform obj;
                this.transforms = new ArrayList(applied.size() + transforms.size());
                Iterator iter = applied.iterator();
                while (iter.hasNext()) {
                    obj = (Transform)iter.next();
                    this.transforms.add(obj);
                }
                iter = transforms.iterator();
                while (iter.hasNext()) {
                    obj = (Transform)iter.next();
                    this.transforms.add(obj);
                }
            } else {
                this.transforms = new ArrayList(applied.size());
                Iterator iter = applied.iterator();
                while (iter.hasNext()) {
                    Transform obj = (Transform)iter.next();
                    this.transforms.add(obj);
                }
            }
            this.applied = applied.size();
        } else {
            this.transforms = new ArrayList(transforms.size());
            Iterator iter = transforms.iterator();
            while (iter.hasNext()) {
                Transform obj = (Transform)iter.next();
                this.transforms.add(obj);
            }
            this.applied = 0;
        }
        this.appliedData = null;
        if (result != null) {
            this.appliedData = result;
        }
        this.digest = null;
        if (digestValue != null) {
            this.digest = new byte[digestValue.length];
            System.arraycopy(digestValue, 0, this.digest, 0, digestValue.length);
        }
        this.id = id;
        this.digest = null;
        this.digestValueNode = null;
        this.calculated = null;
        this.dereferencedData = null;
        this.digestInput = null;
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public String getId() {
        return this.id;
    }

    public List getTransforms() {
        return Collections.unmodifiableList(this.transforms);
    }

    void setDigestValue(byte[] value) {
        this.digest = value;
    }

    void setDigestValueNode(Node node) {
        this.digestValueNode = node;
    }

    public byte[] getDigestValue() {
        if (this.digest == null) {
            return null;
        }
        byte[] ret = new byte[this.digest.length];
        System.arraycopy(this.digest, 0, ret, 0, ret.length);
        return ret;
    }

    public byte[] getCalculatedDigestValue() {
        if (this.calculated == null) {
            return null;
        }
        byte[] ret = new byte[this.calculated.length];
        System.arraycopy(this.calculated, 0, ret, 0, ret.length);
        return ret;
    }

    public Data getDereferencedData() {
        if (this.dereferencedData == null) {
            return null;
        }
        if (this.dereferencedData instanceof byte[]) {
            ByteArrayInputStream is = new ByteArrayInputStream((byte[])this.dereferencedData);
            return new OctetStreamData(is);
        }
        return new NodeSetDataImpl(((List)this.dereferencedData).iterator());
    }

    public InputStream getDigestInputStream() {
        if (this.digestInput == null) {
            return null;
        }
        return new ByteArrayInputStream(this.digestInput);
    }

    void sign(XMLSignContext scontext) throws XMLSignatureException {
        if (scontext == null) {
            throw new NullPointerException("Null context");
        }
        if (this.digestValueNode == null) {
            throw new XMLSignatureException("Internal Error: <ds:DigestValue> node is not registered.");
        }
        if (this.digestValueNode == null) {
            throw new XMLSignatureException("Internal Error: <ds:DigestValue> element is not registered.");
        }
        DOMUtil.removeAllChildren(this.digestValueNode);
        this.digest = this.calculated != null ? this.calculated : this.calculateDigestValue(scontext);
        Marshalling.insertBase64Binary(this.digestValueNode, this.digest);
    }

    public boolean validate(XMLValidateContext vcontext) throws XMLSignatureException {
        if (vcontext == null) {
            throw new NullPointerException("Null context");
        }
        DOMValidateContext dvcontext = (DOMValidateContext)vcontext;
        if (this.digest == null) {
            throw new XMLSignatureException("This Reference has no DigestValue.");
        }
        if (this.calculated != null) {
            return this.cachedResult;
        }
        this.calculated = this.calculateDigestValue(vcontext);
        this.cachedResult = MessageDigest.isEqual(this.calculated, this.digest);
        return this.cachedResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] calculateDigestValue(XMLCryptoContext context) throws XMLSignatureException {
        byte[] digest;
        Class clazz;
        Data data;
        boolean checkEmptyReference;
        boolean cacheReference;
        block32: {
            block30: {
                URIDereferencer ud;
                cacheReference = false;
                checkEmptyReference = false;
                Boolean property = (Boolean)context.getProperty(PROP_CACHEREFERENCE);
                if (property != null && property.booleanValue()) {
                    cacheReference = true;
                }
                if ((property = (Boolean)context.getProperty("com.ibm.xml.crypto.dsig.checkEmptyReference")) != null && property.booleanValue()) {
                    checkEmptyReference = true;
                }
                if ((ud = context.getURIDereferencer()) == null) {
                    ud = URIDereferencerImpl.getInstance();
                }
                TransformContext tcontext = new TransformContext(this.afactory, this.transforms);
                context.put(class$com$ibm$xml$crypto$dsig$dom$TransformContext == null ? (class$com$ibm$xml$crypto$dsig$dom$TransformContext = ReferenceImpl.class$("com.ibm.xml.crypto.dsig.dom.TransformContext")) : class$com$ibm$xml$crypto$dsig$dom$TransformContext, tcontext);
                try {
                    try {
                        if (this.appliedData != null) {
                            data = this.appliedData;
                        } else {
                            data = ud.dereference(this, context);
                            if (cacheReference) {
                                if (data instanceof OctetStreamData) {
                                    InputStream is2 = ((OctetStreamData)data).getOctetStream();
                                    this.dereferencedData = ReferenceImpl.fetchStream(is2);
                                    is2.close();
                                    data = new BinaryData((byte[])this.dereferencedData);
                                } else {
                                    NodeSetDataImpl nodeset = (NodeSetDataImpl)data;
                                    Iterator iter = nodeset.iterator();
                                    ArrayList nodelist = new ArrayList();
                                    while (iter.hasNext()) {
                                        nodelist.add(iter.next());
                                    }
                                    data = new NodeSetDataImpl(new TransformUtil.ListIterator(nodelist));
                                    this.dereferencedData = Collections.unmodifiableList(nodelist);
                                }
                            }
                        }
                        for (int i = this.applied; i < this.transforms.size(); ++i) {
                            TransformBase tr = (TransformBase)this.transforms.get(i);
                            data = tr.transform(data, context);
                        }
                        if (!(data instanceof OctetStreamData)) {
                            TransformService tr = TransformService.getInstance("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "DOM");
                            tr.init(null);
                            data = tr.transform(data, context);
                        }
                    }
                    catch (Exception e) {
                        throw new XMLSignatureException(e);
                    }
                    Object var12_15 = null;
                    tcontext.mightCleanTree();
                    if (class$com$ibm$xml$crypto$dsig$dom$TransformContext != null) break block30;
                }
                catch (Throwable throwable) {
                    Object var12_16 = null;
                    tcontext.mightCleanTree();
                    context.put(class$com$ibm$xml$crypto$dsig$dom$TransformContext == null ? (class$com$ibm$xml$crypto$dsig$dom$TransformContext = ReferenceImpl.class$("com.ibm.xml.crypto.dsig.dom.TransformContext")) : class$com$ibm$xml$crypto$dsig$dom$TransformContext, null);
                    throw throwable;
                }
                clazz = class$com$ibm$xml$crypto$dsig$dom$TransformContext = ReferenceImpl.class$("com.ibm.xml.crypto.dsig.dom.TransformContext");
                break block32;
            }
            clazz = class$com$ibm$xml$crypto$dsig$dom$TransformContext;
        }
        context.put(clazz, null);
        MessageDigest digester = null;
        InputStream is = null;
        int total = 0;
        try {
            block31: {
                try {
                    digester = this.afactory.getMessageDigest(this.digestMethod.getAlgorithm(), this.digestMethod.getParameterSpec());
                    digester.reset();
                    this.digestInput = null;
                    if (data instanceof BinaryData) {
                        this.digestInput = ((BinaryData)data).getData();
                        total = this.digestInput.length;
                        digest = digester.digest(this.digestInput);
                        break block31;
                    }
                    if (cacheReference) {
                        is = ((OctetStreamData)data).getOctetStream();
                        this.digestInput = ReferenceImpl.fetchStream(is);
                        total = this.digestInput.length;
                        digest = digester.digest(this.digestInput);
                    } else {
                        int readLength;
                        is = ((OctetStreamData)data).getOctetStream();
                        byte[] buffer = new byte[1024];
                        while ((readLength = is.read(buffer)) != -1) {
                            digester.update(buffer, 0, readLength);
                            total += readLength;
                        }
                        digest = digester.digest();
                    }
                }
                catch (GeneralSecurityException gse) {
                    throw new XMLSignatureException(gse);
                }
                catch (IOException ioe) {
                    throw new XMLSignatureException(ioe);
                }
            }
            Object var16_21 = null;
            if (digester != null) {
                this.afactory.releaseMessageDigest(this.digestMethod.getAlgorithm(), digester);
            }
        }
        catch (Throwable throwable) {
            Object var16_22 = null;
            if (digester != null) {
                this.afactory.releaseMessageDigest(this.digestMethod.getAlgorithm(), digester);
            }
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ioe) {
                // empty catch block
            }
            throw throwable;
        }
        if (is != null) {
            try {}
            catch (IOException ioe) {}
            is.close();
        }
        if (!checkEmptyReference) return digest;
        if (total > 0) return digest;
        throw new XMLSignatureException("Transformed data is empty.");
    }

    private static byte[] fetchStream(InputStream is) throws IOException {
        int readLength;
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((readLength = is.read(buffer)) != -1) {
            baos.write(buffer, 0, readLength);
        }
        baos.close();
        return baos.toByteArray();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

