/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig.dom;

import com.ibm.xml.crypto.dsig.Constants;
import com.ibm.xml.crypto.dsig.dom.AlgorithmFactory;
import com.ibm.xml.crypto.dsig.dom.KeyInfoImpl;
import com.ibm.xml.crypto.dsig.dom.ManifestImpl;
import com.ibm.xml.crypto.dsig.dom.ObjectImpl;
import com.ibm.xml.crypto.dsig.dom.PGPDataImpl;
import com.ibm.xml.crypto.dsig.dom.ReferenceImpl;
import com.ibm.xml.crypto.dsig.dom.RetrievalMethodImpl;
import com.ibm.xml.crypto.dsig.dom.SignaturePropertiesImpl;
import com.ibm.xml.crypto.dsig.dom.SignaturePropertyImpl;
import com.ibm.xml.crypto.dsig.dom.SignedInfoImpl;
import com.ibm.xml.crypto.dsig.dom.X509DataImpl;
import com.ibm.xml.crypto.dsig.dom.XMLSignatureImpl;
import com.ibm.xml.crypto.dsig.dom.transform.TransformBase;
import com.ibm.xml.crypto.util.Base64;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.PGPData;
import javax.xml.crypto.dsig.keyinfo.RetrievalMethod;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.keyinfo.X509IssuerSerial;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Marshalling
implements Constants {
    private DOMCryptoContext context;
    private AlgorithmFactory afactory;
    private Document factory;
    private boolean indent;
    private int unit;
    private int start;
    private int level;
    final int MAX_CACHE = 10;
    private String[] texts;

    static Node marshalSignature(XMLSignature sig, DOMSignContext context, AlgorithmFactory af) throws MarshalException {
        Marshalling mcontext = new Marshalling(context, af);
        Node signature = mcontext.marshalSignature(sig);
        if (mcontext.getLevel() != 0) {
            System.err.println("DEBUG: IndentState::getLevel() is " + mcontext.getLevel());
        }
        return signature;
    }

    static Node marshalKeyInfo(KeyInfo ki, Node parent, DOMCryptoContext context, AlgorithmFactory afactory) throws MarshalException {
        Marshalling mcontext = new Marshalling(parent, context, afactory);
        return mcontext.marshalKeyInfo(ki);
    }

    Marshalling(DOMSignContext dscontext, AlgorithmFactory af) {
        this.context = dscontext;
        this.afactory = af;
        Node parent = dscontext.getParent();
        this.factory = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        this.init();
    }

    Marshalling(Node parent, DOMCryptoContext dcontext, AlgorithmFactory af) {
        this.context = dcontext;
        this.afactory = af;
        this.factory = parent.getNodeType() == 9 ? (Document)parent : parent.getOwnerDocument();
        this.init();
    }

    private void init() {
        this.level = 0;
        this.texts = new String[10];
        this.indent = false;
        this.unit = 2;
        this.start = 0;
        Object prop = this.context.getProperty("com.ibm.xml.crypto.indent");
        if (prop != null) {
            this.indent = (Boolean)prop;
        }
        if (this.indent) {
            prop = this.context.getProperty("com.ibm.xml.crypto.indent.unit");
            this.unit = (Integer)prop;
            if (this.unit < 0) {
                this.unit = 0;
            }
            prop = this.context.getProperty("com.ibm.xml.crypto.indent.start");
            this.start = (Integer)prop;
            if (this.start < 0) {
                this.start = 0;
            }
        }
    }

    public boolean doIndentation() {
        return this.indent;
    }

    public int getUnit() {
        return this.unit;
    }

    public int getStart() {
        return this.start;
    }

    public void increment() {
        ++this.level;
    }

    public void decrement() {
        --this.level;
    }

    public int getLevel() {
        return this.level;
    }

    public String getText() {
        if (this.texts[this.level] == null) {
            int nspace = this.start + this.unit * this.level;
            StringBuffer buffer = new StringBuffer(1 + nspace);
            buffer.append("\n");
            for (int i = 0; i < nspace; ++i) {
                buffer.append(" ");
            }
            this.texts[this.level] = new String(buffer);
        }
        return this.texts[this.level];
    }

    Node marshalSignature(XMLSignature sig) throws MarshalException {
        List objects;
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Signature", true);
        if (sig.getId() != null) {
            el.setAttributeNS(null, "Id", sig.getId());
        }
        this.increment();
        this.indent(el);
        el.appendChild(this.marshalSignedInfo(sig.getSignedInfo()));
        Element sv = this.createElement("http://www.w3.org/2000/09/xmldsig#", "SignatureValue", false);
        ((XMLSignatureImpl)sig).setSignatureValueNode(sv);
        this.indent(el);
        el.appendChild(sv);
        KeyInfo ki = sig.getKeyInfo();
        if (ki != null) {
            this.indent(el);
            el.appendChild(this.marshalKeyInfo(ki));
        }
        if ((objects = ((XMLSignatureImpl)sig).objects) != null && objects.size() > 0) {
            for (int i = 0; i < objects.size(); ++i) {
                this.indent(el);
                el.appendChild(this.marshalObject((XMLObject)objects.get(i)));
            }
        }
        this.decrement();
        this.indent(el);
        Marshalling.bind(sig, el);
        ((XMLSignatureImpl)sig).setNode(el);
        return el;
    }

    Node marshalSignedInfo(SignedInfo si) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "SignedInfo", false);
        if (si.getId() != null) {
            el.setAttributeNS(null, "Id", si.getId());
        }
        this.increment();
        this.indent(el);
        el.appendChild(this.marshalTransform(si.getCanonicalizationMethod(), "CanonicalizationMethod"));
        this.indent(el);
        el.appendChild(this.marshalSignatureMethod(si.getSignatureMethod()));
        List references = ((SignedInfoImpl)si).content;
        for (int i = 0; i < references.size(); ++i) {
            this.indent(el);
            el.appendChild(this.marshalReference((Reference)references.get(i)));
        }
        this.decrement();
        this.indent(el);
        Marshalling.bind(si, el);
        ((SignedInfoImpl)si).setNode(el);
        return el;
    }

    Node marshalTransform(Transform tr, String elementName) throws MarshalException {
        TransformBase ts = (TransformBase)tr;
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", elementName, false);
        String algorithm = tr.getAlgorithm();
        el.setAttributeNS(null, "Algorithm", algorithm);
        AlgorithmParameterSpec spec = tr.getParameterSpec();
        ts.marshalParams(new DOMStructure(el), this.context);
        Marshalling.bind(tr, el);
        ts.setNode(el);
        return el;
    }

    Node marshalSignatureMethod(SignatureMethod sm) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod", false);
        String algorithm = sm.getAlgorithm();
        el.setAttributeNS(null, "Algorithm", algorithm);
        AlgorithmParameterSpec spec = sm.getParameterSpec();
        try {
            this.afactory.marshalParameter(algorithm, spec, el, this);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
        Marshalling.bind(sm, el);
        return el;
    }

    Node marshalReference(Reference ref) throws MarshalException {
        ReferenceImpl refImpl = (ReferenceImpl)ref;
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Reference", false);
        if (ref.getType() != null) {
            el.setAttributeNS(null, "Type", ref.getType());
        }
        if (ref.getURI() != null) {
            el.setAttributeNS(null, "URI", ref.getURI());
            refImpl.setHere(el.getAttributeNodeNS(null, "URI"));
        }
        if (ref.getId() != null) {
            el.setAttributeNS(null, "Id", ref.getId());
        }
        this.increment();
        List transforms = refImpl.transforms;
        if (transforms != null && transforms.size() > 0) {
            this.indent(el);
            el.appendChild(this.marshalTransforms(transforms));
        }
        this.indent(el);
        el.appendChild(this.marshalDigestMethod(ref.getDigestMethod()));
        Element dv = this.createElement("http://www.w3.org/2000/09/xmldsig#", "DigestValue", false);
        this.indent(el);
        el.appendChild(dv);
        refImpl.setDigestValueNode(dv);
        this.decrement();
        this.indent(el);
        Marshalling.bind(ref, el);
        return el;
    }

    Node marshalTransforms(List transforms) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Transforms", false);
        this.increment();
        for (int i = 0; i < transforms.size(); ++i) {
            this.indent(el);
            el.appendChild(this.marshalTransform((Transform)transforms.get(i), "Transform"));
        }
        this.decrement();
        this.indent(el);
        return el;
    }

    Node marshalDigestMethod(DigestMethod dm) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "DigestMethod", false);
        String algorithm = dm.getAlgorithm();
        el.setAttributeNS(null, "Algorithm", algorithm);
        AlgorithmParameterSpec spec = dm.getParameterSpec();
        try {
            this.afactory.marshalParameter(algorithm, spec, el, this);
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
        Marshalling.bind(dm, el);
        return el;
    }

    /*
     * WARNING - void declaration
     */
    Node marshalKeyInfo(KeyInfo ki) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "KeyInfo", false);
        if (ki.getId() != null) {
            el.setAttributeNS(null, "Id", ki.getId());
        }
        this.increment();
        List content = ((KeyInfoImpl)ki).content;
        for (int i = 0; i < content.size(); ++i) {
            void var6_6;
            Node kel;
            Object obj = content.get(i);
            if (obj instanceof KeyName) {
                kel = this.marshalKeyName((KeyName)obj);
            } else if (obj instanceof KeyValue) {
                kel = this.marshalKeyValue((KeyValue)obj);
            } else if (obj instanceof RetrievalMethod) {
                kel = this.marshalRetrievalMethod((RetrievalMethod)obj);
            } else if (obj instanceof X509Data) {
                kel = this.marshalX509Data((X509Data)obj);
            } else if (obj instanceof PGPData) {
                kel = this.marshalPGPData((PGPData)obj);
            } else if (obj instanceof DOMStructure) {
                kel = this.marshalOther((DOMStructure)obj);
            } else {
                throw new MarshalException("Internal Error: unexpected class: " + obj.getClass().getName());
            }
            this.indent(el);
            el.appendChild((Node)var6_6);
        }
        this.decrement();
        this.indent(el);
        Marshalling.bind(ki, el);
        return el;
    }

    Node marshalKeyName(KeyName kname) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "KeyName", false);
        el.appendChild(this.factory.createTextNode(kname.getName()));
        Marshalling.bind(kname, el);
        return el;
    }

    Node marshalKeyValue(KeyValue kvalue) throws MarshalException {
        PublicKey key;
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "KeyValue", false);
        try {
            key = kvalue.getPublicKey();
        }
        catch (Exception ex) {
            throw new MarshalException(ex);
        }
        this.increment();
        if (key instanceof DSAPublicKey) {
            DSAPublicKey dkey = (DSAPublicKey)key;
            DSAParams params = dkey.getParams();
            Element dsakv = this.createElement("http://www.w3.org/2000/09/xmldsig#", "DSAKeyValue", false);
            this.increment();
            String text = Marshalling.encodeCryptoBinary(params.getP());
            Element ch = this.createElement("http://www.w3.org/2000/09/xmldsig#", "P", false);
            ch.appendChild(this.factory.createTextNode(text));
            this.indent(dsakv);
            dsakv.appendChild(ch);
            text = Marshalling.encodeCryptoBinary(params.getQ());
            ch = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Q", false);
            ch.appendChild(this.factory.createTextNode(text));
            this.indent(dsakv);
            dsakv.appendChild(ch);
            text = Marshalling.encodeCryptoBinary(params.getG());
            ch = this.createElement("http://www.w3.org/2000/09/xmldsig#", "G", false);
            ch.appendChild(this.factory.createTextNode(text));
            this.indent(dsakv);
            dsakv.appendChild(ch);
            text = Marshalling.encodeCryptoBinary(dkey.getY());
            ch = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Y", false);
            ch.appendChild(this.factory.createTextNode(text));
            this.indent(dsakv);
            dsakv.appendChild(ch);
            this.decrement();
            this.indent(dsakv);
            this.indent(el);
            el.appendChild(dsakv);
        } else if (key instanceof RSAPublicKey) {
            RSAPublicKey rkey = (RSAPublicKey)key;
            Element rsakv = this.createElement("http://www.w3.org/2000/09/xmldsig#", "RSAKeyValue", false);
            this.increment();
            String text = Marshalling.encodeCryptoBinary(rkey.getModulus());
            Element ch = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Modulus", false);
            ch.appendChild(this.factory.createTextNode(text));
            this.indent(rsakv);
            rsakv.appendChild(ch);
            text = Marshalling.encodeCryptoBinary(rkey.getPublicExponent());
            ch = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Exponent", false);
            ch.appendChild(this.factory.createTextNode(text));
            this.indent(rsakv);
            rsakv.appendChild(ch);
            this.decrement();
            this.indent(rsakv);
            this.indent(el);
            el.appendChild(rsakv);
        } else {
            throw new MarshalException("Unsupported key type: " + key.getClass().getName());
        }
        this.decrement();
        this.indent(el);
        Marshalling.bind(kvalue, el);
        return el;
    }

    Node marshalRetrievalMethod(RetrievalMethod rm) throws MarshalException {
        List transforms;
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod", false);
        el.setAttributeNS(null, "URI", rm.getURI());
        ((RetrievalMethodImpl)rm).setHere(el.getAttributeNodeNS(null, "URI"));
        if (rm.getType() != null) {
            el.setAttributeNS(null, "Type", rm.getType());
        }
        if ((transforms = ((RetrievalMethodImpl)rm).transforms) != null && transforms.size() > 0) {
            this.increment();
            this.indent(el);
            el.appendChild(this.marshalTransforms(transforms));
            this.decrement();
            this.indent(el);
        }
        Marshalling.bind(rm, el);
        return el;
    }

    /*
     * WARNING - void declaration
     */
    Node marshalX509Data(X509Data xd) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "X509Data", false);
        this.increment();
        List content = ((X509DataImpl)xd).content;
        for (int i = 0; i < content.size(); ++i) {
            void var6_6;
            Node child;
            Object obj = content.get(i);
            if (obj instanceof String) {
                child = this.marshalX509SubjectName((String)obj);
            } else if (obj instanceof byte[]) {
                child = this.marshalX509SKI((byte[])obj);
            } else if (obj instanceof X509Certificate) {
                child = this.marshalX509Certificate((X509Certificate)obj);
            } else if (obj instanceof X509CRL) {
                child = this.marshalX509CRL((X509CRL)obj);
            } else if (obj instanceof X509IssuerSerial) {
                child = this.marshalX509IssuerSerial((X509IssuerSerial)obj);
            } else if (obj instanceof DOMStructure) {
                child = this.marshalOther((DOMStructure)obj);
            } else {
                throw new MarshalException("Internal Error: unexpected class: " + obj.getClass().getName());
            }
            this.indent(el);
            el.appendChild((Node)var6_6);
        }
        this.decrement();
        this.indent(el);
        Marshalling.bind(xd, el);
        return el;
    }

    Node marshalX509SubjectName(String dn) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "X509SubjectName", false);
        el.appendChild(this.factory.createTextNode(dn));
        return el;
    }

    Node marshalX509SKI(byte[] ki) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "X509SKI", false);
        el.appendChild(this.factory.createTextNode(Base64.encode(ki)));
        return el;
    }

    Node marshalX509Certificate(X509Certificate cert) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "X509Certificate", false);
        try {
            el.appendChild(this.factory.createTextNode(Base64.encode(cert.getEncoded())));
        }
        catch (GeneralSecurityException gse) {
            throw new MarshalException(gse);
        }
        return el;
    }

    Node marshalX509CRL(X509CRL crl) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "X509CRL", false);
        try {
            el.appendChild(this.factory.createTextNode(Base64.encode(crl.getEncoded())));
        }
        catch (GeneralSecurityException gse) {
            throw new MarshalException(gse);
        }
        return el;
    }

    Node marshalX509IssuerSerial(X509IssuerSerial is) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "X509IssuerSerial", false);
        this.increment();
        Element child = this.createElement("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName", false);
        child.appendChild(this.factory.createTextNode(is.getIssuerName()));
        this.indent(el);
        el.appendChild(child);
        child = this.createElement("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber", false);
        child.appendChild(this.factory.createTextNode(is.getSerialNumber().toString(10)));
        this.indent(el);
        el.appendChild(child);
        this.decrement();
        this.indent(el);
        Marshalling.bind(is, el);
        return el;
    }

    Node marshalPGPData(PGPData pgp) throws MarshalException {
        Element child;
        PGPDataImpl pgpi = (PGPDataImpl)pgp;
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "PGPData", false);
        this.increment();
        if (pgpi.keyId != null) {
            child = this.createElement("http://www.w3.org/2000/09/xmldsig#", "PGPKeyID", false);
            child.appendChild(this.factory.createTextNode(Base64.encode(pgpi.keyId)));
            this.indent(el);
            el.appendChild(child);
        }
        if (pgpi.keyPacket != null) {
            child = this.createElement("http://www.w3.org/2000/09/xmldsig#", "PGPKeyPacket", false);
            child.appendChild(this.factory.createTextNode(Base64.encode(pgpi.keyPacket)));
            this.indent(el);
            el.appendChild(child);
        }
        if (pgpi.content != null && pgpi.content.size() > 0) {
            for (int i = 0; i < pgpi.content.size(); ++i) {
                DOMStructure ds = (DOMStructure)pgpi.content.get(i);
                this.indent(el);
                el.appendChild(this.marshalOther(ds));
            }
        }
        this.decrement();
        this.indent(el);
        Marshalling.bind(pgp, el);
        return el;
    }

    Node marshalObject(XMLObject obj) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Object", false);
        if (obj.getEncoding() != null) {
            el.setAttributeNS(null, "Encoding", obj.getEncoding());
        }
        if (obj.getId() != null) {
            el.setAttributeNS(null, "Id", obj.getId());
        }
        if (obj.getMimeType() != null) {
            el.setAttributeNS(null, "MimeType", obj.getMimeType());
        }
        this.increment();
        List content = ((ObjectImpl)obj).content;
        if (content != null && content.size() > 0) {
            for (int i = 0; i < content.size(); ++i) {
                XMLStructure xs = (XMLStructure)content.get(i);
                el.appendChild(this.marshalAny(xs));
            }
        }
        this.decrement();
        Marshalling.bind(obj, el);
        return el;
    }

    Node marshalManifest(Manifest manifest) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "Manifest", false);
        if (manifest.getId() != null) {
            el.setAttributeNS(null, "Id", manifest.getId());
        }
        this.increment();
        List references = ((ManifestImpl)manifest).content;
        for (int i = 0; i < references.size(); ++i) {
            Node child = this.marshalReference((Reference)references.get(i));
            this.indent(el);
            el.appendChild(child);
        }
        this.decrement();
        this.indent(el);
        Marshalling.bind(manifest, el);
        return el;
    }

    Node marshalSignatureProperties(SignatureProperties props) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "SignatureProperties", false);
        if (props.getId() != null) {
            el.setAttributeNS(null, "Id", props.getId());
        }
        this.increment();
        List ps = ((SignaturePropertiesImpl)props).content;
        for (int i = 0; i < ps.size(); ++i) {
            Node child = this.marshalSignatureProperty((SignatureProperty)ps.get(i));
            this.indent(el);
            el.appendChild(child);
        }
        this.decrement();
        this.indent(el);
        Marshalling.bind(props, el);
        return el;
    }

    Node marshalSignatureProperty(SignatureProperty prop) throws MarshalException {
        Element el = this.createElement("http://www.w3.org/2000/09/xmldsig#", "SignatureProperty", false);
        el.setAttributeNS(null, "Target", prop.getTarget());
        if (prop.getId() != null) {
            el.setAttributeNS(null, "Id", prop.getId());
        }
        List content = ((SignaturePropertyImpl)prop).content;
        for (int i = 0; i < content.size(); ++i) {
            Node child = this.marshalOther((DOMStructure)content.get(i));
            el.appendChild(child);
        }
        Marshalling.bind(prop, el);
        return el;
    }

    /*
     * WARNING - void declaration
     */
    Node marshalAny(XMLStructure xs) throws MarshalException {
        void var2_2;
        Node node;
        if (xs instanceof CanonicalizationMethod) {
            node = this.marshalTransform((Transform)xs, "CanonicalizationMethod");
        } else if (xs instanceof DigestMethod) {
            node = this.marshalDigestMethod((DigestMethod)xs);
        } else if (xs instanceof Manifest) {
            node = this.marshalManifest((Manifest)xs);
        } else if (xs instanceof Reference) {
            node = this.marshalReference((Reference)xs);
        } else if (xs instanceof SignatureMethod) {
            node = this.marshalSignatureMethod((SignatureMethod)xs);
        } else if (xs instanceof SignatureProperties) {
            node = this.marshalSignatureProperties((SignatureProperties)xs);
        } else if (xs instanceof SignatureProperty) {
            node = this.marshalSignatureProperty((SignatureProperty)xs);
        } else if (xs instanceof SignedInfo) {
            node = this.marshalSignedInfo((SignedInfo)xs);
        } else if (xs instanceof Transform) {
            node = this.marshalTransform((Transform)xs, "Transform");
        } else if (xs instanceof XMLObject) {
            node = this.marshalObject((XMLObject)xs);
        } else if (xs instanceof XMLSignature) {
            node = this.marshalSignature((XMLSignature)xs);
        } else if (xs instanceof KeyInfo) {
            node = this.marshalKeyInfo((KeyInfo)xs);
        } else if (xs instanceof KeyName) {
            node = this.marshalKeyName((KeyName)xs);
        } else if (xs instanceof KeyValue) {
            node = this.marshalKeyValue((KeyValue)xs);
        } else if (xs instanceof PGPData) {
            node = this.marshalPGPData((PGPData)xs);
        } else if (xs instanceof RetrievalMethod) {
            node = this.marshalRetrievalMethod((RetrievalMethod)xs);
        } else if (xs instanceof X509Data) {
            node = this.marshalX509Data((X509Data)xs);
        } else if (xs instanceof X509IssuerSerial) {
            node = this.marshalX509IssuerSerial((X509IssuerSerial)xs);
        } else if (xs instanceof DOMStructure) {
            node = this.marshalOther((DOMStructure)xs);
        } else {
            throw new MarshalException("Internal Error: unexpected class: " + xs.getClass().getName());
        }
        return var2_2;
    }

    Node marshalOther(DOMStructure ds) throws MarshalException {
        Node origin = ds.getNode();
        if (origin.getOwnerDocument() == null) {
            throw new MarshalException("This implementation does not support a DOMStructure with org.w3c.Document.");
        }
        if (this.factory == origin.getOwnerDocument()) {
            return origin.cloneNode(true);
        }
        return this.factory.importNode(origin, true);
    }

    private static String getPrefix(DOMCryptoContext context, String namespace) {
        String prefix = null;
        if (context != null) {
            prefix = context.getNamespacePrefix(namespace, context.getDefaultNamespacePrefix());
        }
        if (prefix != null) {
            return prefix;
        }
        if ("http://www.w3.org/2000/09/xmldsig#".equals(namespace)) {
            return "ds";
        }
        if ("http://www.w3.org/2001/10/xml-exc-c14n#".equals(namespace)) {
            return "ec";
        }
        if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(namespace)) {
            return "xf";
        }
        return "";
    }

    Element createElement(String namespace, String local, boolean nsdecl) {
        return Marshalling.createElement(this.context, this.factory, namespace, local, nsdecl);
    }

    public static Element createElement(DOMCryptoContext c, Document f, String namespace, String local, boolean nsdecl) {
        String prefix = Marshalling.getPrefix(c, namespace);
        String qname = prefix.length() == 0 ? local : prefix + ":" + local;
        Element el = f.createElementNS(namespace, qname);
        if (nsdecl) {
            qname = prefix.length() == 0 ? "xmlns" : "xmlns:" + prefix;
            el.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, namespace);
        }
        return el;
    }

    void indent(Node parent) {
        if (!this.doIndentation()) {
            return;
        }
        parent.appendChild(parent.getOwnerDocument().createTextNode(this.getText()));
    }

    private static void bind(XMLStructure xs, Node node) {
    }

    private static String encodeCryptoBinary(BigInteger bi) {
        byte[] data = bi.toByteArray();
        int off = 0;
        while (data[off] == 0) {
            ++off;
        }
        return Base64.encode(data, off, data.length - off);
    }

    static void insertBase64Binary(Node parent, byte[] data) {
        Document factory = parent.getOwnerDocument();
        parent.appendChild(factory.createTextNode(Base64.encode(data)));
    }
}

