/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig;

import com.ibm.xml.crypto.spi.SignatureEngine;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.dsig.spec.HMACParameterSpec;

public class SignatureEngineHMAC
implements SignatureEngine {
    private final String NAME4JCE = "HmacSHA1";
    private Mac mac;
    private int outputLength;
    private String uri;
    static final byte[] MASK_BITS = new byte[]{-1, -2, -4, -8, -16, -32, -64, -128};

    public SignatureEngineHMAC(String u, Provider provider) throws NoSuchAlgorithmException {
        this.mac = provider == null ? Mac.getInstance("HmacSHA1") : Mac.getInstance("HmacSHA1", provider);
        this.outputLength = -1;
        this.uri = u;
    }

    public void setParameter(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec == null) {
            this.outputLength = -1;
            return;
        }
        if (!(spec instanceof HMACParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Invalid paremeter class: " + spec.getClass().getName());
        }
        HMACParameterSpec hspec = (HMACParameterSpec)spec;
        if (hspec.getOutputLength() <= 0) {
            throw new InvalidAlgorithmParameterException("Output length is less than 1: " + hspec.getOutputLength());
        }
        this.outputLength = hspec.getOutputLength();
    }

    public String getURI() {
        return this.uri;
    }

    public void initSign(Key key) throws InvalidKeyException {
        if (key instanceof SecretKeySpec) {
            try {
                byte[] ascii_bytes = new String(key.getEncoded()).getBytes("ISO8859-1");
                key = new SecretKeySpec(ascii_bytes, key.getAlgorithm());
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidKeyException(e.getMessage());
            }
        }
        this.mac.init(key);
    }

    public void initVerify(Key key) throws InvalidKeyException {
        this.mac.init(key);
    }

    public void update(byte[] data) throws SignatureException {
        this.mac.update(data);
    }

    public void update(byte[] data, int off, int len) throws SignatureException {
        this.mac.update(data, off, len);
    }

    public byte[] sign() throws SignatureException {
        return this.mask(this.mac.doFinal());
    }

    public boolean verify(byte[] signature) throws SignatureException {
        return MessageDigest.isEqual(this.mask(signature), this.sign());
    }

    private byte[] mask(byte[] in) {
        if (this.outputLength < 0) {
            return in;
        }
        int byteLen = (this.outputLength + 7) / 8;
        int extraBits = byteLen * 8 - this.outputLength;
        if (byteLen > in.length) {
            return in;
        }
        if (byteLen == in.length && extraBits == 0) {
            return in;
        }
        byte[] ret = new byte[byteLen];
        System.arraycopy(in, 0, ret, 0, byteLen);
        if (extraBits == 0) {
            return ret;
        }
        int n = byteLen - 1;
        ret[n] = (byte)(ret[n] & MASK_BITS[extraBits]);
        return ret;
    }
}

