/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.crypto.dsig;

import com.ibm.xml.crypto.spi.SignatureEngine;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;

public class SignatureEngineDSA
implements SignatureEngine {
    private Signature signature;
    private String uri;

    public SignatureEngineDSA(String u, Provider provider) throws NoSuchAlgorithmException {
        this.signature = provider == null ? Signature.getInstance("SHA1withDSA") : Signature.getInstance("SHA1withDSA", provider);
        this.uri = u;
    }

    public void setParameter(AlgorithmParameterSpec spec) throws InvalidAlgorithmParameterException {
        if (spec != null) {
            throw new InvalidAlgorithmParameterException("This algorithm supports  no AlgorithmParameterSpec.");
        }
    }

    public String getURI() {
        return this.uri;
    }

    public void initSign(Key key) throws InvalidKeyException {
        this.signature.initSign((PrivateKey)key);
    }

    public void initVerify(Key key) throws InvalidKeyException {
        this.signature.initVerify((PublicKey)key);
    }

    public void update(byte[] data) throws SignatureException {
        this.signature.update(data);
    }

    public void update(byte[] data, int off, int len) throws SignatureException {
        this.signature.update(data, off, len);
    }

    public byte[] sign() throws SignatureException {
        return SignatureEngineDSA.decodeRSfromASN1(this.signature.sign());
    }

    public boolean verify(byte[] signature) throws SignatureException {
        return this.signature.verify(SignatureEngineDSA.encodeRSinASN1(signature));
    }

    private static byte[] encodeRSinASN1(byte[] rs) throws SignatureException {
        if (rs.length != 40) {
            throw new SignatureException("Invalid DSA signature value size: " + rs.length);
        }
        int s_index = rs.length / 2;
        int rlen = rs[0] < 0 ? 21 : 20;
        int slen = rs[s_index] < 0 ? 21 : 20;
        byte[] result = new byte[rlen + slen + 6];
        result[0] = 48;
        result[1] = (byte)(rlen + slen + 4);
        result[2] = 2;
        result[3] = (byte)rlen;
        if (rs[0] < 0) {
            result[4] = 0;
            System.arraycopy(rs, 0, result, 5, 20);
        } else {
            System.arraycopy(rs, 0, result, 4, 20);
        }
        result[4 + rlen] = 2;
        result[5 + rlen] = (byte)slen;
        if (rs[s_index] < 0) {
            result[6 + rlen] = 0;
            System.arraycopy(rs, s_index, result, 7 + rlen, rs.length - s_index);
        } else {
            System.arraycopy(rs, s_index, result, 6 + rlen, rs.length - s_index);
        }
        return result;
    }

    private static byte[] decodeRSfromASN1(byte[] asn) {
        int gap;
        byte rlength = asn[3];
        byte slength = asn[4 + rlength + 1];
        byte[] result = new byte[40];
        if (rlength < 20) {
            for (gap = 0; gap < 20 - rlength; ++gap) {
                result[gap] = 0;
            }
            System.arraycopy(asn, 4, result, 20 - rlength, rlength);
        } else {
            System.arraycopy(asn, 4 + rlength - 20, result, 0, 20);
        }
        if (slength < 20) {
            for (gap = 0; gap < 20 - slength; ++gap) {
                result[20 + gap] = 0;
            }
            System.arraycopy(asn, 4 + rlength + 2, result, 40 - slength, slength);
        } else {
            System.arraycopy(asn, 4 + rlength + 2 + slength - 20, result, 20, 20);
        }
        return result;
    }
}

