/*===========================================================================
 * Licensed Materials - Property of IBM
 * "Restricted Materials of IBM"
 * 
 * IBM SDK, Java(tm) Technology Edition, v6
 * (C) Copyright IBM Corp. 1999, 2005. All Rights Reserved
 *
 * US Government Users Restricted Rights - Use, duplication or disclosure
 * restricted by GSA ADP Schedule Contract with IBM Corp.
 *===========================================================================
 */
/*
 * @(#)TextComponentPeer.java	1.19 05/11/17
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package java.awt.peer;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.im.InputMethodRequests;

/**
 * The peer interfaces are intended only for use in porting
 * the AWT. They are not intended for use by application
 * developers, and developers should not implement peers
 * nor invoke any of the peer methods directly on the peer
 * instances.
 */
public interface TextComponentPeer extends ComponentPeer {
    void setEditable(boolean editable);
    String getText();
    void setText(String l);
    int getSelectionStart();
    int getSelectionEnd();
    void select(int selStart, int selEnd);
    void setCaretPosition(int pos);
    int getCaretPosition();
    int getIndexAtPoint(int x, int y);
    Rectangle getCharacterBounds(int i);
    long filterEvents(long mask);
    InputMethodRequests getInputMethodRequests();
}
