/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPathParameters;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class PKIXParameters
implements CertPathParameters {
    private Set<TrustAnchor> unmodTrustAnchors;
    private Set<String> unmodInitialPolicies;
    private List<CertStore> certStores;
    private boolean revocationEnabled;
    private boolean explicitPolicyRequired;
    private boolean policyMappingInhibited;
    private boolean policyQualifiersRejected;
    private boolean anyPolicyInhibited;
    private Date date;
    private List<PKIXCertPathChecker> certPathCheckers;
    private String sigProvider;
    private CertSelector targetConstraints;

    public PKIXParameters(Set<TrustAnchor> trustAnchors) throws InvalidAlgorithmParameterException {
        this.setTrustAnchors(trustAnchors);
        this.initialize();
    }

    public PKIXParameters(KeyStore keystore) throws KeyStoreException, InvalidAlgorithmParameterException {
        if (keystore == null) {
            throw new NullPointerException("the keystore parameter must be non-null");
        }
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        Enumeration<String> e = keystore.aliases();
        while (e.hasMoreElements()) {
            Certificate cert;
            String alias = e.nextElement();
            if (!keystore.isCertificateEntry(alias) || !((cert = keystore.getCertificate(alias)) instanceof X509Certificate)) continue;
            trustAnchors.add(new TrustAnchor((X509Certificate)cert, null));
        }
        if (trustAnchors.isEmpty()) {
            throw new InvalidAlgorithmParameterException();
        }
        this.unmodTrustAnchors = Collections.unmodifiableSet(trustAnchors);
        this.initialize();
    }

    private void initialize() {
        this.unmodInitialPolicies = Collections.emptySet();
        this.certStores = new ArrayList<CertStore>();
        this.setRevocationEnabled(true);
        this.setExplicitPolicyRequired(false);
        this.setPolicyMappingInhibited(false);
        this.setPolicyQualifiersRejected(true);
        this.setDate(null);
        this.certPathCheckers = new ArrayList<PKIXCertPathChecker>();
        this.setSigProvider(null);
    }

    @Override
    public Object clone() {
        try {
            Object copy = super.clone();
            if (this.certStores != null) {
                this.certStores = new ArrayList<CertStore>(this.certStores);
            }
            if (this.certPathCheckers != null) {
                this.certPathCheckers = new ArrayList<PKIXCertPathChecker>(this.certPathCheckers);
            }
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public CertSelector getTargetCertConstraints() {
        if (this.targetConstraints == null) {
            return null;
        }
        return (CertSelector)this.targetConstraints.clone();
    }

    public void setTargetCertConstraints(CertSelector selector) {
        this.targetConstraints = selector != null ? (CertSelector)selector.clone() : null;
    }

    public Set<TrustAnchor> getTrustAnchors() {
        return this.unmodTrustAnchors;
    }

    public void setTrustAnchors(Set<TrustAnchor> trustAnchors) throws InvalidAlgorithmParameterException {
        if (trustAnchors == null) {
            throw new NullPointerException("the trustAnchors parameters must be non-null");
        }
        if (trustAnchors.isEmpty()) {
            throw new InvalidAlgorithmParameterException("the trustAnchors parameter must be non-empty");
        }
        Iterator<TrustAnchor> i = trustAnchors.iterator();
        while (i.hasNext()) {
            if (i.next() instanceof TrustAnchor) continue;
            throw new ClassCastException("all elements of set must be of type java.security.cert.TrustAnchor");
        }
        this.unmodTrustAnchors = Collections.unmodifiableSet(new HashSet<TrustAnchor>(trustAnchors));
    }

    public Set<String> getInitialPolicies() {
        return this.unmodInitialPolicies;
    }

    public void setInitialPolicies(Set<String> initialPolicies) {
        if (initialPolicies != null) {
            Iterator<String> it = initialPolicies.iterator();
            while (it.hasNext()) {
                if (it.next() instanceof String) continue;
                throw new ClassCastException("all elements in initialPolicies must be of type java.lang.String");
            }
            this.unmodInitialPolicies = Collections.unmodifiableSet(new HashSet<String>(initialPolicies));
        } else {
            this.unmodInitialPolicies = Collections.emptySet();
        }
    }

    public void setCertStores(List<CertStore> stores) {
        if (stores != null) {
            Iterator<CertStore> i = stores.iterator();
            while (i.hasNext()) {
                if (i.next() instanceof CertStore) continue;
                throw new ClassCastException("elements in stores must be of type java.security.cert.CertStore");
            }
            this.certStores = new ArrayList<CertStore>(stores);
        } else {
            this.certStores = new ArrayList<CertStore>();
        }
    }

    public void addCertStore(CertStore store) {
        if (store != null) {
            this.certStores.add(store);
        }
    }

    public List<CertStore> getCertStores() {
        return Collections.unmodifiableList(new ArrayList<CertStore>(this.certStores));
    }

    public void setRevocationEnabled(boolean val) {
        this.revocationEnabled = val;
    }

    public boolean isRevocationEnabled() {
        return this.revocationEnabled;
    }

    public void setExplicitPolicyRequired(boolean val) {
        this.explicitPolicyRequired = val;
    }

    public boolean isExplicitPolicyRequired() {
        return this.explicitPolicyRequired;
    }

    public void setPolicyMappingInhibited(boolean val) {
        this.policyMappingInhibited = val;
    }

    public boolean isPolicyMappingInhibited() {
        return this.policyMappingInhibited;
    }

    public void setAnyPolicyInhibited(boolean val) {
        this.anyPolicyInhibited = val;
    }

    public boolean isAnyPolicyInhibited() {
        return this.anyPolicyInhibited;
    }

    public void setPolicyQualifiersRejected(boolean qualifiersRejected) {
        this.policyQualifiersRejected = qualifiersRejected;
    }

    public boolean getPolicyQualifiersRejected() {
        return this.policyQualifiersRejected;
    }

    public Date getDate() {
        return this.date != null ? (Date)this.date.clone() : null;
    }

    public void setDate(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public void setCertPathCheckers(List<PKIXCertPathChecker> checkers) {
        if (checkers != null) {
            ArrayList<PKIXCertPathChecker> tmpList = new ArrayList<PKIXCertPathChecker>();
            for (PKIXCertPathChecker checker : checkers) {
                tmpList.add((PKIXCertPathChecker)checker.clone());
            }
            this.certPathCheckers = tmpList;
        } else {
            this.certPathCheckers = new ArrayList<PKIXCertPathChecker>();
        }
    }

    public List<PKIXCertPathChecker> getCertPathCheckers() {
        ArrayList<PKIXCertPathChecker> tmpList = new ArrayList<PKIXCertPathChecker>();
        for (PKIXCertPathChecker ck : this.certPathCheckers) {
            tmpList.add((PKIXCertPathChecker)ck.clone());
        }
        return Collections.unmodifiableList(tmpList);
    }

    public void addCertPathChecker(PKIXCertPathChecker checker) {
        if (checker != null) {
            this.certPathCheckers.add((PKIXCertPathChecker)checker.clone());
        }
    }

    public String getSigProvider() {
        return this.sigProvider;
    }

    public void setSigProvider(String sigProvider) {
        this.sigProvider = sigProvider;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[\n");
        if (this.unmodTrustAnchors != null) {
            sb.append("  Trust Anchors: " + this.unmodTrustAnchors.toString());
        }
        if (this.unmodInitialPolicies != null) {
            if (this.unmodInitialPolicies.isEmpty()) {
                sb.append("  \nInitial Policy OIDs: any");
            } else {
                sb.append("  \nInitial Policy OIDs: [" + this.unmodInitialPolicies.toString() + "]");
            }
        }
        sb.append("  \nValidity Date: " + String.valueOf(this.date));
        sb.append("  \nSignature Provider: " + String.valueOf(this.sigProvider));
        sb.append("  \nDefault Revocation Enabled: " + this.revocationEnabled);
        sb.append("  \nExplicit Policy Required: " + this.explicitPolicyRequired);
        sb.append("  \nPolicy Mapping Inhibited: " + this.policyMappingInhibited);
        sb.append("  \nAny Policy Inhibited: " + this.anyPolicyInhibited);
        sb.append("  \nPolicy Qualifiers Rejected: " + this.policyQualifiersRejected);
        sb.append("  \nTarget Cert Constraints: " + String.valueOf(this.targetConstraints));
        if (this.certPathCheckers != null) {
            sb.append("  \nCertification Path Checkers: [" + this.certPathCheckers.toString() + "]");
        }
        if (this.certStores != null) {
            sb.append("  \nCertStores: [" + this.certStores.toString() + "]");
        }
        sb.append("\n]");
        return sb.toString();
    }
}

