/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jvm.format;

import com.ibm.jvm.format.TraceArgs;
import com.ibm.jvm.format.TraceFile;
import com.ibm.jvm.format.Util;
import java.io.BufferedWriter;
import java.io.IOException;

public class ServiceSection {
    private String eyecatcher_string;
    private int length;
    private int version;
    private int modification;
    private long level_offset;
    private String serviceString;
    private TraceFile traceFile;

    public ServiceSection(TraceFile traceFile, int start) throws IOException {
        byte temp = 0;
        this.traceFile = traceFile;
        traceFile.seek(start);
        this.eyecatcher_string = Util.convertAndCheckEyecatcher(traceFile.readI());
        this.length = traceFile.readI();
        this.version = traceFile.readI();
        this.modification = traceFile.readI();
        this.level_offset = traceFile.getFilePointer();
        this.serviceString = "";
        traceFile.seek(this.level_offset);
        while ((temp = traceFile.readByte()) != 0) {
            this.serviceString = this.serviceString + (char)temp;
        }
        Util.Debug.println("ServiceSection: eyecatcher:        " + this.eyecatcher_string);
        Util.Debug.println("ServiceSection: length:            " + this.length);
        Util.Debug.println("ServiceSection: version:           " + this.version);
        Util.Debug.println("ServiceSection: modification:      " + this.modification);
        Util.Debug.println("ServiceSection: string:            " + this.serviceString);
    }

    protected void summary(BufferedWriter out) throws IOException {
        Util.Debug.println("ServiceSection: level_offset:        " + this.level_offset);
        out.write("Service Level :");
        out.newLine();
        out.write("        " + this.serviceString);
        out.newLine();
        out.newLine();
    }

    protected String formatFileName() {
        if (this.serviceString.indexOf(" IBM J9 ") != -1 || this.serviceString.indexOf("Unknown version") != -1 || TraceArgs.j9) {
            String[] vmLevelParts = this.getVMLevel().split("[.]");
            String fileExtension = "";
            for (int i = 0; vmLevelParts != null && i < vmLevelParts.length; ++i) {
                fileExtension = fileExtension + vmLevelParts[i];
            }
            String fileName = "J9TraceFormat" + fileExtension + ".dat";
            Util.Debug.println("ServiceSection: formatFile:  " + fileName);
            return fileName;
        }
        Util.Debug.println("ServiceSection: formatFile: TraceFormat.dat");
        return "TraceFormat.dat";
    }

    protected String getNextFormatFileName(String previous) {
        if (previous == null) {
            return null;
        }
        if (previous.equals("J9TraceFormat22.dat")) {
            return "J9TraceFormat23.dat";
        }
        if (previous.equals("J9TraceFormat23.dat")) {
            return "J9TraceFormat24.dat";
        }
        if (previous.equals("J9TraceFormat24.dat")) {
            return "J9TraceFormat25.dat";
        }
        return null;
    }

    protected String getServiceLevel() {
        return this.serviceString;
    }

    protected String getVMLevel() {
        if (this.serviceString.indexOf("2.2") != -1) {
            return "2.2";
        }
        if (this.serviceString.indexOf("2.3") != -1) {
            return "2.3";
        }
        if (this.serviceString.indexOf("2.4") != -1) {
            return "2.4";
        }
        if (this.serviceString.indexOf("2.5") != -1) {
            return "2.5";
        }
        return "unknown";
    }
}

