/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import com.ibm.security.cmskeystore.BadFileTypeException;
import com.ibm.security.cmskeystore.BadMagicNumberException;
import com.ibm.security.cmskeystore.BadVersionNumberException;
import com.ibm.security.cmskeystore.ByteSequenceInputStream;
import com.ibm.security.cmskeystore.ByteSequenceInputStreamFactory;
import com.ibm.security.cmskeystore.FileHeader;
import com.ibm.security.cmskeystore.FileType;
import com.ibm.security.cmskeystore.IntableByteSequence;
import com.ibm.security.cmskeystore.IntableByteSequenceFactory;
import com.ibm.security.cmskeystore.MagicNumberValidator;
import com.ibm.security.cmskeystore.MagicNumberValidatorFactory;
import com.ibm.security.cmskeystore.VersionNumber;
import com.ibm.security.sequence.bytes.ByteSequence;
import com.ibm.security.sequence.bytes.ByteSequenceIterator;
import java.io.IOException;
import java.io.InputStream;

final class FileHeaderFactory {
    private static final int HASH_LENGTH_V3 = 16;
    private static final int HASH_LENGTH_V4 = 20;

    private FileHeaderFactory() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public static FileHeader newFileHeader(InputStream in) throws NullPointerException, BadMagicNumberException, BadVersionNumberException, BadFileTypeException, IOException {
        if (in == null) {
            throw new NullPointerException();
        }
        ByteSequenceInputStream bsis = ByteSequenceInputStreamFactory.newByteSequenceInputStream();
        MagicNumberValidator mnv = MagicNumberValidatorFactory.newMagicNumberValidator();
        ByteSequence s = bsis.getByteSequence(in, 2);
        if (s == null) {
            return null;
        }
        if (!mnv.isValid(s)) {
            throw new BadMagicNumberException(s);
        }
        IntableByteSequence magicNumber = IntableByteSequenceFactory.newIntableByteSequence(s);
        s = bsis.getByteSequence(in, 1);
        if (s == null) {
            return null;
        }
        VersionNumber majorVersionNumber = VersionNumber.versionNumberFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(s));
        if (majorVersionNumber == null) {
            throw new BadVersionNumberException(s);
        }
        s = bsis.getByteSequence(in, 1);
        if (s == null) {
            return null;
        }
        VersionNumber minorVersionNumber = VersionNumber.versionNumberFromByteSequence(IntableByteSequenceFactory.newIntableByteSequence(s));
        if (minorVersionNumber == null) {
            throw new BadVersionNumberException(s);
        }
        s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence passwordExpirationTime = IntableByteSequenceFactory.newIntableByteSequence(s);
        ByteSequence fileTypeByteSequence = bsis.getByteSequence(in, 8);
        if (fileTypeByteSequence == null) {
            return null;
        }
        FileType fileType = FileType.fileTypeFromByteSequence(fileTypeByteSequence);
        if (fileType == null) {
            throw new BadFileTypeException(fileType);
        }
        s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence fixedRecordLength = IntableByteSequenceFactory.newIntableByteSequence(s);
        s = bsis.getByteSequence(in, 4);
        if (s == null) {
            return null;
        }
        IntableByteSequence recordsAllocated = IntableByteSequenceFactory.newIntableByteSequence(s);
        s = bsis.getByteSequence(in, 24);
        if (s == null) {
            return null;
        }
        IntableByteSequence fileLabel = IntableByteSequenceFactory.newIntableByteSequence(s);
        int hashLength = FileHeaderFactory.getHashLength(majorVersionNumber, minorVersionNumber);
        ByteSequence passwordHeaderHash = bsis.getByteSequence(in, hashLength);
        if (passwordHeaderHash == null) {
            return null;
        }
        ByteSequence passwordDatabaseHash = bsis.getByteSequence(in, hashLength);
        if (passwordDatabaseHash == null) {
            return null;
        }
        return new FileHeaderImpl(magicNumber, majorVersionNumber, minorVersionNumber, passwordExpirationTime, fileType, fixedRecordLength, recordsAllocated, fileLabel, passwordHeaderHash, passwordDatabaseHash);
    }

    private static int getHashLength(VersionNumber major, VersionNumber minor) {
        if (major.equals(VersionNumber.THREE)) {
            return 16;
        }
        return 20;
    }

    private static final class FileHeaderImpl
    implements FileHeader {
        private final IntableByteSequence magicNumber;
        private final VersionNumber majorVersionNumber;
        private final VersionNumber minorVersionNumber;
        private final IntableByteSequence passwordExpirationTime;
        private final FileType fileType;
        private final IntableByteSequence fixedRecordLength;
        private final IntableByteSequence recordsAllocated;
        private final ByteSequence fileLabel;
        private final ByteSequence passwordHeaderHash;
        private final ByteSequence passwordDatabaseHash;
        private final ByteSequence sequence;

        FileHeaderImpl(IntableByteSequence magicNumber, VersionNumber majorVersionNumber, VersionNumber minorVersionNumber, IntableByteSequence passwordExpirationTime, FileType fileType, IntableByteSequence fixedRecordLength, IntableByteSequence recordsAllocated, ByteSequence fileLabel, ByteSequence passwordHeaderHash, ByteSequence passwordDatabaseHash) {
            this.magicNumber = magicNumber;
            this.majorVersionNumber = majorVersionNumber;
            this.minorVersionNumber = minorVersionNumber;
            this.passwordExpirationTime = passwordExpirationTime;
            this.fileType = fileType;
            this.fixedRecordLength = fixedRecordLength;
            this.recordsAllocated = recordsAllocated;
            this.fileLabel = fileLabel;
            this.passwordHeaderHash = passwordHeaderHash;
            this.passwordDatabaseHash = passwordDatabaseHash;
            this.sequence = magicNumber.append(majorVersionNumber).append(minorVersionNumber).append(passwordExpirationTime).append(fileType).append(fixedRecordLength).append(recordsAllocated).append(fileLabel).append(passwordHeaderHash).append(passwordDatabaseHash);
        }

        public IntableByteSequence getMagicNumber() {
            return this.magicNumber;
        }

        public VersionNumber getMajorVersionNumber() {
            return this.majorVersionNumber;
        }

        public VersionNumber getMinorVersionNumber() {
            return this.minorVersionNumber;
        }

        public IntableByteSequence getPasswordExpirationTime() {
            return this.passwordExpirationTime;
        }

        public FileType getFileType() {
            return this.fileType;
        }

        public IntableByteSequence getFixedRecordLength() {
            return this.fixedRecordLength;
        }

        public IntableByteSequence getRecordsAllocated() {
            return this.recordsAllocated;
        }

        public ByteSequence getFileLabel() {
            return this.fileLabel;
        }

        public ByteSequence getPasswordHeaderHash() {
            return this.passwordHeaderHash;
        }

        public ByteSequence getPasswordDatabaseHash() {
            return this.passwordDatabaseHash;
        }

        public byte get(int index) throws IndexOutOfBoundsException {
            if (index < 0 || index >= this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.get(index);
        }

        public int length() {
            return this.sequence.length();
        }

        public ByteSequence append(ByteSequence sequence) throws NullPointerException {
            if (sequence == null) {
                throw new NullPointerException();
            }
            if (sequence.length() == 0) {
                return this;
            }
            return this.sequence.append(sequence);
        }

        public ByteSequence getSubSequence(int fromPosition, int toPosition) throws IndexOutOfBoundsException {
            if (fromPosition < 0 || toPosition > this.sequence.length() || fromPosition > toPosition) {
                throw new IndexOutOfBoundsException();
            }
            return this.sequence.getSubSequence(fromPosition, toPosition);
        }

        public int indexOf(byte b) {
            return this.sequence.indexOf(b);
        }

        public int indexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.indexOf(position, b);
        }

        public int lastIndexOf(byte b) {
            return this.sequence.lastIndexOf(b);
        }

        public int lastIndexOf(int position, byte b) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.lastIndexOf(position, b);
        }

        public boolean isEmpty() {
            return this.sequence.isEmpty();
        }

        public InputStream getInputStream() {
            return this.sequence.getInputStream();
        }

        public ByteSequenceIterator getIterator() {
            return this.sequence.getIterator();
        }

        public ByteSequenceIterator getIterator(int position) throws IndexOutOfBoundsException {
            if (position < 0 || position > this.sequence.length()) {
                throw new IndexOutOfBoundsException(String.valueOf(position));
            }
            return this.sequence.getIterator(position);
        }

        public String toBinaryString() {
            return this.sequence.toBinaryString();
        }

        public String toOctalString() {
            return this.sequence.toOctalString();
        }

        public String toHexString() {
            return this.sequence.toHexString();
        }

        public String toString() {
            return ((Object)this.sequence).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof ByteSequence)) {
                return false;
            }
            ByteSequence s = (ByteSequence)o;
            ByteSequenceIterator it1 = this.getIterator();
            ByteSequenceIterator it2 = s.getIterator();
            while (it1.hasNextByte() && it2.hasNextByte()) {
                byte e2;
                byte e1 = it1.getNextByte();
                if (e1 == (e2 = it2.getNextByte())) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return ((Object)this.sequence).hashCode();
        }
    }
}

