/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmskeystore;

import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CMSCertificate
extends X509Certificate {
    private final Certificate cert;
    private boolean trusted;

    public CMSCertificate(Certificate cert, boolean isTrusted) {
        this.cert = cert;
        this.trusted = isTrusted;
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        ((X509Certificate)this.cert).checkValidity();
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        ((X509Certificate)this.cert).checkValidity(date);
    }

    @Override
    public int getBasicConstraints() {
        return ((X509Certificate)this.cert).getBasicConstraints();
    }

    @Override
    public Principal getIssuerDN() {
        return ((X509Certificate)this.cert).getIssuerDN();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        return ((X509Certificate)this.cert).getIssuerUniqueID();
    }

    @Override
    public boolean[] getKeyUsage() {
        return ((X509Certificate)this.cert).getKeyUsage();
    }

    @Override
    public Date getNotAfter() {
        return ((X509Certificate)this.cert).getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return ((X509Certificate)this.cert).getNotBefore();
    }

    @Override
    public BigInteger getSerialNumber() {
        return ((X509Certificate)this.cert).getSerialNumber();
    }

    @Override
    public String getSigAlgName() {
        return ((X509Certificate)this.cert).getSigAlgName();
    }

    @Override
    public String getSigAlgOID() {
        return ((X509Certificate)this.cert).getSigAlgOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return ((X509Certificate)this.cert).getSigAlgParams();
    }

    @Override
    public byte[] getSignature() {
        return ((X509Certificate)this.cert).getSignature();
    }

    @Override
    public Principal getSubjectDN() {
        return ((X509Certificate)this.cert).getSubjectDN();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        return ((X509Certificate)this.cert).getSubjectUniqueID();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        return ((X509Certificate)this.cert).getTBSCertificate();
    }

    @Override
    public int getVersion() {
        return ((X509Certificate)this.cert).getVersion();
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.cert.getEncoded();
    }

    @Override
    public PublicKey getPublicKey() {
        return this.cert.getPublicKey();
    }

    @Override
    public String toString() {
        return this.cert.toString();
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.cert.verify(key);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.cert.verify(key, sigProvider);
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        return ((X509Extension)((Object)this.cert)).getCriticalExtensionOIDs();
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        return ((X509Extension)((Object)this.cert)).getExtensionValue(oid);
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        return ((X509Extension)((Object)this.cert)).getNonCriticalExtensionOIDs();
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return ((X509Extension)((Object)this.cert)).hasUnsupportedCriticalExtension();
    }

    public boolean isTrusted() {
        return this.trusted;
    }

    public void setTrusted(boolean trusted) {
        this.trusted = trusted;
    }
}

