/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.luni.internal.process;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.harmony.luni.internal.process.ProcessInputStream;
import org.apache.harmony.luni.internal.process.ProcessOutputStream;
import org.apache.harmony.luni.util.Util;

public class SystemProcess
extends Process {
    private InputStream err;
    private InputStream out;
    private OutputStream in;
    private long handle = -1L;
    private boolean exitCodeAvailable;
    private int exitCode;
    private Object lock;
    private boolean waiterStarted;
    private Throwable exception;

    private static native void oneTimeInitialization();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process create(String[] stringArray, String[] stringArray2, final File file) throws IOException {
        int n;
        final byte[][] byArrayArray = new byte[stringArray.length][];
        for (n = 0; n < stringArray.length; ++n) {
            byArrayArray[n] = Util.getBytes(stringArray[n]);
        }
        final byte[][] byArrayArray2 = new byte[stringArray2.length][];
        for (n = 0; n < stringArray2.length; ++n) {
            byArrayArray2[n] = Util.getBytes(stringArray2[n]);
        }
        final SystemProcess systemProcess = new SystemProcess();
        systemProcess.lock = new Lock();
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long[] lArray = null;
                try {
                    lArray = SystemProcess.createImpl(systemProcess, byArrayArray, byArrayArray2, file == null ? null : Util.getBytes(file.getPath()));
                }
                catch (Throwable throwable) {
                    Object object = systemProcess.lock;
                    synchronized (object) {
                        systemProcess.exception = throwable;
                        systemProcess.waiterStarted = true;
                        systemProcess.lock.notifyAll();
                    }
                    return;
                }
                systemProcess.handle = lArray[0];
                systemProcess.in = new BufferedOutputStream(new ProcessOutputStream(lArray[1]));
                systemProcess.out = new BufferedInputStream(new ProcessInputStream(lArray[2]));
                systemProcess.err = new BufferedInputStream(new ProcessInputStream(lArray[3]));
                Object object = systemProcess.lock;
                synchronized (object) {
                    systemProcess.waiterStarted = true;
                    systemProcess.lock.notifyAll();
                }
                systemProcess.exitCode = systemProcess.waitForCompletionImpl();
                object = systemProcess.lock;
                synchronized (object) {
                    systemProcess.closeImpl();
                    systemProcess.handle = -1L;
                }
                systemProcess.exitCodeAvailable = true;
                object = systemProcess.lock;
                synchronized (object) {
                    try {
                        systemProcess.in.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    systemProcess.lock.notifyAll();
                }
            }
        };
        Thread thread = new Thread(runnable);
        thread.setDaemon(true);
        thread.start();
        try {
            Object object = systemProcess.lock;
            synchronized (object) {
                while (!systemProcess.waiterStarted) {
                    systemProcess.lock.wait();
                }
                if (systemProcess.exception != null) {
                    systemProcess.exception.fillInStackTrace();
                    if (systemProcess.exception instanceof IOException) {
                        throw (IOException)systemProcess.exception;
                    }
                    if (systemProcess.exception instanceof Error) {
                        throw (Error)systemProcess.exception;
                    }
                    throw (RuntimeException)systemProcess.exception;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InternalError();
        }
        return systemProcess;
    }

    protected static synchronized native long[] createImpl(Process var0, byte[][] var1, byte[][] var2, byte[] var3) throws IOException;

    private SystemProcess() {
    }

    private native void destroyImpl();

    native void closeImpl();

    native int waitForCompletionImpl();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            if (this.handle != -1L) {
                this.destroyImpl();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int exitValue() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.exitCodeAvailable) {
                throw new IllegalThreadStateException();
            }
            return this.exitCode;
        }
    }

    @Override
    public InputStream getErrorStream() {
        return this.err;
    }

    @Override
    public InputStream getInputStream() {
        return this.out;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int waitFor() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.exitCodeAvailable) {
                this.lock.wait();
            }
            return this.exitCode;
        }
    }

    static {
        SystemProcess.oneTimeInitialization();
    }

    private static class Lock {
        private Lock() {
        }
    }
}

