/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.harmony.luni.util.Msg;

public final class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = -4856846361193249489L;
    private static SecureRandom rng;
    private long mostSigBits;
    private long leastSigBits;
    private transient int variant;
    private transient int version;
    private transient long timestamp;
    private transient int clockSequence;
    private transient long node;
    private transient int hash;

    public UUID(long l, long l2) {
        this.mostSigBits = l;
        this.leastSigBits = l2;
        this.init();
    }

    private void init() {
        int n = (int)(this.mostSigBits ^ this.mostSigBits >>> 32);
        int n2 = (int)(this.leastSigBits ^ this.leastSigBits >>> 32);
        this.hash = n ^ n2;
        this.variant = (this.leastSigBits & Long.MIN_VALUE) == 0L ? 0 : ((this.leastSigBits & 0x4000000000000000L) != 0L ? (int)((this.leastSigBits & 0xE000000000000000L) >>> 61) : 2);
        this.version = (int)((this.mostSigBits & 0xF000L) >>> 12);
        if (this.variant != 2 && this.version != 1) {
            return;
        }
        long l = (this.mostSigBits & 0xFFFFFFFF00000000L) >>> 32;
        long l2 = (this.mostSigBits & 0xFFFF0000L) << 16;
        long l3 = (this.mostSigBits & 0xFFFL) << 48;
        this.timestamp = l | l2 | l3;
        this.clockSequence = (int)((this.leastSigBits & 0x3FFF000000000000L) >>> 48);
        this.node = this.leastSigBits & 0xFFFFFFFFFFFFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID randomUUID() {
        Class<UUID> clazz = UUID.class;
        synchronized (UUID.class) {
            if (rng == null) {
                rng = new SecureRandom();
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            byte[] byArray = new byte[16];
            rng.nextBytes(byArray);
            long l = ((long)byArray[0] & 0xFFL) << 56;
            l |= ((long)byArray[1] & 0xFFL) << 48;
            l |= ((long)byArray[2] & 0xFFL) << 40;
            l |= ((long)byArray[3] & 0xFFL) << 32;
            l |= ((long)byArray[4] & 0xFFL) << 24;
            l |= ((long)byArray[5] & 0xFFL) << 16;
            l |= ((long)byArray[6] & 0xFL) << 8;
            l |= 0x4000L;
            l |= (long)byArray[7] & 0xFFL;
            long l2 = ((long)byArray[8] & 0x3FL) << 56;
            l2 |= Long.MIN_VALUE;
            l2 |= ((long)byArray[9] & 0xFFL) << 48;
            l2 |= ((long)byArray[10] & 0xFFL) << 40;
            l2 |= ((long)byArray[11] & 0xFFL) << 32;
            l2 |= ((long)byArray[12] & 0xFFL) << 24;
            l2 |= ((long)byArray[13] & 0xFFL) << 16;
            l2 |= ((long)byArray[14] & 0xFFL) << 8;
            return new UUID(l, l2 |= (long)byArray[15] & 0xFFL);
        }
    }

    public static UUID nameUUIDFromBytes(byte[] byArray) {
        byte[] byArray2;
        if (byArray == null) {
            throw new NullPointerException();
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byArray2 = messageDigest.digest(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
        long l = ((long)byArray2[0] & 0xFFL) << 56;
        l |= ((long)byArray2[1] & 0xFFL) << 48;
        l |= ((long)byArray2[2] & 0xFFL) << 40;
        l |= ((long)byArray2[3] & 0xFFL) << 32;
        l |= ((long)byArray2[4] & 0xFFL) << 24;
        l |= ((long)byArray2[5] & 0xFFL) << 16;
        l |= ((long)byArray2[6] & 0xFL) << 8;
        l |= 0x3000L;
        l |= (long)byArray2[7] & 0xFFL;
        long l2 = ((long)byArray2[8] & 0x3FL) << 56;
        l2 |= Long.MIN_VALUE;
        l2 |= ((long)byArray2[9] & 0xFFL) << 48;
        l2 |= ((long)byArray2[10] & 0xFFL) << 40;
        l2 |= ((long)byArray2[11] & 0xFFL) << 32;
        l2 |= ((long)byArray2[12] & 0xFFL) << 24;
        l2 |= ((long)byArray2[13] & 0xFFL) << 16;
        l2 |= ((long)byArray2[14] & 0xFFL) << 8;
        return new UUID(l, l2 |= (long)byArray2[15] & 0xFFL);
    }

    public static UUID fromString(String string) {
        int n;
        if (string == null) {
            throw new NullPointerException();
        }
        int[] nArray = new int[5];
        int n2 = 1;
        int n3 = 0;
        for (n = 0; n < nArray.length && n2 > 0; ++n) {
            nArray[n] = string.indexOf("-", n3);
            n2 = nArray[n];
            n3 = nArray[n] + 1;
        }
        if (n != nArray.length || n2 != -1) {
            throw new IllegalArgumentException(Msg.getString("KA014") + string);
        }
        long l = Long.parseLong(string.substring(0, nArray[0]), 16);
        long l2 = Long.parseLong(string.substring(nArray[0] + 1, nArray[1]), 16);
        long l3 = Long.parseLong(string.substring(nArray[1] + 1, nArray[2]), 16);
        long l4 = Long.parseLong(string.substring(nArray[2] + 1, nArray[3]), 16);
        long l5 = Long.parseLong(string.substring(nArray[3] + 1), 16);
        long l6 = l << 32 | l2 << 16 | l3;
        long l7 = l4 << 48 | l5;
        return new UUID(l6, l7);
    }

    public long getLeastSignificantBits() {
        return this.leastSigBits;
    }

    public long getMostSignificantBits() {
        return this.mostSigBits;
    }

    public int version() {
        return this.version;
    }

    public int variant() {
        return this.variant;
    }

    public long timestamp() {
        if (this.version != 1) {
            throw new UnsupportedOperationException();
        }
        return this.timestamp;
    }

    public int clockSequence() {
        if (this.version != 1) {
            throw new UnsupportedOperationException();
        }
        return this.clockSequence;
    }

    public long node() {
        if (this.version != 1) {
            throw new UnsupportedOperationException();
        }
        return this.node;
    }

    @Override
    public int compareTo(UUID uUID) {
        if (uUID == this) {
            return 0;
        }
        if (this.mostSigBits != uUID.mostSigBits) {
            return this.mostSigBits < uUID.mostSigBits ? -1 : 1;
        }
        assert (this.mostSigBits == uUID.mostSigBits);
        if (this.leastSigBits != uUID.leastSigBits) {
            return this.leastSigBits < uUID.leastSigBits ? -1 : 1;
        }
        assert (this.leastSigBits == uUID.leastSigBits);
        return 0;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof UUID)) {
            return false;
        }
        UUID uUID = (UUID)object;
        return this.leastSigBits == uUID.leastSigBits && this.mostSigBits == uUID.mostSigBits;
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(36);
        String string = Long.toHexString(this.mostSigBits);
        if (string.length() < 16) {
            int n2 = 16 - string.length();
            for (n = 0; n < n2; ++n) {
                stringBuilder.append('0');
            }
        }
        stringBuilder.append(string);
        stringBuilder.insert(8, '-');
        stringBuilder.insert(13, '-');
        stringBuilder.append('-');
        String string2 = Long.toHexString(this.leastSigBits);
        if (string2.length() < 16) {
            n = 16 - string2.length();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append('0');
            }
        }
        stringBuilder.append(string2);
        stringBuilder.insert(23, '-');
        return stringBuilder.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.init();
    }
}

