/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.CharBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.InputMismatchException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.harmony.luni.util.Msg;

public final class Scanner
implements Iterator<String> {
    private static final Pattern DEFAULT_DELIMITER = Pattern.compile("\\p{javaWhitespace}+");
    private static final Pattern BOOLEAN_PATTERN = Pattern.compile("true|false", 2);
    private static final Pattern LINE_TERMINATOR;
    private static final Pattern MULTI_LINE_TERMINATOR;
    private static final Pattern LINE_PATTERN;
    private static final Pattern ANY_PATTERN;
    private static final int DIPLOID = 2;
    private static final int DEFAULT_RADIX = 10;
    private static final int DEFAULT_TRUNK_SIZE = 1024;
    private Readable input;
    private CharBuffer buffer;
    private Pattern delimiter = DEFAULT_DELIMITER;
    private Matcher matcher;
    private int integerRadix = 10;
    private Locale locale = Locale.getDefault();
    private int findStartIndex;
    private int preStartIndex = this.findStartIndex = 0;
    private int bufferLength = 0;
    private boolean closed = false;
    private IOException lastIOException;
    private boolean matchSuccessful = false;
    private DecimalFormat decimalFormat;
    private boolean inputExhausted = false;
    private Object cacheHasNextValue = null;
    private int cachehasNextIndex = -1;

    public Scanner(File file) throws FileNotFoundException {
        this(file, Charset.defaultCharset().name());
    }

    public Scanner(File file, String string) throws FileNotFoundException {
        if (null == file) {
            throw new NullPointerException(Msg.getString("KA00a"));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        if (null == string) {
            throw new IllegalArgumentException(Msg.getString("KA009"));
        }
        try {
            this.input = new InputStreamReader((InputStream)fileInputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
        this.initialization();
    }

    public Scanner(String string) {
        this.input = new StringReader(string);
        this.initialization();
    }

    public Scanner(InputStream inputStream) {
        this(inputStream, Charset.defaultCharset().name());
    }

    public Scanner(InputStream inputStream, String string) {
        if (null == inputStream) {
            throw new NullPointerException(Msg.getString("KA00b"));
        }
        try {
            this.input = new InputStreamReader(inputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(unsupportedEncodingException.getMessage());
        }
        this.initialization();
    }

    public Scanner(Readable readable) {
        if (null == readable) {
            throw new NullPointerException();
        }
        this.input = readable;
        this.initialization();
    }

    public Scanner(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, Charset.defaultCharset().name());
    }

    public Scanner(ReadableByteChannel readableByteChannel, String string) {
        if (null == readableByteChannel) {
            throw new NullPointerException(Msg.getString("KA00d"));
        }
        if (null == string) {
            throw new IllegalArgumentException(Msg.getString("KA009"));
        }
        this.input = Channels.newReader(readableByteChannel, string);
        this.initialization();
    }

    public void close() {
        if (this.closed) {
            return;
        }
        if (this.input instanceof Closeable) {
            try {
                ((Closeable)((Object)this.input)).close();
            }
            catch (IOException iOException) {
                this.lastIOException = iOException;
            }
        }
        this.closed = true;
    }

    public Pattern delimiter() {
        return this.delimiter;
    }

    public String findInLine(Pattern pattern) {
        this.checkClosed();
        this.checkNull(pattern);
        int n = 0;
        this.matcher.usePattern(MULTI_LINE_TERMINATOR);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        boolean bl = false;
        int n2 = 0;
        while (!bl) {
            if (this.matcher.find()) {
                n = this.matcher.start();
                n2 = this.matcher.end() - this.matcher.start();
                bl = true;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            n = this.bufferLength;
            bl = true;
        }
        this.matcher.usePattern(pattern);
        int n3 = this.buffer.limit();
        this.buffer.limit(n);
        this.matcher.region(this.findStartIndex, n);
        if (this.matcher.find()) {
            this.findStartIndex = this.matcher.end();
            if (n == this.matcher.end()) {
                this.findStartIndex += n2;
            }
            this.matchSuccessful = true;
            this.buffer.limit(n3);
            return this.matcher.group();
        }
        this.buffer.limit(n3);
        this.matchSuccessful = false;
        return null;
    }

    public String findInLine(String string) {
        return this.findInLine(Pattern.compile(string));
    }

    public String findWithinHorizon(Pattern pattern, int n) {
        this.checkClosed();
        this.checkNull(pattern);
        if (n < 0) {
            throw new IllegalArgumentException(Msg.getString("KA00e"));
        }
        this.matcher.usePattern(pattern);
        String string = null;
        int n2 = 0;
        int n3 = 0;
        n3 = n == 0 ? Integer.MAX_VALUE : this.findStartIndex + n;
        while (true) {
            n2 = this.bufferLength;
            n2 = Math.min(n3, this.bufferLength);
            boolean bl = n3 <= this.bufferLength;
            this.matcher.region(this.findStartIndex, n2);
            this.matcher.useAnchoringBounds(false);
            if (this.matcher.find()) {
                if (bl || this.inputExhausted) {
                    string = this.matcher.group();
                    break;
                }
            } else if (bl || this.inputExhausted) break;
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        if (null != string) {
            this.findStartIndex = this.matcher.end();
            this.matchSuccessful = true;
        } else {
            this.matchSuccessful = false;
        }
        return string;
    }

    public String findWithinHorizon(String string, int n) {
        return this.findWithinHorizon(Pattern.compile(string), n);
    }

    @Override
    public boolean hasNext() {
        return this.hasNext(ANY_PATTERN);
    }

    public boolean hasNext(Pattern pattern) {
        this.checkClosed();
        this.checkNull(pattern);
        this.matchSuccessful = false;
        this.saveCurrentStatus();
        if (!this.setTokenRegion()) {
            this.recoverPreviousStatus();
            return false;
        }
        this.matcher.usePattern(pattern);
        boolean bl = false;
        if (this.matcher.matches()) {
            this.cachehasNextIndex = this.findStartIndex;
            this.matchSuccessful = true;
            bl = true;
        }
        this.recoverPreviousStatus();
        return bl;
    }

    public boolean hasNext(String string) {
        return this.hasNext(Pattern.compile(string));
    }

    public boolean hasNextBigDecimal() {
        Pattern pattern = this.getFloatPattern();
        boolean bl = false;
        if (this.hasNext(pattern)) {
            String string = this.matcher.group();
            string = this.removeLocaleInfoFromFloat(string);
            try {
                this.cacheHasNextValue = new BigDecimal(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.matchSuccessful = false;
            }
        }
        return bl;
    }

    public boolean hasNextBigInteger() {
        return this.hasNextBigInteger(this.integerRadix);
    }

    public boolean hasNextBigInteger(int n) {
        Pattern pattern = this.getIntegerPattern(n);
        boolean bl = false;
        if (this.hasNext(pattern)) {
            String string = this.matcher.group();
            string = this.removeLocaleInfo(string, DataType.INT);
            try {
                this.cacheHasNextValue = new BigInteger(string, n);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.matchSuccessful = false;
            }
        }
        return bl;
    }

    public boolean hasNextBoolean() {
        return this.hasNext(BOOLEAN_PATTERN);
    }

    public boolean hasNextByte() {
        return this.hasNextByte(this.integerRadix);
    }

    public boolean hasNextByte(int n) {
        Pattern pattern = this.getIntegerPattern(n);
        boolean bl = false;
        if (this.hasNext(pattern)) {
            String string = this.matcher.group();
            string = this.removeLocaleInfo(string, DataType.INT);
            try {
                this.cacheHasNextValue = Byte.valueOf(string, n);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.matchSuccessful = false;
            }
        }
        return bl;
    }

    public boolean hasNextDouble() {
        Pattern pattern = this.getFloatPattern();
        boolean bl = false;
        if (this.hasNext(pattern)) {
            String string = this.matcher.group();
            string = this.removeLocaleInfoFromFloat(string);
            try {
                this.cacheHasNextValue = Double.valueOf(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.matchSuccessful = false;
            }
        }
        return bl;
    }

    public boolean hasNextFloat() {
        Pattern pattern = this.getFloatPattern();
        boolean bl = false;
        if (this.hasNext(pattern)) {
            String string = this.matcher.group();
            string = this.removeLocaleInfoFromFloat(string);
            try {
                this.cacheHasNextValue = Float.valueOf(string);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.matchSuccessful = false;
            }
        }
        return bl;
    }

    public boolean hasNextInt() {
        return this.hasNextInt(this.integerRadix);
    }

    public boolean hasNextInt(int n) {
        Pattern pattern = this.getIntegerPattern(n);
        boolean bl = false;
        if (this.hasNext(pattern)) {
            String string = this.matcher.group();
            string = this.removeLocaleInfo(string, DataType.INT);
            try {
                this.cacheHasNextValue = Integer.valueOf(string, n);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.matchSuccessful = false;
            }
        }
        return bl;
    }

    public boolean hasNextLine() {
        this.checkClosed();
        this.matcher.usePattern(LINE_PATTERN);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        boolean bl = false;
        while (true) {
            if (this.matcher.find()) {
                if (this.inputExhausted || this.matcher.end() != this.bufferLength) {
                    this.matchSuccessful = true;
                    bl = true;
                    break;
                }
            } else if (this.inputExhausted) {
                this.matchSuccessful = false;
                break;
            }
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        return bl;
    }

    public boolean hasNextLong() {
        return this.hasNextLong(this.integerRadix);
    }

    public boolean hasNextLong(int n) {
        Pattern pattern = this.getIntegerPattern(n);
        boolean bl = false;
        if (this.hasNext(pattern)) {
            String string = this.matcher.group();
            string = this.removeLocaleInfo(string, DataType.INT);
            try {
                this.cacheHasNextValue = Long.valueOf(string, n);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.matchSuccessful = false;
            }
        }
        return bl;
    }

    public boolean hasNextShort() {
        return this.hasNextShort(this.integerRadix);
    }

    public boolean hasNextShort(int n) {
        Pattern pattern = this.getIntegerPattern(n);
        boolean bl = false;
        if (this.hasNext(pattern)) {
            String string = this.matcher.group();
            string = this.removeLocaleInfo(string, DataType.INT);
            try {
                this.cacheHasNextValue = Short.valueOf(string, n);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                this.matchSuccessful = false;
            }
        }
        return bl;
    }

    public IOException ioException() {
        return this.lastIOException;
    }

    public Locale locale() {
        return this.locale;
    }

    public MatchResult match() {
        if (!this.matchSuccessful) {
            throw new IllegalStateException();
        }
        return new MatchResult(){
            String group;
            int end;
            int start;
            int groupCount;
            int[] startGroup;
            int[] endGroup;
            String[] groups;
            {
                int n;
                this.group = Scanner.this.matcher.group();
                this.end = Scanner.this.matcher.end();
                this.start = Scanner.this.matcher.start();
                this.groupCount = Scanner.this.matcher.groupCount();
                this.startGroup = new int[this.groupCount + 1];
                this.endGroup = new int[this.groupCount + 1];
                this.groups = new String[this.groupCount + 1];
                for (n = 1; n <= this.groupCount; ++n) {
                    this.startGroup[n] = Scanner.this.matcher.start(n);
                }
                for (n = 1; n <= this.groupCount; ++n) {
                    this.endGroup[n] = Scanner.this.matcher.end(n);
                }
                for (n = 1; n <= this.groupCount; ++n) {
                    this.groups[n] = Scanner.this.matcher.group(n);
                }
            }

            @Override
            public String group() {
                return this.group;
            }

            @Override
            public int end() {
                return this.end;
            }

            @Override
            public int end(int n) {
                if (n < 0 || n > this.groupCount) {
                    throw new IndexOutOfBoundsException();
                }
                if (n == 0) {
                    return this.end;
                }
                return this.endGroup[n];
            }

            @Override
            public int start() {
                return this.start;
            }

            @Override
            public int start(int n) {
                if (n < 0 || n > this.groupCount) {
                    throw new IndexOutOfBoundsException();
                }
                if (n == 0) {
                    return this.start;
                }
                return this.startGroup[n];
            }

            @Override
            public int groupCount() {
                return this.groupCount;
            }

            @Override
            public String group(int n) {
                if (n < 0 || n > this.groupCount) {
                    throw new IndexOutOfBoundsException();
                }
                if (n == 0) {
                    return this.group;
                }
                return this.groups[n];
            }
        };
    }

    @Override
    public String next() {
        return this.next(ANY_PATTERN);
    }

    public String next(Pattern pattern) {
        this.checkClosed();
        this.checkNull(pattern);
        this.matchSuccessful = false;
        this.saveCurrentStatus();
        if (!this.setTokenRegion()) {
            this.recoverPreviousStatus();
            throw new NoSuchElementException();
        }
        this.matcher.usePattern(pattern);
        if (!this.matcher.matches()) {
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        this.matchSuccessful = true;
        return this.matcher.group();
    }

    public String next(String string) {
        return this.next(Pattern.compile(string));
    }

    public BigDecimal nextBigDecimal() {
        BigDecimal bigDecimal;
        this.checkClosed();
        Object object = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (object instanceof BigDecimal) {
            this.findStartIndex = this.cachehasNextIndex;
            return (BigDecimal)object;
        }
        Pattern pattern = this.getFloatPattern();
        String string = this.next(pattern);
        string = this.removeLocaleInfoFromFloat(string);
        try {
            bigDecimal = new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return bigDecimal;
    }

    public BigInteger nextBigInteger() {
        return this.nextBigInteger(this.integerRadix);
    }

    public BigInteger nextBigInteger(int n) {
        BigInteger bigInteger;
        this.checkClosed();
        Object object = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (object instanceof BigInteger) {
            this.findStartIndex = this.cachehasNextIndex;
            return (BigInteger)object;
        }
        Pattern pattern = this.getIntegerPattern(n);
        String string = this.next(pattern);
        string = this.removeLocaleInfo(string, DataType.INT);
        try {
            bigInteger = new BigInteger(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return bigInteger;
    }

    public boolean nextBoolean() {
        return Boolean.parseBoolean(this.next(BOOLEAN_PATTERN));
    }

    public byte nextByte() {
        return this.nextByte(this.integerRadix);
    }

    public byte nextByte(int n) {
        this.checkClosed();
        Object object = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (object instanceof Byte) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Byte)object;
        }
        Pattern pattern = this.getIntegerPattern(n);
        String string = this.next(pattern);
        string = this.removeLocaleInfo(string, DataType.INT);
        byte by = 0;
        try {
            by = Byte.parseByte(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return by;
    }

    public double nextDouble() {
        this.checkClosed();
        Object object = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (object instanceof Double) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Double)object;
        }
        Pattern pattern = this.getFloatPattern();
        String string = this.next(pattern);
        string = this.removeLocaleInfoFromFloat(string);
        double d = 0.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return d;
    }

    public float nextFloat() {
        this.checkClosed();
        Object object = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (object instanceof Float) {
            this.findStartIndex = this.cachehasNextIndex;
            return ((Float)object).floatValue();
        }
        Pattern pattern = this.getFloatPattern();
        String string = this.next(pattern);
        string = this.removeLocaleInfoFromFloat(string);
        float f = 0.0f;
        try {
            f = Float.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return f;
    }

    public int nextInt() {
        return this.nextInt(this.integerRadix);
    }

    public int nextInt(int n) {
        this.checkClosed();
        Object object = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (object instanceof Integer) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Integer)object;
        }
        Pattern pattern = this.getIntegerPattern(n);
        String string = this.next(pattern);
        string = this.removeLocaleInfo(string, DataType.INT);
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return n2;
    }

    public String nextLine() {
        Matcher matcher;
        this.checkClosed();
        this.matcher.usePattern(LINE_PATTERN);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        String string = null;
        while (true) {
            if (this.matcher.find()) {
                if (this.inputExhausted || this.matcher.end() != this.bufferLength) {
                    break;
                }
            } else if (this.inputExhausted) {
                this.matchSuccessful = false;
                throw new NoSuchElementException();
            }
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        this.matchSuccessful = true;
        this.findStartIndex = this.matcher.end();
        string = this.matcher.group();
        if (null != string && (matcher = LINE_TERMINATOR.matcher(string)).find()) {
            string = string.substring(0, matcher.start());
        }
        return string;
    }

    public long nextLong() {
        return this.nextLong(this.integerRadix);
    }

    public long nextLong(int n) {
        this.checkClosed();
        Object object = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (object instanceof Long) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Long)object;
        }
        Pattern pattern = this.getIntegerPattern(n);
        String string = this.next(pattern);
        string = this.removeLocaleInfo(string, DataType.INT);
        long l = 0L;
        try {
            l = Long.parseLong(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return l;
    }

    public short nextShort() {
        return this.nextShort(this.integerRadix);
    }

    public short nextShort(int n) {
        this.checkClosed();
        Object object = this.cacheHasNextValue;
        this.cacheHasNextValue = null;
        if (object instanceof Short) {
            this.findStartIndex = this.cachehasNextIndex;
            return (Short)object;
        }
        Pattern pattern = this.getIntegerPattern(n);
        String string = this.next(pattern);
        string = this.removeLocaleInfo(string, DataType.INT);
        short s = 0;
        try {
            s = Short.parseShort(string, n);
        }
        catch (NumberFormatException numberFormatException) {
            this.matchSuccessful = false;
            this.recoverPreviousStatus();
            throw new InputMismatchException();
        }
        return s;
    }

    public int radix() {
        return this.integerRadix;
    }

    public Scanner skip(Pattern pattern) {
        this.checkClosed();
        this.checkNull(pattern);
        this.matcher.usePattern(pattern);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        while (true) {
            if (this.matcher.lookingAt()) {
                boolean bl;
                boolean bl2 = bl = this.matcher.end() < this.bufferLength || this.matcher.end() == this.bufferLength && this.inputExhausted;
                if (bl) {
                    break;
                }
            } else if (this.inputExhausted) {
                this.matchSuccessful = false;
                throw new NoSuchElementException();
            }
            if (this.inputExhausted) continue;
            this.readMore();
            this.resetMatcher();
        }
        this.matchSuccessful = true;
        this.findStartIndex = this.matcher.end();
        return this;
    }

    public Scanner skip(String string) {
        return this.skip(Pattern.compile(string));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().toString()).append(": ").append("{(delimiter:").append(this.delimiter).append(")(findStartIndex=").append(this.findStartIndex).append(")(match succeed=").append(this.matchSuccessful).append(")(closed=").append(this.closed).append(")}");
        return ((Object)stringBuilder).toString();
    }

    public Scanner useDelimiter(Pattern pattern) {
        this.delimiter = pattern;
        return this;
    }

    public Scanner useDelimiter(String string) {
        return this.useDelimiter(Pattern.compile(string));
    }

    public Scanner useLocale(Locale locale) {
        if (null == locale) {
            throw new NullPointerException();
        }
        this.locale = locale;
        return this;
    }

    public Scanner useRadix(int n) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException(Msg.getString("KA008", n));
        }
        this.integerRadix = n;
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void initialization() {
        this.buffer = CharBuffer.allocate(1024);
        this.buffer.limit(0);
        this.matcher = this.delimiter.matcher(this.buffer);
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    private void checkNull(Pattern pattern) {
        if (null == pattern) {
            throw new NullPointerException();
        }
    }

    private void resetMatcher() {
        if (null == this.matcher) {
            this.matcher = this.delimiter.matcher(this.buffer);
        } else {
            this.matcher.reset(this.buffer);
        }
        this.matcher.region(this.findStartIndex, this.bufferLength);
    }

    private void saveCurrentStatus() {
        this.preStartIndex = this.findStartIndex;
    }

    private void recoverPreviousStatus() {
        this.findStartIndex = this.preStartIndex;
    }

    private Pattern getIntegerPattern(int n) {
        if (n < 2 || n > 36) {
            throw new IllegalArgumentException(Msg.getString("KA00e", n));
        }
        this.decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.locale);
        String string = "0123456789abcdefghijklmnopqrstuvwxyz";
        String string2 = string.substring(0, n);
        String string3 = string.substring(1, n);
        StringBuilder stringBuilder = new StringBuilder("((?i)[").append(string2).append("]|\\p{javaDigit})");
        StringBuilder stringBuilder2 = new StringBuilder("((?i)[").append(string3).append("]|([\\p{javaDigit}&&[^0]]))");
        CharSequence charSequence = this.getNumeral(stringBuilder, stringBuilder2);
        StringBuilder stringBuilder3 = new StringBuilder("(([-+]?(").append(charSequence).append(")))|(").append(this.addPositiveSign(charSequence)).append(")|(").append(this.addNegativeSign(charSequence)).append(")");
        Pattern pattern = Pattern.compile(((Object)stringBuilder3).toString());
        return pattern;
    }

    private Pattern getFloatPattern() {
        this.decimalFormat = (DecimalFormat)NumberFormat.getInstance(this.locale);
        StringBuilder stringBuilder = new StringBuilder("([0-9]|(\\p{javaDigit}))");
        StringBuilder stringBuilder2 = new StringBuilder("[\\p{javaDigit}&&[^0]]");
        CharSequence charSequence = this.getNumeral(stringBuilder, stringBuilder2);
        String string = "\\" + this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
        StringBuilder stringBuilder3 = new StringBuilder("(").append(charSequence).append("|").append(charSequence).append(string).append((CharSequence)stringBuilder).append("*+|").append(string).append((CharSequence)stringBuilder).append("++)");
        StringBuilder stringBuilder4 = new StringBuilder("([eE][+-]?").append((CharSequence)stringBuilder).append("+)?");
        StringBuilder stringBuilder5 = new StringBuilder("(([-+]?").append((CharSequence)stringBuilder3).append("(").append((CharSequence)stringBuilder4).append("?)").append(")|(").append(this.addPositiveSign(stringBuilder3)).append("(").append((CharSequence)stringBuilder4).append("?)").append(")|(").append(this.addNegativeSign(stringBuilder3)).append("(").append((CharSequence)stringBuilder4).append("?)").append("))");
        StringBuilder stringBuilder6 = new StringBuilder("([-+]?0[xX][0-9a-fA-F]*").append("\\.").append("[0-9a-fA-F]+([pP][-+]?[0-9]+)?)");
        String string2 = this.decimalFormat.getDecimalFormatSymbols().getNaN();
        String string3 = this.decimalFormat.getDecimalFormatSymbols().getInfinity();
        StringBuilder stringBuilder7 = new StringBuilder("(NaN|\\Q").append(string2).append("\\E|Infinity|\\Q").append(string3).append("\\E)");
        StringBuilder stringBuilder8 = new StringBuilder("((([-+]?(").append((CharSequence)stringBuilder7).append(")))|(").append(this.addPositiveSign(stringBuilder7)).append(")|(").append(this.addNegativeSign(stringBuilder7)).append("))");
        StringBuilder stringBuilder9 = new StringBuilder().append((CharSequence)stringBuilder5).append("|").append((CharSequence)stringBuilder6).append("|").append((CharSequence)stringBuilder8);
        Pattern pattern = Pattern.compile(((Object)stringBuilder9).toString());
        return pattern;
    }

    private CharSequence getNumeral(CharSequence charSequence, CharSequence charSequence2) {
        String string = "\\" + this.decimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
        StringBuilder stringBuilder = new StringBuilder("(").append(charSequence2).append(charSequence).append("?").append(charSequence).append("?(").append(string).append(charSequence).append(charSequence).append(charSequence).append(")+)");
        StringBuilder stringBuilder2 = new StringBuilder("((").append(charSequence).append("++)|").append((CharSequence)stringBuilder).append(")");
        return stringBuilder2;
    }

    private CharSequence addPositiveSign(CharSequence charSequence) {
        String string = "";
        String string2 = "";
        if (!this.decimalFormat.getPositivePrefix().equals("")) {
            string = "\\Q" + this.decimalFormat.getPositivePrefix() + "\\E";
        }
        if (!this.decimalFormat.getPositiveSuffix().equals("")) {
            string2 = "\\Q" + this.decimalFormat.getPositiveSuffix() + "\\E";
        }
        StringBuilder stringBuilder = new StringBuilder().append(string).append(charSequence).append(string2);
        return stringBuilder;
    }

    private CharSequence addNegativeSign(CharSequence charSequence) {
        String string = "";
        String string2 = "";
        if (!this.decimalFormat.getNegativePrefix().equals("")) {
            string = "\\Q" + this.decimalFormat.getNegativePrefix() + "\\E";
        }
        if (!this.decimalFormat.getNegativeSuffix().equals("")) {
            string2 = "\\Q" + this.decimalFormat.getNegativeSuffix() + "\\E";
        }
        StringBuilder stringBuilder = new StringBuilder().append(string).append(charSequence).append(string2);
        return stringBuilder;
    }

    private String removeLocaleInfoFromFloat(String string) {
        if (-1 != string.indexOf(120) || -1 != string.indexOf(88)) {
            return string;
        }
        int n = string.indexOf(101);
        if (-1 != n || -1 != (n = string.indexOf(69))) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            string2 = this.removeLocaleInfo(string2, DataType.FLOAT);
            return string2 + "e" + string3;
        }
        return this.removeLocaleInfo(string, DataType.FLOAT);
    }

    private String removeLocaleInfo(String string, DataType dataType) {
        int n;
        StringBuilder stringBuilder = new StringBuilder(string);
        boolean bl = this.removeLocaleSign(stringBuilder);
        String string2 = String.valueOf(this.decimalFormat.getDecimalFormatSymbols().getGroupingSeparator());
        int n2 = -1;
        while (-1 != (n2 = stringBuilder.indexOf(string2))) {
            stringBuilder.delete(n2, n2 + 1);
        }
        String string3 = String.valueOf(this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator());
        n2 = stringBuilder.indexOf(string3);
        StringBuilder stringBuilder2 = new StringBuilder("");
        if (DataType.INT == dataType) {
            for (n = 0; n < stringBuilder.length(); ++n) {
                if (-1 == Character.digit(stringBuilder.charAt(n), 36)) continue;
                stringBuilder2.append(stringBuilder.charAt(n));
            }
        }
        if (DataType.FLOAT == dataType) {
            if (stringBuilder.toString().equals(this.decimalFormat.getDecimalFormatSymbols().getNaN())) {
                stringBuilder2.append("NaN");
            } else if (stringBuilder.toString().equals(this.decimalFormat.getDecimalFormatSymbols().getInfinity())) {
                stringBuilder2.append("Infinity");
            } else {
                for (n = 0; n < stringBuilder.length(); ++n) {
                    if (-1 == Character.digit(stringBuilder.charAt(n), 10)) continue;
                    stringBuilder2.append(Character.digit(stringBuilder.charAt(n), 10));
                }
            }
        }
        if (0 == stringBuilder2.length()) {
            stringBuilder2 = stringBuilder;
        }
        if (-1 != n2) {
            stringBuilder2.insert(n2, ".");
        }
        if (bl) {
            stringBuilder2.insert(0, '-');
        }
        return stringBuilder2.toString();
    }

    private boolean removeLocaleSign(StringBuilder stringBuilder) {
        String string = this.decimalFormat.getPositivePrefix();
        String string2 = this.decimalFormat.getPositiveSuffix();
        String string3 = this.decimalFormat.getNegativePrefix();
        String string4 = this.decimalFormat.getNegativeSuffix();
        if (0 == stringBuilder.indexOf("+")) {
            stringBuilder.delete(0, 1);
        }
        if (!string.equals("") && 0 == stringBuilder.indexOf(string)) {
            stringBuilder.delete(0, string.length());
        }
        if (!string2.equals("") && -1 != stringBuilder.indexOf(string2)) {
            stringBuilder.delete(stringBuilder.length() - string2.length(), stringBuilder.length());
        }
        boolean bl = false;
        if (0 == stringBuilder.indexOf("-")) {
            stringBuilder.delete(0, 1);
            bl = true;
        }
        if (!string3.equals("") && 0 == stringBuilder.indexOf(string3)) {
            stringBuilder.delete(0, string3.length());
            bl = true;
        }
        if (!string4.equals("") && -1 != stringBuilder.indexOf(string4)) {
            stringBuilder.delete(stringBuilder.length() - string4.length(), stringBuilder.length());
            bl = true;
        }
        return bl;
    }

    private boolean setTokenRegion() {
        int n = 0;
        int n2 = 0;
        this.matcher.usePattern(this.delimiter);
        this.matcher.region(this.findStartIndex, this.bufferLength);
        n = this.findPreDelimiter();
        if (this.setHeadTokenRegion(n)) {
            return true;
        }
        n2 = this.findPostDelimiter();
        if (-1 == n2) {
            if (this.findStartIndex == this.bufferLength) {
                return false;
            }
            n2 = this.bufferLength;
            this.findStartIndex = this.bufferLength;
        }
        this.matcher.region(n, n2);
        return true;
    }

    private int findPreDelimiter() {
        boolean bl = false;
        while (!bl) {
            if (this.matcher.find()) {
                bl = true;
                if (this.matcher.start() != this.findStartIndex || this.matcher.end() != this.bufferLength || this.inputExhausted) continue;
                this.readMore();
                this.resetMatcher();
                bl = false;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            return -1;
        }
        int n = this.matcher.end();
        this.findStartIndex = this.matcher.end();
        return n;
    }

    private boolean setHeadTokenRegion(int n) {
        int n2;
        int n3;
        boolean bl = false;
        if (-1 == n && this.preStartIndex != this.bufferLength) {
            n3 = this.preStartIndex;
            n2 = this.bufferLength;
            this.findStartIndex = this.bufferLength;
            this.matcher.region(n3, n2);
            bl = true;
        }
        if (-1 != n && this.preStartIndex != this.matcher.start()) {
            n3 = this.preStartIndex;
            n2 = this.matcher.start();
            this.findStartIndex = this.matcher.start();
            this.matcher.region(n3, n2);
            bl = true;
        }
        return bl;
    }

    private int findPostDelimiter() {
        int n = 0;
        boolean bl = false;
        while (!bl) {
            if (this.matcher.find()) {
                bl = true;
                if (this.matcher.start() != this.findStartIndex || this.matcher.start() != this.matcher.end()) continue;
                bl = false;
                continue;
            }
            if (!this.inputExhausted) {
                this.readMore();
                this.resetMatcher();
                continue;
            }
            return -1;
        }
        n = this.matcher.start();
        this.findStartIndex = this.matcher.start();
        return n;
    }

    private void readMore() {
        int n = this.buffer.position();
        int n2 = this.bufferLength;
        if (this.bufferLength >= this.buffer.capacity()) {
            this.expandBuffer();
        }
        int n3 = 0;
        try {
            this.buffer.limit(this.buffer.capacity());
            this.buffer.position(n2);
            while ((n3 = this.input.read(this.buffer)) == 0) {
            }
        }
        catch (IOException iOException) {
            this.bufferLength = this.buffer.position();
            n3 = -1;
            this.lastIOException = iOException;
        }
        this.buffer.flip();
        this.buffer.position(n);
        if (-1 == n3) {
            this.inputExhausted = true;
        } else {
            this.bufferLength = n3 + this.bufferLength;
        }
    }

    private void expandBuffer() {
        int n = this.buffer.position();
        int n2 = this.buffer.capacity();
        int n3 = this.buffer.limit();
        int n4 = n2 * 2;
        char[] cArray = new char[n4];
        System.arraycopy(this.buffer.array(), 0, cArray, 0, n3);
        this.buffer = CharBuffer.wrap(cArray, 0, n4);
        this.buffer.position(n);
        this.buffer.limit(n3);
    }

    public Scanner reset() {
        this.delimiter = DEFAULT_DELIMITER;
        this.locale = Locale.getDefault();
        this.integerRadix = 10;
        return this;
    }

    static {
        String string = "\n|\r\n|\r|\u0085|\u2028|\u2029";
        LINE_TERMINATOR = Pattern.compile(string);
        StringBuilder stringBuilder = new StringBuilder("(").append(string).append(")+");
        MULTI_LINE_TERMINATOR = Pattern.compile(((Object)stringBuilder).toString());
        StringBuilder stringBuilder2 = new StringBuilder(".*(").append(string).append(")|.+(").append(string).append(")?");
        LINE_PATTERN = Pattern.compile(((Object)stringBuilder2).toString());
        ANY_PATTERN = Pattern.compile("(?s).*");
    }

    private static enum DataType {
        INT,
        FLOAT;

    }
}

