/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Observer;

public class Observable {
    List<Observer> observers = new ArrayList<Observer>();
    boolean changed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        Observable observable = this;
        synchronized (observable) {
            if (!this.observers.contains(observer)) {
                this.observers.add(observer);
            }
        }
    }

    protected void clearChanged() {
        this.changed = false;
    }

    public int countObservers() {
        return this.observers.size();
    }

    public synchronized void deleteObserver(Observer observer) {
        this.observers.remove(observer);
    }

    public synchronized void deleteObservers() {
        this.observers.clear();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public void notifyObservers() {
        this.notifyObservers(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyObservers(Object object) {
        int n = 0;
        Observer[] observerArray = null;
        Observable observable = this;
        synchronized (observable) {
            if (this.hasChanged()) {
                this.clearChanged();
                n = this.observers.size();
                observerArray = new Observer[n];
                this.observers.toArray(observerArray);
            }
        }
        if (observerArray != null) {
            for (Observable observable2 : observerArray) {
                observable2.update(this, object);
            }
        }
    }

    protected void setChanged() {
        this.changed = true;
    }
}

