/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class HashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -5024744406713321676L;
    transient HashMap<E, HashSet<E>> backingMap;

    public HashSet() {
        this(new HashMap());
    }

    public HashSet(int n) {
        this(new HashMap(n));
    }

    public HashSet(int n, float f) {
        this(new HashMap(n, f));
    }

    public HashSet(Collection<? extends E> collection) {
        this(new HashMap(collection.size() < 6 ? 11 : collection.size() * 2));
        for (E e : collection) {
            this.add(e);
        }
    }

    HashSet(HashMap<E, HashSet<E>> hashMap) {
        this.backingMap = hashMap;
    }

    @Override
    public boolean add(E e) {
        return this.backingMap.put(e, this) == null;
    }

    @Override
    public void clear() {
        this.backingMap.clear();
    }

    public Object clone() {
        try {
            HashSet hashSet = (HashSet)super.clone();
            hashSet.backingMap = (HashMap)this.backingMap.clone();
            return hashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.backingMap.containsKey(object);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.backingMap.keySet().iterator();
    }

    @Override
    public boolean remove(Object object) {
        return this.backingMap.remove(object) != null;
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.backingMap.elementData.length);
        objectOutputStream.writeFloat(this.backingMap.loadFactor);
        objectOutputStream.writeInt(this.backingMap.elementCount);
        int n = this.backingMap.elementData.length;
        while (--n >= 0) {
            HashMap.Entry entry = this.backingMap.elementData[n];
            while (entry != null) {
                objectOutputStream.writeObject(entry.key);
                entry = entry.next;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n;
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        float f = objectInputStream.readFloat();
        this.backingMap = this.createBackingMap(n2, f);
        int n3 = n = objectInputStream.readInt();
        while (--n3 >= 0) {
            Object object = objectInputStream.readObject();
            this.backingMap.put(object, this);
        }
    }

    HashMap<E, HashSet<E>> createBackingMap(int n, float f) {
        return new HashMap(n, f);
    }
}

