/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.DuplicateFormatFlagsException;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formattable;
import java.util.FormatterClosedException;
import java.util.IllegalFormatCodePointException;
import java.util.IllegalFormatConversionException;
import java.util.IllegalFormatFlagsException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Locale;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.TimeZone;
import java.util.UnknownFormatConversionException;

public final class Formatter
implements Closeable,
Flushable {
    private Appendable out;
    private Locale locale;
    private boolean closed = false;
    private IOException lastIOException;

    public Formatter() {
        this(new StringBuilder(), Locale.getDefault());
    }

    public Formatter(Appendable appendable) {
        this(appendable, Locale.getDefault());
    }

    public Formatter(Locale locale) {
        this(new StringBuilder(), locale);
    }

    public Formatter(Appendable appendable, Locale locale) {
        this.out = null == appendable ? new StringBuilder() : appendable;
        this.locale = locale;
    }

    public Formatter(String string) throws FileNotFoundException {
        this(new File(string));
    }

    public Formatter(String string, String string2) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(string), string2);
    }

    public Formatter(String string, String string2, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        this(new File(string), string2, locale);
    }

    public Formatter(File file) throws FileNotFoundException {
        this(new FileOutputStream(file));
    }

    public Formatter(File file, String string) throws FileNotFoundException, UnsupportedEncodingException {
        this(file, string, Locale.getDefault());
    }

    public Formatter(File file, String string, Locale locale) throws FileNotFoundException, UnsupportedEncodingException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, string);
            this.out = new BufferedWriter(outputStreamWriter);
        }
        catch (RuntimeException runtimeException) {
            Formatter.closeOutputStream(fileOutputStream);
            throw runtimeException;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Formatter.closeOutputStream(fileOutputStream);
            throw unsupportedEncodingException;
        }
        this.locale = locale;
    }

    public Formatter(OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, Charset.defaultCharset());
        this.out = new BufferedWriter(outputStreamWriter);
        this.locale = Locale.getDefault();
    }

    public Formatter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this(outputStream, string, Locale.getDefault());
    }

    public Formatter(OutputStream outputStream, String string, Locale locale) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.out = new BufferedWriter(outputStreamWriter);
        this.locale = locale;
    }

    public Formatter(PrintStream printStream) {
        if (null == printStream) {
            throw new NullPointerException();
        }
        this.out = printStream;
        this.locale = Locale.getDefault();
    }

    private void checkClosed() {
        if (this.closed) {
            throw new FormatterClosedException();
        }
    }

    public Locale locale() {
        this.checkClosed();
        return this.locale;
    }

    public Appendable out() {
        this.checkClosed();
        return this.out;
    }

    public String toString() {
        this.checkClosed();
        return this.out.toString();
    }

    @Override
    public void flush() {
        this.checkClosed();
        if (this.out instanceof Flushable) {
            try {
                ((Flushable)((Object)this.out)).flush();
            }
            catch (IOException iOException) {
                this.lastIOException = iOException;
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            if (this.out instanceof Closeable) {
                ((Closeable)((Object)this.out)).close();
            }
        }
        catch (IOException iOException) {
            this.lastIOException = iOException;
        }
    }

    public IOException ioException() {
        return this.lastIOException;
    }

    public Formatter format(String string, Object ... objectArray) {
        return this.format(this.locale, string, objectArray);
    }

    public Formatter format(Locale locale, String string, Object ... objectArray) {
        this.checkClosed();
        CharBuffer charBuffer = CharBuffer.wrap(string);
        ParserStateMachine parserStateMachine = new ParserStateMachine(charBuffer);
        Transformer transformer = new Transformer(this, locale);
        int n = 0;
        Object object = null;
        boolean bl = false;
        while (charBuffer.hasRemaining()) {
            String string2;
            parserStateMachine.reset();
            FormatToken formatToken = parserStateMachine.getNextFormatToken();
            String string3 = formatToken.getPlainText();
            if (formatToken.getConversionType() == '\uffff') {
                string2 = string3;
            } else {
                string3 = string3.substring(0, string3.indexOf(37));
                Object object2 = null;
                if (formatToken.requireArgument()) {
                    int n2 = formatToken.getArgIndex() == -1 ? n++ : formatToken.getArgIndex();
                    object = object2 = this.getArgument(objectArray, n2, formatToken, object, bl);
                    bl = true;
                }
                String string4 = string2 = null == (string2 = transformer.transform(formatToken, object2)) ? string3 : string3 + string2;
            }
            if (null == string2) continue;
            try {
                this.out.append(string2);
            }
            catch (IOException iOException) {
                this.lastIOException = iOException;
            }
        }
        return this;
    }

    private Object getArgument(Object[] objectArray, int n, FormatToken formatToken, Object object, boolean bl) {
        if (n == -2 && !bl) {
            throw new MissingFormatArgumentException("<");
        }
        if (null == objectArray) {
            return null;
        }
        if (n >= objectArray.length) {
            throw new MissingFormatArgumentException(formatToken.getPlainText());
        }
        if (n == -2) {
            return object;
        }
        return objectArray[n];
    }

    private static void closeOutputStream(OutputStream outputStream) {
        if (null == outputStream) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class ParserStateMachine {
        private static final char EOS = '\uffff';
        private static final int EXIT_STATE = 0;
        private static final int ENTRY_STATE = 1;
        private static final int START_CONVERSION_STATE = 2;
        private static final int FLAGS_STATE = 3;
        private static final int WIDTH_STATE = 4;
        private static final int PRECISION_STATE = 5;
        private static final int CONVERSION_TYPE_STATE = 6;
        private static final int SUFFIX_STATE = 7;
        private FormatToken token;
        private int state = 1;
        private char currentChar = '\u0000';
        private CharBuffer format = null;

        ParserStateMachine(CharBuffer charBuffer) {
            this.format = charBuffer;
        }

        void reset() {
            this.currentChar = (char)65535;
            this.state = 1;
            this.token = null;
        }

        FormatToken getNextFormatToken() {
            this.token = new FormatToken();
            this.token.setFormatStringStartIndex(this.format.position());
            while (true) {
                if (0 != this.state) {
                    this.currentChar = this.getNextFormatChar();
                    if ('\uffff' == this.currentChar && 1 != this.state) {
                        throw new UnknownFormatConversionException(this.getFormatString());
                    }
                }
                switch (this.state) {
                    case 0: {
                        this.process_EXIT_STATE();
                        return this.token;
                    }
                    case 1: {
                        this.process_ENTRY_STATE();
                        break;
                    }
                    case 2: {
                        this.process_START_CONVERSION_STATE();
                        break;
                    }
                    case 3: {
                        this.process_FlAGS_STATE();
                        break;
                    }
                    case 4: {
                        this.process_WIDTH_STATE();
                        break;
                    }
                    case 5: {
                        this.process_PRECISION_STATE();
                        break;
                    }
                    case 6: {
                        this.process_CONVERSION_TYPE_STATE();
                        break;
                    }
                    case 7: {
                        this.process_SUFFIX_STATE();
                    }
                }
            }
        }

        private char getNextFormatChar() {
            if (this.format.hasRemaining()) {
                return this.format.get();
            }
            return '\uffff';
        }

        private String getFormatString() {
            int n = this.format.position();
            this.format.rewind();
            String string = ((Object)this.format.subSequence(this.token.getFormatStringStartIndex(), n)).toString();
            this.format.position(n);
            return string;
        }

        private void process_ENTRY_STATE() {
            if ('\uffff' == this.currentChar) {
                this.state = 0;
            } else if ('%' == this.currentChar) {
                this.state = 2;
            }
        }

        private void process_START_CONVERSION_STATE() {
            if (Character.isDigit(this.currentChar)) {
                int n = this.format.position() - 1;
                int n2 = this.parseInt(this.format);
                int n3 = 0;
                if (this.format.hasRemaining()) {
                    n3 = this.format.get();
                }
                if (36 == n3) {
                    int n4 = n2;
                    if (n4 > 0) {
                        this.token.setArgIndex(n4 - 1);
                    } else if (n4 == -1) {
                        throw new MissingFormatArgumentException(this.getFormatString());
                    }
                    this.state = 3;
                } else if ('0' == this.currentChar) {
                    this.state = 3;
                    this.format.position(n);
                } else {
                    this.state = 4;
                    this.format.position(this.format.position() - 1);
                    this.token.setWidth(n2);
                }
                this.currentChar = (char)n3;
            } else if ('<' == this.currentChar) {
                this.state = 3;
                this.token.setArgIndex(-2);
            } else {
                this.state = 3;
                this.format.position(this.format.position() - 1);
            }
        }

        private void process_FlAGS_STATE() {
            if (!this.token.setFlag(this.currentChar)) {
                if (Character.isDigit(this.currentChar)) {
                    this.token.setWidth(this.parseInt(this.format));
                    this.state = 4;
                } else if ('.' == this.currentChar) {
                    this.state = 5;
                } else {
                    this.state = 6;
                    this.format.position(this.format.position() - 1);
                }
            }
        }

        private void process_WIDTH_STATE() {
            if ('.' == this.currentChar) {
                this.state = 5;
            } else {
                this.state = 6;
                this.format.position(this.format.position() - 1);
            }
        }

        private void process_PRECISION_STATE() {
            if (!Character.isDigit(this.currentChar)) {
                throw new UnknownFormatConversionException(this.getFormatString());
            }
            this.token.setPrecision(this.parseInt(this.format));
            this.state = 6;
        }

        private void process_CONVERSION_TYPE_STATE() {
            this.token.setConversionType(this.currentChar);
            this.state = 't' == this.currentChar || 'T' == this.currentChar ? 7 : 0;
        }

        private void process_SUFFIX_STATE() {
            this.token.setDateSuffix(this.currentChar);
            this.state = 0;
        }

        private void process_EXIT_STATE() {
            this.token.setPlainText(this.getFormatString());
        }

        private int parseInt(CharBuffer charBuffer) {
            int n = charBuffer.position() - 1;
            int n2 = charBuffer.limit();
            while (charBuffer.hasRemaining()) {
                if (Character.isDigit(charBuffer.get())) continue;
                n2 = charBuffer.position() - 1;
                break;
            }
            charBuffer.position(0);
            String string = ((Object)charBuffer.subSequence(n, n2)).toString();
            charBuffer.position(n2);
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
    }

    private static class DateTimeUtil {
        private Calendar calendar;
        private Locale locale;
        private StringBuilder result;
        private DateFormatSymbols dateFormatSymbols;

        DateTimeUtil(Locale locale) {
            this.locale = locale;
        }

        void transform(FormatToken formatToken, Calendar calendar, StringBuilder stringBuilder) {
            this.result = stringBuilder;
            this.calendar = calendar;
            char c = formatToken.getDateSuffix();
            switch (c) {
                case 'H': {
                    this.transform_H();
                    break;
                }
                case 'I': {
                    this.transform_I();
                    break;
                }
                case 'M': {
                    this.transform_M();
                    break;
                }
                case 'S': {
                    this.transform_S();
                    break;
                }
                case 'L': {
                    this.transform_L();
                    break;
                }
                case 'N': {
                    this.transform_N();
                    break;
                }
                case 'k': {
                    this.transform_k();
                    break;
                }
                case 'l': {
                    this.transform_l();
                    break;
                }
                case 'p': {
                    this.transform_p(true);
                    break;
                }
                case 's': {
                    this.transform_s();
                    break;
                }
                case 'z': {
                    this.transform_z();
                    break;
                }
                case 'Z': {
                    this.transform_Z();
                    break;
                }
                case 'Q': {
                    this.transform_Q();
                    break;
                }
                case 'B': {
                    this.transform_B();
                    break;
                }
                case 'b': 
                case 'h': {
                    this.transform_b();
                    break;
                }
                case 'A': {
                    this.transform_A();
                    break;
                }
                case 'a': {
                    this.transform_a();
                    break;
                }
                case 'C': {
                    this.transform_C();
                    break;
                }
                case 'Y': {
                    this.transform_Y();
                    break;
                }
                case 'y': {
                    this.transform_y();
                    break;
                }
                case 'j': {
                    this.transform_j();
                    break;
                }
                case 'm': {
                    this.transform_m();
                    break;
                }
                case 'd': {
                    this.transform_d();
                    break;
                }
                case 'e': {
                    this.transform_e();
                    break;
                }
                case 'R': {
                    this.transform_R();
                    break;
                }
                case 'T': {
                    this.transform_T();
                    break;
                }
                case 'r': {
                    this.transform_r();
                    break;
                }
                case 'D': {
                    this.transform_D();
                    break;
                }
                case 'F': {
                    this.transform_F();
                    break;
                }
                case 'c': {
                    this.transform_c();
                    break;
                }
                default: {
                    throw new UnknownFormatConversionException(String.valueOf(formatToken.getConversionType()) + formatToken.getDateSuffix());
                }
            }
        }

        private void transform_e() {
            int n = this.calendar.get(5);
            this.result.append(n);
        }

        private void transform_d() {
            int n = this.calendar.get(5);
            this.result.append(DateTimeUtil.paddingZeros(n, 2));
        }

        private void transform_m() {
            int n = this.calendar.get(2);
            this.result.append(DateTimeUtil.paddingZeros(++n, 2));
        }

        private void transform_j() {
            int n = this.calendar.get(6);
            this.result.append(DateTimeUtil.paddingZeros(n, 3));
        }

        private void transform_y() {
            int n = this.calendar.get(1);
            this.result.append(DateTimeUtil.paddingZeros(n %= 100, 2));
        }

        private void transform_Y() {
            int n = this.calendar.get(1);
            this.result.append(DateTimeUtil.paddingZeros(n, 4));
        }

        private void transform_C() {
            int n = this.calendar.get(1);
            this.result.append(DateTimeUtil.paddingZeros(n /= 100, 2));
        }

        private void transform_a() {
            int n = this.calendar.get(7);
            this.result.append(this.getDateFormatSymbols().getShortWeekdays()[n]);
        }

        private void transform_A() {
            int n = this.calendar.get(7);
            this.result.append(this.getDateFormatSymbols().getWeekdays()[n]);
        }

        private void transform_b() {
            int n = this.calendar.get(2);
            this.result.append(this.getDateFormatSymbols().getShortMonths()[n]);
        }

        private void transform_B() {
            int n = this.calendar.get(2);
            this.result.append(this.getDateFormatSymbols().getMonths()[n]);
        }

        private void transform_Q() {
            long l = this.calendar.getTimeInMillis();
            this.result.append(l);
        }

        private void transform_s() {
            long l = this.calendar.getTimeInMillis();
            this.result.append(l /= 1000L);
        }

        private void transform_Z() {
            TimeZone timeZone = this.calendar.getTimeZone();
            this.result.append(timeZone.getDisplayName(timeZone.inDaylightTime(this.calendar.getTime()), 0, this.locale));
        }

        private void transform_z() {
            int n = this.calendar.get(15);
            n /= 3600000;
            if ((n *= 100) >= 0) {
                this.result.append('+');
            }
            this.result.append(DateTimeUtil.paddingZeros(n, 4));
        }

        private void transform_p(boolean bl) {
            int n = this.calendar.get(9);
            String string = this.getDateFormatSymbols().getAmPmStrings()[n];
            if (bl) {
                string = string.toLowerCase(this.locale);
            }
            this.result.append(string);
        }

        private void transform_N() {
            long l = (long)this.calendar.get(14) * 1000000L;
            this.result.append(DateTimeUtil.paddingZeros(l, 9));
        }

        private void transform_L() {
            int n = this.calendar.get(14);
            this.result.append(DateTimeUtil.paddingZeros(n, 3));
        }

        private void transform_S() {
            int n = this.calendar.get(13);
            this.result.append(DateTimeUtil.paddingZeros(n, 2));
        }

        private void transform_M() {
            int n = this.calendar.get(12);
            this.result.append(DateTimeUtil.paddingZeros(n, 2));
        }

        private void transform_l() {
            int n = this.calendar.get(10);
            if (0 == n) {
                n = 12;
            }
            this.result.append(n);
        }

        private void transform_k() {
            int n = this.calendar.get(11);
            this.result.append(n);
        }

        private void transform_I() {
            int n = this.calendar.get(10);
            if (0 == n) {
                n = 12;
            }
            this.result.append(DateTimeUtil.paddingZeros(n, 2));
        }

        private void transform_H() {
            int n = this.calendar.get(11);
            this.result.append(DateTimeUtil.paddingZeros(n, 2));
        }

        private void transform_R() {
            this.transform_H();
            this.result.append(':');
            this.transform_M();
        }

        private void transform_T() {
            this.transform_H();
            this.result.append(':');
            this.transform_M();
            this.result.append(':');
            this.transform_S();
        }

        private void transform_r() {
            this.transform_I();
            this.result.append(':');
            this.transform_M();
            this.result.append(':');
            this.transform_S();
            this.result.append(' ');
            this.transform_p(false);
        }

        private void transform_D() {
            this.transform_m();
            this.result.append('/');
            this.transform_d();
            this.result.append('/');
            this.transform_y();
        }

        private void transform_F() {
            this.transform_Y();
            this.result.append('-');
            this.transform_m();
            this.result.append('-');
            this.transform_d();
        }

        private void transform_c() {
            this.transform_a();
            this.result.append(' ');
            this.transform_b();
            this.result.append(' ');
            this.transform_d();
            this.result.append(' ');
            this.transform_T();
            this.result.append(' ');
            this.transform_Z();
            this.result.append(' ');
            this.transform_Y();
        }

        private static String paddingZeros(long l, int n) {
            int n2 = n;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(l);
            int n3 = 0;
            if (l < 0L) {
                ++n2;
                n3 = 1;
            }
            if ((n2 -= stringBuilder.length()) > 0) {
                char[] cArray = new char[n2];
                Arrays.fill(cArray, '0');
                stringBuilder.insert(n3, cArray);
            }
            return stringBuilder.toString();
        }

        private DateFormatSymbols getDateFormatSymbols() {
            if (null == this.dateFormatSymbols) {
                this.dateFormatSymbols = new DateFormatSymbols(this.locale);
            }
            return this.dateFormatSymbols;
        }
    }

    private static class FloatUtil {
        private StringBuilder result;
        private DecimalFormat decimalFormat;
        private FormatToken formatToken;
        private Object argument;
        private char minusSign;

        FloatUtil(StringBuilder stringBuilder, FormatToken formatToken, DecimalFormat decimalFormat, Object object) {
            this.result = stringBuilder;
            this.formatToken = formatToken;
            this.decimalFormat = decimalFormat;
            this.argument = object;
            this.minusSign = decimalFormat.getDecimalFormatSymbols().getMinusSign();
        }

        void transform(FormatToken formatToken, StringBuilder stringBuilder) {
            this.result = stringBuilder;
            this.formatToken = formatToken;
            switch (this.formatToken.getConversionType()) {
                case 'E': 
                case 'e': {
                    this.transform_e();
                    break;
                }
                case 'f': {
                    this.transform_f();
                    break;
                }
                case 'G': 
                case 'g': {
                    this.transform_g();
                    break;
                }
                case 'A': 
                case 'a': {
                    this.transform_a();
                    break;
                }
                default: {
                    throw new UnknownFormatConversionException(String.valueOf(this.formatToken.getConversionType()));
                }
            }
        }

        char getMinusSign() {
            return this.minusSign;
        }

        char getAddSign() {
            return '+';
        }

        void transform_e() {
            Object object;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('0');
            if (this.formatToken.getPrecision() > 0) {
                stringBuilder.append('.');
                object = new char[this.formatToken.getPrecision()];
                Arrays.fill((char[])object, '0');
                stringBuilder.append((char[])object);
            }
            stringBuilder.append('E');
            stringBuilder.append("00");
            this.decimalFormat.applyPattern(stringBuilder.toString());
            object = this.decimalFormat.format(this.argument);
            this.result.append(((String)object).replace('E', 'e'));
            int n = this.result.indexOf("e");
            if (this.result.charAt(n + 1) != '-') {
                this.result.insert(n + 1, this.getAddSign());
            }
            if (this.formatToken.isFlagSet(2) && 0 == this.formatToken.getPrecision()) {
                n = this.result.indexOf("e");
                char c = this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
                this.result.insert(n, c);
            }
        }

        void transform_g() {
            int n = this.formatToken.getPrecision();
            n = 0 == n ? 1 : n;
            this.formatToken.setPrecision(n);
            if (0.0 == ((Number)this.argument).doubleValue()) {
                this.formatToken.setPrecision(--n);
                this.transform_f();
                return;
            }
            boolean bl = true;
            double d = ((Number)this.argument).doubleValue();
            if (Double.isInfinite(d = Math.abs(d))) {
                n = this.formatToken.getPrecision();
                this.formatToken.setPrecision(--n);
                this.transform_e();
                return;
            }
            BigDecimal bigDecimal = new BigDecimal(d, new MathContext(n));
            d = bigDecimal.doubleValue();
            long l = bigDecimal.longValue();
            if (d >= 1.0 && d < Math.pow(10.0, n)) {
                if ((double)l < Math.pow(10.0, n)) {
                    bl = false;
                    if (String.valueOf(l = Math.round(d * Math.pow(10.0, (n = (n -= String.valueOf(l).length()) < 0 ? 0 : n) + 1))).length() <= this.formatToken.getPrecision()) {
                        ++n;
                    }
                    this.formatToken.setPrecision(n);
                }
            } else {
                l = bigDecimal.movePointRight(4).longValue();
                bigDecimal.movePointLeft(4);
                if (d >= Math.pow(10.0, -4.0) && d < 1.0) {
                    bl = false;
                    n += 4 - String.valueOf(l).length();
                    l = bigDecimal.movePointRight(n + 1).longValue();
                    bigDecimal.movePointLeft(n + 1);
                    if (String.valueOf(l).length() <= this.formatToken.getPrecision()) {
                        ++n;
                    }
                    l = bigDecimal.movePointRight(n).longValue();
                    bigDecimal.movePointLeft(n);
                    if ((double)l >= Math.pow(10.0, n - 4)) {
                        this.formatToken.setPrecision(n);
                    }
                }
            }
            if (bl) {
                n = this.formatToken.getPrecision();
                this.formatToken.setPrecision(--n);
                this.transform_e();
            } else {
                this.transform_f();
            }
        }

        void transform_f() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.formatToken.isFlagSet(32)) {
                stringBuilder.append(',');
                int c = this.decimalFormat.getGroupingSize();
                if (c > 1) {
                    char[] cArray = new char[c - 1];
                    Arrays.fill(cArray, '#');
                    stringBuilder.append(cArray);
                }
            }
            stringBuilder.append(0);
            if (this.formatToken.getPrecision() > 0) {
                stringBuilder.append('.');
                char[] cArray = new char[this.formatToken.getPrecision()];
                Arrays.fill(cArray, '0');
                stringBuilder.append(cArray);
            }
            this.decimalFormat.applyPattern(stringBuilder.toString());
            this.result.append(this.decimalFormat.format(this.argument));
            if (this.formatToken.isFlagSet(2) && 0 == this.formatToken.getPrecision()) {
                char c = this.decimalFormat.getDecimalFormatSymbols().getDecimalSeparator();
                this.result.append(c);
            }
        }

        void transform_a() {
            Number number;
            char c = this.formatToken.getConversionType();
            if (this.argument instanceof Float) {
                number = (Float)this.argument;
                this.result.append(Float.toHexString(((Float)number).floatValue()));
            } else if (this.argument instanceof Double) {
                number = (Double)this.argument;
                this.result.append(Double.toHexString((Double)number));
            } else {
                throw new IllegalFormatConversionException(c, this.argument.getClass());
            }
            if (!this.formatToken.isPrecisionSet()) {
                return;
            }
            int n = this.formatToken.getPrecision();
            n = 0 == n ? 1 : n;
            int n2 = this.result.indexOf(".") + 1;
            int n3 = this.result.indexOf("p");
            int n4 = n3 - n2;
            if (n4 == n) {
                return;
            }
            if (n4 < n) {
                char[] cArray = new char[n - n4];
                Arrays.fill(cArray, '0');
                this.result.insert(n3, cArray);
                return;
            }
            this.result.delete(n2 + n, n3);
        }
    }

    private static class Transformer {
        private Formatter formatter;
        private FormatToken formatToken;
        private Object arg;
        private Locale locale;
        private static String lineSeparator;
        private NumberFormat numberFormat;
        private DecimalFormatSymbols decimalFormatSymbols;
        private DateTimeUtil dateTimeUtil;

        Transformer(Formatter formatter, Locale locale) {
            this.formatter = formatter;
            this.locale = null == locale ? Locale.US : locale;
        }

        private NumberFormat getNumberFormat() {
            if (null == this.numberFormat) {
                this.numberFormat = NumberFormat.getInstance(this.locale);
            }
            return this.numberFormat;
        }

        private DecimalFormatSymbols getDecimalFormatSymbols() {
            if (null == this.decimalFormatSymbols) {
                this.decimalFormatSymbols = new DecimalFormatSymbols(this.locale);
            }
            return this.decimalFormatSymbols;
        }

        String transform(FormatToken formatToken, Object object) {
            String string;
            this.formatToken = formatToken;
            this.arg = object;
            switch (formatToken.getConversionType()) {
                case 'B': 
                case 'b': {
                    string = this.transformFromBoolean();
                    break;
                }
                case 'H': 
                case 'h': {
                    string = this.transformFromHashCode();
                    break;
                }
                case 'S': 
                case 's': {
                    string = this.transformFromString();
                    break;
                }
                case 'C': 
                case 'c': {
                    string = this.transformFromCharacter();
                    break;
                }
                case 'X': 
                case 'd': 
                case 'o': 
                case 'x': {
                    if (null == this.arg || this.arg instanceof BigInteger) {
                        string = this.transformFromBigInteger();
                        break;
                    }
                    string = this.transformFromInteger();
                    break;
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'a': 
                case 'e': 
                case 'f': 
                case 'g': {
                    string = this.transformFromFloat();
                    break;
                }
                case '%': {
                    string = this.transformFromPercent();
                    break;
                }
                case 'n': {
                    string = this.transformFromLineSeparator();
                    break;
                }
                case 'T': 
                case 't': {
                    string = this.transformFromDateTime();
                    break;
                }
                default: {
                    throw new UnknownFormatConversionException(String.valueOf(formatToken.getConversionType()));
                }
            }
            if (Character.isUpperCase(formatToken.getConversionType()) && null != string) {
                string = string.toUpperCase(Locale.US);
            }
            return string;
        }

        private String transformFromBoolean() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (0 != n2 && 1 != n2) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (null == this.arg) {
                stringBuilder.append("false");
            } else if (this.arg instanceof Boolean) {
                stringBuilder.append(this.arg);
            } else {
                stringBuilder.append("true");
            }
            return this.padding(stringBuilder, n);
        }

        private String transformFromHashCode() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (0 != n2 && 1 != n2) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (null == this.arg) {
                stringBuilder.append("null");
            } else {
                stringBuilder.append(Integer.toHexString(this.arg.hashCode()));
            }
            return this.padding(stringBuilder, n);
        }

        private String transformFromString() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (this.arg instanceof Formattable) {
                int n3 = 0;
                if (0 != (n2 & 0xFFFFFFFE & 0xFFFFFFFD)) {
                    throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
                }
                if (this.formatToken.isFlagSet(1)) {
                    n3 |= 1;
                }
                if (this.formatToken.isFlagSet(2)) {
                    n3 |= 4;
                }
                if (Character.isUpperCase(this.formatToken.getConversionType())) {
                    n3 |= 2;
                }
                ((Formattable)this.arg).formatTo(this.formatter, n3, this.formatToken.getWidth(), this.formatToken.getPrecision());
                return null;
            }
            if (0 != n2 && 1 != n2) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            stringBuilder.append(this.arg);
            return this.padding(stringBuilder, n);
        }

        private String transformFromCharacter() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            int n2 = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (0 != n2 && 1 != n2) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if (null == this.arg) {
                stringBuilder.append("null");
            } else if (this.arg instanceof Character) {
                stringBuilder.append(this.arg);
            } else if (this.arg instanceof Byte) {
                byte by = (Byte)this.arg;
                if (!Character.isValidCodePoint(by)) {
                    throw new IllegalFormatCodePointException(by);
                }
                stringBuilder.append((char)by);
            } else if (this.arg instanceof Short) {
                short s = (Short)this.arg;
                if (!Character.isValidCodePoint(s)) {
                    throw new IllegalFormatCodePointException(s);
                }
                stringBuilder.append((char)s);
            } else if (this.arg instanceof Integer) {
                int n3 = (Integer)this.arg;
                if (!Character.isValidCodePoint(n3)) {
                    throw new IllegalFormatCodePointException(n3);
                }
                stringBuilder.append(String.valueOf(Character.toChars(n3)));
            } else {
                throw new IllegalFormatConversionException(this.formatToken.getConversionType(), this.arg.getClass());
            }
            return this.padding(stringBuilder, n);
        }

        private String transformFromPercent() {
            StringBuilder stringBuilder = new StringBuilder("%");
            int n = 0;
            int n2 = this.formatToken.getFlags();
            if (this.formatToken.isFlagSet(1) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException("-" + this.formatToken.getConversionType());
            }
            if (0 != n2 && 1 != n2) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            return this.padding(stringBuilder, n);
        }

        private String transformFromLineSeparator() {
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if (this.formatToken.isWidthSet()) {
                throw new IllegalFormatWidthException(this.formatToken.getWidth());
            }
            int n = this.formatToken.getFlags();
            if (0 != n) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (null == lineSeparator) {
                lineSeparator = AccessController.doPrivileged(new PrivilegedAction<String>(){

                    @Override
                    public String run() {
                        return System.getProperty("line.separator");
                    }
                });
            }
            return lineSeparator;
        }

        private String padding(StringBuilder stringBuilder, int n) {
            int n2 = n;
            boolean bl = this.formatToken.isFlagSet(1);
            char c = ' ';
            if (this.formatToken.isFlagSet(16)) {
                c = 'd' == this.formatToken.getConversionType() ? (char)this.getDecimalFormatSymbols().getZeroDigit() : (char)'0';
            } else {
                n2 = 0;
            }
            int n3 = this.formatToken.getWidth();
            int n4 = this.formatToken.getPrecision();
            int n5 = stringBuilder.length();
            if (n4 >= 0) {
                n5 = Math.min(n5, n4);
                stringBuilder.delete(n5, stringBuilder.length());
            }
            if (n3 > 0) {
                n3 = Math.max(stringBuilder.length(), n3);
            }
            if (n5 >= n3) {
                return stringBuilder.toString();
            }
            char[] cArray = new char[n3 - n5];
            Arrays.fill(cArray, c);
            String string = new String(cArray);
            if (bl) {
                stringBuilder.append(string);
            } else {
                stringBuilder.insert(n2, string);
            }
            return stringBuilder.toString();
        }

        private String transformFromInteger() {
            long l;
            int n = 0;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            char c = this.formatToken.getConversionType();
            if ((this.formatToken.isFlagSet(1) || this.formatToken.isFlagSet(16)) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(4) && this.formatToken.isFlagSet(8)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if (this.arg instanceof Long) {
                l = (Long)this.arg;
            } else if (this.arg instanceof Integer) {
                l = ((Integer)this.arg).longValue();
            } else if (this.arg instanceof Short) {
                l = ((Short)this.arg).longValue();
            } else if (this.arg instanceof Byte) {
                l = ((Byte)this.arg).longValue();
            } else {
                throw new IllegalFormatConversionException(this.formatToken.getConversionType(), this.arg.getClass());
            }
            if ('d' != c && (this.formatToken.isFlagSet(4) || this.formatToken.isFlagSet(8) || this.formatToken.isFlagSet(32) || this.formatToken.isFlagSet(64))) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
            }
            if (this.formatToken.isFlagSet(2)) {
                if ('d' == c) {
                    throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), this.formatToken.getConversionType());
                }
                if ('o' == c) {
                    stringBuilder.append("0");
                    ++n;
                } else {
                    stringBuilder.append("0x");
                    n += 2;
                }
            }
            if (this.formatToken.isFlagSet(1) && this.formatToken.isFlagSet(16)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (l < 0L) {
                bl = true;
            }
            if ('d' == c) {
                NumberFormat numberFormat = this.getNumberFormat();
                if (this.formatToken.isFlagSet(32)) {
                    numberFormat.setGroupingUsed(true);
                } else {
                    numberFormat.setGroupingUsed(false);
                }
                stringBuilder.append(numberFormat.format(this.arg));
            } else {
                long l2 = 255L;
                long l3 = 65535L;
                long l4 = 0xFFFFFFFFL;
                if (bl) {
                    if (this.arg instanceof Byte) {
                        l &= l2;
                    } else if (this.arg instanceof Short) {
                        l &= l3;
                    } else if (this.arg instanceof Integer) {
                        l &= l4;
                    }
                }
                if ('o' == c) {
                    stringBuilder.append(Long.toOctalString(l));
                } else {
                    stringBuilder.append(Long.toHexString(l));
                }
                bl = false;
            }
            if (!bl) {
                if (this.formatToken.isFlagSet(4)) {
                    stringBuilder.insert(0, '+');
                    ++n;
                }
                if (this.formatToken.isFlagSet(8)) {
                    stringBuilder.insert(0, ' ');
                    ++n;
                }
            }
            if (bl && this.formatToken.isFlagSet(64)) {
                stringBuilder = this.wrapParentheses(stringBuilder);
                return stringBuilder.toString();
            }
            if (bl && this.formatToken.isFlagSet(16)) {
                ++n;
            }
            return this.padding(stringBuilder, n);
        }

        private StringBuilder wrapParentheses(StringBuilder stringBuilder) {
            stringBuilder.deleteCharAt(0);
            stringBuilder.insert(0, '(');
            if (this.formatToken.isFlagSet(16)) {
                this.formatToken.setWidth(this.formatToken.getWidth() - 1);
                this.padding(stringBuilder, 1);
                stringBuilder.append(')');
            } else {
                stringBuilder.append(')');
                this.padding(stringBuilder, 0);
            }
            return stringBuilder;
        }

        private String transformFromSpecialNumber() {
            String string = null;
            if (!(this.arg instanceof Number) || this.arg instanceof BigDecimal) {
                return null;
            }
            Number number = (Number)this.arg;
            double d = number.doubleValue();
            if (Double.isNaN(d)) {
                string = "NaN";
            } else if (Double.isInfinite(d)) {
                string = d >= 0.0 ? (this.formatToken.isFlagSet(4) ? "+Infinity" : (this.formatToken.isFlagSet(8) ? " Infinity" : "Infinity")) : (this.formatToken.isFlagSet(64) ? "(Infinity)" : "-Infinity");
            }
            if (null != string) {
                this.formatToken.setPrecision(-1);
                this.formatToken.setFlags(this.formatToken.getFlags() & 0xFFFFFFEF);
                string = this.padding(new StringBuilder(string), 0);
            }
            return string;
        }

        private String transformFromNull() {
            this.formatToken.setFlags(this.formatToken.getFlags() & 0xFFFFFFEF);
            return this.padding(new StringBuilder("null"), 0);
        }

        private String transformFromBigInteger() {
            int n = 0;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder();
            BigInteger bigInteger = (BigInteger)this.arg;
            char c = this.formatToken.getConversionType();
            if ((this.formatToken.isFlagSet(1) || this.formatToken.isFlagSet(16)) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(4) && this.formatToken.isFlagSet(8)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(16) && this.formatToken.isFlagSet(1)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if ('d' != c && this.formatToken.isFlagSet(32)) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), c);
            }
            if (this.formatToken.isFlagSet(2) && 'd' == c) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), c);
            }
            if (null == bigInteger) {
                return this.transformFromNull();
            }
            boolean bl2 = bl = bigInteger.compareTo(BigInteger.ZERO) < 0;
            if ('d' == c) {
                NumberFormat numberFormat = this.getNumberFormat();
                boolean bl3 = this.formatToken.isFlagSet(32);
                numberFormat.setGroupingUsed(bl3);
                stringBuilder.append(numberFormat.format(bigInteger));
            } else if ('o' == c) {
                stringBuilder.append(bigInteger.toString(8));
            } else {
                stringBuilder.append(bigInteger.toString(16));
            }
            if (this.formatToken.isFlagSet(2)) {
                int n2 = n = bl ? 1 : 0;
                if ('o' == c) {
                    stringBuilder.insert(n, "0");
                    ++n;
                } else if ('x' == c || 'X' == c) {
                    stringBuilder.insert(n, "0x");
                    n += 2;
                }
            }
            if (!bl) {
                if (this.formatToken.isFlagSet(4)) {
                    stringBuilder.insert(0, '+');
                    ++n;
                }
                if (this.formatToken.isFlagSet(8)) {
                    stringBuilder.insert(0, ' ');
                    ++n;
                }
            }
            if (bl && this.formatToken.isFlagSet(64)) {
                stringBuilder = this.wrapParentheses(stringBuilder);
                return stringBuilder.toString();
            }
            if (bl && this.formatToken.isFlagSet(16)) {
                ++n;
            }
            return this.padding(stringBuilder, n);
        }

        private String transformFromFloat() {
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            char c = this.formatToken.getConversionType();
            if (this.formatToken.isFlagSet(17) && !this.formatToken.isWidthSet()) {
                throw new MissingFormatWidthException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(4) && this.formatToken.isFlagSet(8)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if (this.formatToken.isFlagSet(1) && this.formatToken.isFlagSet(16)) {
                throw new IllegalFormatFlagsException(this.formatToken.getStrFlags());
            }
            if ('e' == Character.toLowerCase(c) && this.formatToken.isFlagSet(32)) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), c);
            }
            if ('g' == Character.toLowerCase(c) && this.formatToken.isFlagSet(2)) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), c);
            }
            if ('a' == Character.toLowerCase(c) && (this.formatToken.isFlagSet(32) || this.formatToken.isFlagSet(64))) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), c);
            }
            if (null == this.arg) {
                return this.transformFromNull();
            }
            if (!(this.arg instanceof Float || this.arg instanceof Double || this.arg instanceof BigDecimal)) {
                throw new IllegalFormatConversionException(c, this.arg.getClass());
            }
            String string = this.transformFromSpecialNumber();
            if (null != string) {
                return string;
            }
            if ('a' != Character.toLowerCase(c)) {
                this.formatToken.setPrecision(this.formatToken.isPrecisionSet() ? this.formatToken.getPrecision() : 6);
            }
            FloatUtil floatUtil = new FloatUtil(stringBuilder, this.formatToken, (DecimalFormat)NumberFormat.getInstance(this.locale), this.arg);
            floatUtil.transform(this.formatToken, stringBuilder);
            this.formatToken.setPrecision(-1);
            if (this.getDecimalFormatSymbols().getMinusSign() == stringBuilder.charAt(0)) {
                if (this.formatToken.isFlagSet(64)) {
                    stringBuilder = this.wrapParentheses(stringBuilder);
                    return stringBuilder.toString();
                }
            } else {
                if (this.formatToken.isFlagSet(8)) {
                    stringBuilder.insert(0, ' ');
                    ++n;
                }
                if (this.formatToken.isFlagSet(4)) {
                    stringBuilder.insert(0, floatUtil.getAddSign());
                    ++n;
                }
            }
            char c2 = stringBuilder.charAt(0);
            if (this.formatToken.isFlagSet(16) && (c2 == floatUtil.getAddSign() || c2 == floatUtil.getMinusSign())) {
                n = 1;
            }
            if ('a' == Character.toLowerCase(c)) {
                n += 2;
            }
            return this.padding(stringBuilder, n);
        }

        private String transformFromDateTime() {
            Comparable<StringBuilder> comparable;
            Calendar calendar;
            int n = 0;
            char c = this.formatToken.getConversionType();
            if (this.formatToken.isPrecisionSet()) {
                throw new IllegalFormatPrecisionException(this.formatToken.getPrecision());
            }
            if (this.formatToken.isFlagSet(2)) {
                throw new FormatFlagsConversionMismatchException(this.formatToken.getStrFlags(), c);
            }
            if (this.formatToken.isFlagSet(1) && -1 == this.formatToken.getWidth()) {
                throw new MissingFormatWidthException("-" + c);
            }
            if (null == this.arg) {
                return this.transformFromNull();
            }
            if (this.arg instanceof Calendar) {
                calendar = (Calendar)this.arg;
            } else {
                comparable = null;
                if (this.arg instanceof Long) {
                    comparable = new Date((Long)this.arg);
                } else if (this.arg instanceof Date) {
                    comparable = (Date)this.arg;
                } else {
                    throw new IllegalFormatConversionException(c, this.arg.getClass());
                }
                calendar = Calendar.getInstance(this.locale);
                calendar.setTime((Date)comparable);
            }
            if (null == this.dateTimeUtil) {
                this.dateTimeUtil = new DateTimeUtil(this.locale);
            }
            comparable = new StringBuilder();
            this.dateTimeUtil.transform(this.formatToken, calendar, (StringBuilder)comparable);
            return this.padding((StringBuilder)comparable, n);
        }
    }

    private static class FormatToken {
        static final int LAST_ARGUMENT_INDEX = -2;
        static final int UNSET = -1;
        static final int FLAGS_UNSET = 0;
        static final int DEFAULT_PRECISION = 6;
        static final int FLAG_MINUS = 1;
        static final int FLAG_SHARP = 2;
        static final int FLAG_ADD = 4;
        static final int FLAG_SPACE = 8;
        static final int FLAG_ZERO = 16;
        static final int FLAG_COMMA = 32;
        static final int FLAG_PARENTHESIS = 64;
        private static final int FLAGT_TYPE_COUNT = 6;
        private int formatStringStartIndex;
        private String plainText;
        private int argIndex = -1;
        private int flags = 0;
        private int width = -1;
        private int precision = -1;
        private StringBuilder strFlags = new StringBuilder(6);
        private char dateSuffix;
        private char conversionType = (char)65535;

        private FormatToken() {
        }

        boolean isPrecisionSet() {
            return this.precision != -1;
        }

        boolean isWidthSet() {
            return this.width != -1;
        }

        boolean isFlagSet(int n) {
            return 0 != (this.flags & n);
        }

        int getArgIndex() {
            return this.argIndex;
        }

        void setArgIndex(int n) {
            this.argIndex = n;
        }

        String getPlainText() {
            return this.plainText;
        }

        void setPlainText(String string) {
            this.plainText = string;
        }

        int getWidth() {
            return this.width;
        }

        void setWidth(int n) {
            this.width = n;
        }

        int getPrecision() {
            return this.precision;
        }

        void setPrecision(int n) {
            this.precision = n;
        }

        String getStrFlags() {
            return this.strFlags.toString();
        }

        int getFlags() {
            return this.flags;
        }

        void setFlags(int n) {
            this.flags = n;
        }

        boolean setFlag(char c) {
            int n;
            switch (c) {
                case '-': {
                    n = 1;
                    break;
                }
                case '#': {
                    n = 2;
                    break;
                }
                case '+': {
                    n = 4;
                    break;
                }
                case ' ': {
                    n = 8;
                    break;
                }
                case '0': {
                    n = 16;
                    break;
                }
                case ',': {
                    n = 32;
                    break;
                }
                case '(': {
                    n = 64;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (0 != (this.flags & n)) {
                throw new DuplicateFormatFlagsException(String.valueOf(c));
            }
            this.flags |= n;
            this.strFlags.append(c);
            return true;
        }

        int getFormatStringStartIndex() {
            return this.formatStringStartIndex;
        }

        void setFormatStringStartIndex(int n) {
            this.formatStringStartIndex = n;
        }

        char getConversionType() {
            return this.conversionType;
        }

        void setConversionType(char c) {
            this.conversionType = c;
        }

        char getDateSuffix() {
            return this.dateSuffix;
        }

        void setDateSuffix(char c) {
            this.dateSuffix = c;
        }

        boolean requireArgument() {
            return this.conversionType != '%' && this.conversionType != 'n';
        }
    }

    public static enum BigDecimalLayoutForm {
        SCIENTIFIC,
        DECIMAL_FLOAT;

    }
}

