/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public class Arrays {
    private static final int SIMPLE_LENGTH = 7;

    private Arrays() {
    }

    public static <T> List<T> asList(T ... TArray) {
        return new ArrayList<T>(TArray);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        return Arrays.binarySearch(byArray, 0, byArray.length, by);
    }

    public static int binarySearch(char[] cArray, char c) {
        return Arrays.binarySearch(cArray, 0, cArray.length, c);
    }

    public static int binarySearch(double[] dArray, double d) {
        return Arrays.binarySearch(dArray, 0, dArray.length, d);
    }

    public static int binarySearch(float[] fArray, float f) {
        return Arrays.binarySearch(fArray, 0, fArray.length, f);
    }

    public static int binarySearch(int[] nArray, int n) {
        return Arrays.binarySearch(nArray, 0, nArray.length, n);
    }

    public static int binarySearch(long[] lArray, long l) {
        return Arrays.binarySearch(lArray, 0, lArray.length, l);
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        return Arrays.binarySearch(objectArray, 0, objectArray.length, object);
    }

    public static <T> int binarySearch(T[] TArray, T t, Comparator<? super T> comparator) {
        return Arrays.binarySearch(TArray, 0, TArray.length, t, comparator);
    }

    public static int binarySearch(short[] sArray, short s) {
        return Arrays.binarySearch(sArray, 0, sArray.length, s);
    }

    public static int binarySearch(byte[] byArray, int n, int n2, byte by) {
        Arrays.checkIndexForBinarySearch(byArray.length, n, n2);
        int n3 = n;
        int n4 = -1;
        int n5 = n2 - 1;
        while (n3 <= n5) {
            n4 = n3 + n5 >>> 1;
            if (by > byArray[n4]) {
                n3 = n4 + 1;
                continue;
            }
            if (by == byArray[n4]) {
                return n4;
            }
            n5 = n4 - 1;
        }
        if (n4 < 0) {
            return -1;
        }
        return -n4 - (by < byArray[n4] ? 1 : 2);
    }

    public static int binarySearch(char[] cArray, int n, int n2, char c) {
        Arrays.checkIndexForBinarySearch(cArray.length, n, n2);
        int n3 = n;
        int n4 = -1;
        int n5 = n2 - 1;
        while (n3 <= n5) {
            n4 = n3 + n5 >>> 1;
            if (c > cArray[n4]) {
                n3 = n4 + 1;
                continue;
            }
            if (c == cArray[n4]) {
                return n4;
            }
            n5 = n4 - 1;
        }
        if (n4 < 0) {
            return -1;
        }
        return -n4 - (c < cArray[n4] ? 1 : 2);
    }

    public static int binarySearch(double[] dArray, int n, int n2, double d) {
        Arrays.checkIndexForBinarySearch(dArray.length, n, n2);
        long l = Double.doubleToLongBits(d);
        int n3 = n;
        int n4 = -1;
        int n5 = n2 - 1;
        while (n3 <= n5) {
            n4 = n3 + n5 >>> 1;
            if (Arrays.lessThan(dArray[n4], d)) {
                n3 = n4 + 1;
                continue;
            }
            if (l == Double.doubleToLongBits(dArray[n4])) {
                return n4;
            }
            n5 = n4 - 1;
        }
        if (n4 < 0) {
            return -1;
        }
        return -n4 - (Arrays.lessThan(d, dArray[n4]) ? 1 : 2);
    }

    public static int binarySearch(float[] fArray, int n, int n2, float f) {
        Arrays.checkIndexForBinarySearch(fArray.length, n, n2);
        int n3 = Float.floatToIntBits(f);
        int n4 = n;
        int n5 = -1;
        int n6 = n2 - 1;
        while (n4 <= n6) {
            n5 = n4 + n6 >>> 1;
            if (Arrays.lessThan(fArray[n5], f)) {
                n4 = n5 + 1;
                continue;
            }
            if (n3 == Float.floatToIntBits(fArray[n5])) {
                return n5;
            }
            n6 = n5 - 1;
        }
        if (n5 < 0) {
            return -1;
        }
        return -n5 - (Arrays.lessThan(f, fArray[n5]) ? 1 : 2);
    }

    public static int binarySearch(int[] nArray, int n, int n2, int n3) {
        Arrays.checkIndexForBinarySearch(nArray.length, n, n2);
        int n4 = n;
        int n5 = -1;
        int n6 = n2 - 1;
        while (n4 <= n6) {
            n5 = n4 + n6 >>> 1;
            if (n3 > nArray[n5]) {
                n4 = n5 + 1;
                continue;
            }
            if (n3 == nArray[n5]) {
                return n5;
            }
            n6 = n5 - 1;
        }
        if (n5 < 0) {
            return -1;
        }
        return -n5 - (n3 < nArray[n5] ? 1 : 2);
    }

    public static int binarySearch(long[] lArray, int n, int n2, long l) {
        Arrays.checkIndexForBinarySearch(lArray.length, n, n2);
        int n3 = n;
        int n4 = -1;
        int n5 = n2 - 1;
        while (n3 <= n5) {
            n4 = n3 + n5 >>> 1;
            if (l > lArray[n4]) {
                n3 = n4 + 1;
                continue;
            }
            if (l == lArray[n4]) {
                return n4;
            }
            n5 = n4 - 1;
        }
        if (n4 < 0) {
            return -1;
        }
        return -n4 - (l < lArray[n4] ? 1 : 2);
    }

    public static int binarySearch(Object[] objectArray, int n, int n2, Object object) {
        Arrays.checkIndexForBinarySearch(objectArray.length, n, n2);
        if (objectArray.length == 0) {
            return -1;
        }
        int n3 = n;
        int n4 = 0;
        int n5 = n2 - 1;
        int n6 = 0;
        while (n3 <= n5) {
            n4 = n3 + n5 >>> 1;
            n6 = ((Comparable)objectArray[n4]).compareTo(object);
            if (n6 < 0) {
                n3 = n4 + 1;
                continue;
            }
            if (n6 == 0) {
                return n4;
            }
            n5 = n4 - 1;
        }
        return -n4 - (n6 >= 0 ? 1 : 2);
    }

    public static <T> int binarySearch(T[] TArray, int n, int n2, T t, Comparator<? super T> comparator) {
        Arrays.checkIndexForBinarySearch(TArray.length, n, n2);
        if (comparator == null) {
            return Arrays.binarySearch(TArray, n, n2, t);
        }
        int n3 = n;
        int n4 = 0;
        int n5 = n2 - 1;
        int n6 = 0;
        while (n3 <= n5) {
            n4 = n3 + n5 >>> 1;
            n6 = comparator.compare(TArray[n4], t);
            if (n6 < 0) {
                n3 = n4 + 1;
                continue;
            }
            if (n6 == 0) {
                return n4;
            }
            n5 = n4 - 1;
        }
        return -n4 - (n6 >= 0 ? 1 : 2);
    }

    public static int binarySearch(short[] sArray, int n, int n2, short s) {
        Arrays.checkIndexForBinarySearch(sArray.length, n, n2);
        int n3 = n;
        int n4 = -1;
        int n5 = n2 - 1;
        while (n3 <= n5) {
            n4 = n3 + n5 >>> 1;
            if (s > sArray[n4]) {
                n3 = n4 + 1;
                continue;
            }
            if (s == sArray[n4]) {
                return n4;
            }
            n5 = n4 - 1;
        }
        if (n4 < 0) {
            return -1;
        }
        return -n4 - (s < sArray[n4] ? 1 : 2);
    }

    private static void checkIndexForBinarySearch(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException();
        }
        if (n < n3 || 0 > n2) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public static void fill(byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        int n3 = byArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(short[] sArray, short s) {
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        int n3 = sArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(char[] cArray, char c) {
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = c;
        }
    }

    public static void fill(char[] cArray, int n, int n2, char c) {
        int n3 = cArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            cArray[i] = c;
        }
    }

    public static void fill(int[] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n;
        }
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n4) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            nArray[i] = n3;
        }
    }

    public static void fill(long[] lArray, long l) {
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        int n3 = lArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(float[] fArray, float f) {
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f;
        }
    }

    public static void fill(float[] fArray, int n, int n2, float f) {
        int n3 = fArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            fArray[i] = f;
        }
    }

    public static void fill(double[] dArray, double d) {
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(double[] dArray, int n, int n2, double d) {
        int n3 = dArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(boolean[] blArray, boolean bl) {
        for (int i = 0; i < blArray.length; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(boolean[] blArray, int n, int n2, boolean bl) {
        int n3 = blArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = object;
        }
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        int n3 = objectArray.length;
        if (n > n2) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n2 > n3) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = n; i < n2; ++i) {
            objectArray[i] = object;
        }
    }

    public static int hashCode(boolean[] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n = 1;
        for (boolean bl : blArray) {
            n = 31 * n + (bl ? 1231 : 1237);
        }
        return n;
    }

    public static int hashCode(int[] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 1;
        for (int n2 : nArray) {
            n = 31 * n + n2;
        }
        return n;
    }

    public static int hashCode(short[] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = 1;
        for (short s : sArray) {
            n = 31 * n + s;
        }
        return n;
    }

    public static int hashCode(char[] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 1;
        for (char c : cArray) {
            n = 31 * n + c;
        }
        return n;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        for (byte by : byArray) {
            n = 31 * n + by;
        }
        return n;
    }

    public static int hashCode(long[] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n = 1;
        for (long l : lArray) {
            n = 31 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public static int hashCode(float[] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 1;
        for (float f : fArray) {
            n = 31 * n + Float.floatToIntBits(f);
        }
        return n;
    }

    public static int hashCode(double[] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 1;
        for (double d : dArray) {
            long l = Double.doubleToLongBits(d);
            n = 31 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    public static int hashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            int n2 = object == null ? 0 : object.hashCode();
            n = 31 * n + n2;
        }
        return n;
    }

    public static int deepHashCode(Object[] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            int n2 = Arrays.deepHashCodeElement(object);
            n = 31 * n + n2;
        }
        return n;
    }

    private static int deepHashCodeElement(Object object) {
        if (object == null) {
            return 0;
        }
        Class<?> clazz = object.getClass().getComponentType();
        if (clazz == null) {
            return object.hashCode();
        }
        if (!clazz.isPrimitive()) {
            return Arrays.deepHashCode((Object[])object);
        }
        if (clazz.equals(Integer.TYPE)) {
            return Arrays.hashCode((int[])object);
        }
        if (clazz.equals(Character.TYPE)) {
            return Arrays.hashCode((char[])object);
        }
        if (clazz.equals(Boolean.TYPE)) {
            return Arrays.hashCode((boolean[])object);
        }
        if (clazz.equals(Byte.TYPE)) {
            return Arrays.hashCode((byte[])object);
        }
        if (clazz.equals(Long.TYPE)) {
            return Arrays.hashCode((long[])object);
        }
        if (clazz.equals(Float.TYPE)) {
            return Arrays.hashCode((float[])object);
        }
        if (clazz.equals(Double.TYPE)) {
            return Arrays.hashCode((double[])object);
        }
        return Arrays.hashCode((short[])object);
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null || byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (sArray == null || sArray2 == null || sArray.length != sArray2.length) {
            return false;
        }
        for (int i = 0; i < sArray.length; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null || cArray.length != cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null || nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null || lArray.length != lArray2.length) {
            return false;
        }
        for (int i = 0; i < lArray.length; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null || fArray2 == null || fArray.length != fArray2.length) {
            return false;
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (Float.floatToIntBits(fArray[i]) == Float.floatToIntBits(fArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null || dArray.length != dArray2.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.doubleToLongBits(dArray[i]) == Double.doubleToLongBits(dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null || blArray.length != blArray2.length) {
            return false;
        }
        for (int i = 0; i < blArray.length; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null || objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object != null ? object.equals(object2) : object2 == null) continue;
            return false;
        }
        return true;
    }

    public static boolean deepEquals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null || objectArray.length != objectArray2.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (Arrays.deepEqualsElements(object, object2)) continue;
            return false;
        }
        return true;
    }

    private static boolean deepEqualsElements(Object object, Object object2) {
        Class<?> clazz;
        if (object == object2) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        Class<?> clazz2 = object.getClass().getComponentType();
        if (clazz2 != (clazz = object2.getClass().getComponentType())) {
            return false;
        }
        if (clazz2 == null) {
            return object.equals(object2);
        }
        if (!clazz2.isPrimitive()) {
            return Arrays.deepEquals((Object[])object, (Object[])object2);
        }
        if (clazz2.equals(Integer.TYPE)) {
            return Arrays.equals((int[])object, (int[])object2);
        }
        if (clazz2.equals(Character.TYPE)) {
            return Arrays.equals((char[])object, (char[])object2);
        }
        if (clazz2.equals(Boolean.TYPE)) {
            return Arrays.equals((boolean[])object, (boolean[])object2);
        }
        if (clazz2.equals(Byte.TYPE)) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
        if (clazz2.equals(Long.TYPE)) {
            return Arrays.equals((long[])object, (long[])object2);
        }
        if (clazz2.equals(Float.TYPE)) {
            return Arrays.equals((float[])object, (float[])object2);
        }
        if (clazz2.equals(Double.TYPE)) {
            return Arrays.equals((double[])object, (double[])object2);
        }
        return Arrays.equals((short[])object, (short[])object2);
    }

    private static boolean lessThan(double d, double d2) {
        long l = Double.doubleToLongBits(Double.NaN);
        long l2 = Double.doubleToLongBits(d);
        if (l2 == l) {
            return false;
        }
        long l3 = Double.doubleToLongBits(d2);
        if (l3 == l) {
            return true;
        }
        if (d == d2) {
            if (l2 == l3) {
                return false;
            }
            return l2 < l3;
        }
        return d < d2;
    }

    private static boolean lessThan(float f, float f2) {
        int n = Float.floatToIntBits(Float.NaN);
        int n2 = Float.floatToIntBits(f);
        if (n2 == n) {
            return false;
        }
        int n3 = Float.floatToIntBits(f2);
        if (n3 == n) {
            return true;
        }
        if (f == f2) {
            if (n2 == n3) {
                return false;
            }
            return n2 < n3;
        }
        return f < f2;
    }

    private static int med3(byte[] byArray, int n, int n2, int n3) {
        byte by = byArray[n];
        byte by2 = byArray[n2];
        byte by3 = byArray[n3];
        return by < by2 ? (by2 < by3 ? n2 : (by < by3 ? n3 : n)) : (by2 > by3 ? n2 : (by > by3 ? n3 : n));
    }

    private static int med3(char[] cArray, int n, int n2, int n3) {
        char c = cArray[n];
        char c2 = cArray[n2];
        char c3 = cArray[n3];
        return c < c2 ? (c2 < c3 ? n2 : (c < c3 ? n3 : n)) : (c2 > c3 ? n2 : (c > c3 ? n3 : n));
    }

    private static int med3(double[] dArray, int n, int n2, int n3) {
        double d = dArray[n];
        double d2 = dArray[n2];
        double d3 = dArray[n3];
        return Arrays.lessThan(d, d2) ? (Arrays.lessThan(d2, d3) ? n2 : (Arrays.lessThan(d, d3) ? n3 : n)) : (Arrays.lessThan(d3, d2) ? n2 : (Arrays.lessThan(d3, d) ? n3 : n));
    }

    private static int med3(float[] fArray, int n, int n2, int n3) {
        float f = fArray[n];
        float f2 = fArray[n2];
        float f3 = fArray[n3];
        return Arrays.lessThan(f, f2) ? (Arrays.lessThan(f2, f3) ? n2 : (Arrays.lessThan(f, f3) ? n3 : n)) : (Arrays.lessThan(f3, f2) ? n2 : (Arrays.lessThan(f3, f) ? n3 : n));
    }

    private static int med3(int[] nArray, int n, int n2, int n3) {
        int n4 = nArray[n];
        int n5 = nArray[n2];
        int n6 = nArray[n3];
        return n4 < n5 ? (n5 < n6 ? n2 : (n4 < n6 ? n3 : n)) : (n5 > n6 ? n2 : (n4 > n6 ? n3 : n));
    }

    private static int med3(long[] lArray, int n, int n2, int n3) {
        long l = lArray[n];
        long l2 = lArray[n2];
        long l3 = lArray[n3];
        return l < l2 ? (l2 < l3 ? n2 : (l < l3 ? n3 : n)) : (l2 > l3 ? n2 : (l > l3 ? n3 : n));
    }

    private static int med3(short[] sArray, int n, int n2, int n3) {
        short s = sArray[n];
        short s2 = sArray[n2];
        short s3 = sArray[n3];
        return s < s2 ? (s2 < s3 ? n2 : (s < s3 ? n3 : n)) : (s2 > s3 ? n2 : (s > s3 ? n3 : n));
    }

    public static void sort(byte[] byArray) {
        Arrays.sort(0, byArray.length, byArray);
    }

    public static void sort(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(byArray.length, n, n2);
        Arrays.sort(n, n2, byArray);
    }

    private static void checkBounds(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("start(" + n2 + ") > end(" + n3 + ")");
        }
        if (n2 < 0 || n3 > n) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    private static void sort(int n, int n2, byte[] byArray) {
        byte by;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n2 - n;
        if (n7 < 7) {
            for (int i = n + 1; i < n2; ++i) {
                for (int j = i; j > n && byArray[j - 1] > byArray[j]; --j) {
                    byte by2 = byArray[j];
                    byArray[j] = byArray[j - 1];
                    byArray[j - 1] = by2;
                }
            }
            return;
        }
        int n8 = (n + n2) / 2;
        if (n7 > 7) {
            n6 = n;
            n5 = n2 - 1;
            if (n7 > 40) {
                n6 = Arrays.med3(byArray, n6, n6 + (n7 /= 8), n6 + 2 * n7);
                n8 = Arrays.med3(byArray, n8 - n7, n8, n8 + n7);
                n5 = Arrays.med3(byArray, n5 - 2 * n7, n5 - n7, n5);
            }
            n8 = Arrays.med3(byArray, n6, n8, n5);
        }
        n6 = byArray[n8];
        n5 = n4 = n;
        int n9 = n3 = n2 - 1;
        while (true) {
            if (n4 <= n9 && byArray[n4] <= n6) {
                if (byArray[n4] == n6) {
                    by = byArray[n5];
                    byArray[n5++] = byArray[n4];
                    byArray[n4] = by;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && byArray[n9] >= n6) {
                if (byArray[n9] == n6) {
                    by = byArray[n9];
                    byArray[n9] = byArray[n3];
                    byArray[n3--] = by;
                }
                --n9;
            }
            if (n4 > n9) break;
            by = byArray[n4];
            byArray[n4++] = byArray[n9];
            byArray[n9--] = by;
        }
        n7 = n5 - n < n4 - n5 ? n5 - n : n4 - n5;
        int n10 = n;
        int n11 = n4 - n7;
        while (n7-- > 0) {
            by = byArray[n10];
            byArray[n10++] = byArray[n11];
            byArray[n11++] = by;
        }
        n7 = n3 - n9 < n2 - 1 - n3 ? n3 - n9 : n2 - 1 - n3;
        n10 = n4;
        n11 = n2 - n7;
        while (n7-- > 0) {
            by = byArray[n10];
            byArray[n10++] = byArray[n11];
            byArray[n11++] = by;
        }
        n7 = n4 - n5;
        if (n7 > 0) {
            Arrays.sort(n, n + n7, byArray);
        }
        if ((n7 = n3 - n9) > 0) {
            Arrays.sort(n2 - n7, n2, byArray);
        }
    }

    public static void sort(char[] cArray) {
        Arrays.sort(0, cArray.length, cArray);
    }

    public static void sort(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(cArray.length, n, n2);
        Arrays.sort(n, n2, cArray);
    }

    private static void sort(int n, int n2, char[] cArray) {
        char c;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n2 - n;
        if (n7 < 7) {
            for (int i = n + 1; i < n2; ++i) {
                for (int j = i; j > n && cArray[j - 1] > cArray[j]; --j) {
                    char c2 = cArray[j];
                    cArray[j] = cArray[j - 1];
                    cArray[j - 1] = c2;
                }
            }
            return;
        }
        int n8 = (n + n2) / 2;
        if (n7 > 7) {
            n6 = n;
            n5 = n2 - 1;
            if (n7 > 40) {
                n6 = Arrays.med3(cArray, n6, n6 + (n7 /= 8), n6 + 2 * n7);
                n8 = Arrays.med3(cArray, n8 - n7, n8, n8 + n7);
                n5 = Arrays.med3(cArray, n5 - 2 * n7, n5 - n7, n5);
            }
            n8 = Arrays.med3(cArray, n6, n8, n5);
        }
        n6 = cArray[n8];
        n5 = n4 = n;
        int n9 = n3 = n2 - 1;
        while (true) {
            if (n4 <= n9 && cArray[n4] <= n6) {
                if (cArray[n4] == n6) {
                    c = cArray[n5];
                    cArray[n5++] = cArray[n4];
                    cArray[n4] = c;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && cArray[n9] >= n6) {
                if (cArray[n9] == n6) {
                    c = cArray[n9];
                    cArray[n9] = cArray[n3];
                    cArray[n3--] = c;
                }
                --n9;
            }
            if (n4 > n9) break;
            c = cArray[n4];
            cArray[n4++] = cArray[n9];
            cArray[n9--] = c;
        }
        n7 = n5 - n < n4 - n5 ? n5 - n : n4 - n5;
        int n10 = n;
        int n11 = n4 - n7;
        while (n7-- > 0) {
            c = cArray[n10];
            cArray[n10++] = cArray[n11];
            cArray[n11++] = c;
        }
        n7 = n3 - n9 < n2 - 1 - n3 ? n3 - n9 : n2 - 1 - n3;
        n10 = n4;
        n11 = n2 - n7;
        while (n7-- > 0) {
            c = cArray[n10];
            cArray[n10++] = cArray[n11];
            cArray[n11++] = c;
        }
        n7 = n4 - n5;
        if (n7 > 0) {
            Arrays.sort(n, n + n7, cArray);
        }
        if ((n7 = n3 - n9) > 0) {
            Arrays.sort(n2 - n7, n2, cArray);
        }
    }

    public static void sort(double[] dArray) {
        Arrays.sort(0, dArray.length, dArray);
    }

    public static void sort(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(dArray.length, n, n2);
        Arrays.sort(n, n2, dArray);
    }

    private static void sort(int n, int n2, double[] dArray) {
        double d;
        int n3;
        int n4;
        int n5 = n2 - n;
        if (n5 < 7) {
            for (int i = n + 1; i < n2; ++i) {
                for (int j = i; j > n && Arrays.lessThan(dArray[j], dArray[j - 1]); --j) {
                    double d2 = dArray[j];
                    dArray[j] = dArray[j - 1];
                    dArray[j - 1] = d2;
                }
            }
            return;
        }
        int n6 = (n + n2) / 2;
        if (n5 > 7) {
            int n7 = n;
            int n8 = n2 - 1;
            if (n5 > 40) {
                n7 = Arrays.med3(dArray, n7, n7 + (n5 /= 8), n7 + 2 * n5);
                n6 = Arrays.med3(dArray, n6 - n5, n6, n6 + n5);
                n8 = Arrays.med3(dArray, n8 - 2 * n5, n8 - n5, n8);
            }
            n6 = Arrays.med3(dArray, n7, n6, n8);
        }
        double d3 = dArray[n6];
        int n9 = n4 = n;
        int n10 = n3 = n2 - 1;
        while (true) {
            if (n4 <= n10 && !Arrays.lessThan(d3, dArray[n4])) {
                if (dArray[n4] == d3) {
                    d = dArray[n9];
                    dArray[n9++] = dArray[n4];
                    dArray[n4] = d;
                }
                ++n4;
                continue;
            }
            while (n10 >= n4 && !Arrays.lessThan(dArray[n10], d3)) {
                if (dArray[n10] == d3) {
                    d = dArray[n10];
                    dArray[n10] = dArray[n3];
                    dArray[n3--] = d;
                }
                --n10;
            }
            if (n4 > n10) break;
            d = dArray[n4];
            dArray[n4++] = dArray[n10];
            dArray[n10--] = d;
        }
        n5 = n9 - n < n4 - n9 ? n9 - n : n4 - n9;
        int n11 = n;
        int n12 = n4 - n5;
        while (n5-- > 0) {
            d = dArray[n11];
            dArray[n11++] = dArray[n12];
            dArray[n12++] = d;
        }
        n5 = n3 - n10 < n2 - 1 - n3 ? n3 - n10 : n2 - 1 - n3;
        n11 = n4;
        n12 = n2 - n5;
        while (n5-- > 0) {
            d = dArray[n11];
            dArray[n11++] = dArray[n12];
            dArray[n12++] = d;
        }
        n5 = n4 - n9;
        if (n5 > 0) {
            Arrays.sort(n, n + n5, dArray);
        }
        if ((n5 = n3 - n10) > 0) {
            Arrays.sort(n2 - n5, n2, dArray);
        }
    }

    public static void sort(float[] fArray) {
        Arrays.sort(0, fArray.length, fArray);
    }

    public static void sort(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(fArray.length, n, n2);
        Arrays.sort(n, n2, fArray);
    }

    private static void sort(int n, int n2, float[] fArray) {
        float f;
        int n3;
        int n4;
        int n5;
        int n6 = n2 - n;
        if (n6 < 7) {
            for (int i = n + 1; i < n2; ++i) {
                for (int j = i; j > n && Arrays.lessThan(fArray[j], fArray[j - 1]); --j) {
                    float f2 = fArray[j];
                    fArray[j] = fArray[j - 1];
                    fArray[j - 1] = f2;
                }
            }
            return;
        }
        int n7 = (n + n2) / 2;
        if (n6 > 7) {
            int n8 = n;
            n5 = n2 - 1;
            if (n6 > 40) {
                n8 = Arrays.med3(fArray, n8, n8 + (n6 /= 8), n8 + 2 * n6);
                n7 = Arrays.med3(fArray, n7 - n6, n7, n7 + n6);
                n5 = Arrays.med3(fArray, n5 - 2 * n6, n5 - n6, n5);
            }
            n7 = Arrays.med3(fArray, n8, n7, n5);
        }
        float f3 = fArray[n7];
        n5 = n4 = n;
        int n9 = n3 = n2 - 1;
        while (true) {
            if (n4 <= n9 && !Arrays.lessThan(f3, fArray[n4])) {
                if (fArray[n4] == f3) {
                    f = fArray[n5];
                    fArray[n5++] = fArray[n4];
                    fArray[n4] = f;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && !Arrays.lessThan(fArray[n9], f3)) {
                if (fArray[n9] == f3) {
                    f = fArray[n9];
                    fArray[n9] = fArray[n3];
                    fArray[n3--] = f;
                }
                --n9;
            }
            if (n4 > n9) break;
            f = fArray[n4];
            fArray[n4++] = fArray[n9];
            fArray[n9--] = f;
        }
        n6 = n5 - n < n4 - n5 ? n5 - n : n4 - n5;
        int n10 = n;
        int n11 = n4 - n6;
        while (n6-- > 0) {
            f = fArray[n10];
            fArray[n10++] = fArray[n11];
            fArray[n11++] = f;
        }
        n6 = n3 - n9 < n2 - 1 - n3 ? n3 - n9 : n2 - 1 - n3;
        n10 = n4;
        n11 = n2 - n6;
        while (n6-- > 0) {
            f = fArray[n10];
            fArray[n10++] = fArray[n11];
            fArray[n11++] = f;
        }
        n6 = n4 - n5;
        if (n6 > 0) {
            Arrays.sort(n, n + n6, fArray);
        }
        if ((n6 = n3 - n9) > 0) {
            Arrays.sort(n2 - n6, n2, fArray);
        }
    }

    public static void sort(int[] nArray) {
        Arrays.sort(0, nArray.length, nArray);
    }

    public static void sort(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(nArray.length, n, n2);
        Arrays.sort(n, n2, nArray);
    }

    private static void sort(int n, int n2, int[] nArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = n2 - n;
        if (n8 < 7) {
            for (int i = n + 1; i < n2; ++i) {
                for (int j = i; j > n && nArray[j - 1] > nArray[j]; --j) {
                    int n9 = nArray[j];
                    nArray[j] = nArray[j - 1];
                    nArray[j - 1] = n9;
                }
            }
            return;
        }
        int n10 = (n + n2) / 2;
        if (n8 > 7) {
            n7 = n;
            n6 = n2 - 1;
            if (n8 > 40) {
                n7 = Arrays.med3(nArray, n7, n7 + (n8 /= 8), n7 + 2 * n8);
                n10 = Arrays.med3(nArray, n10 - n8, n10, n10 + n8);
                n6 = Arrays.med3(nArray, n6 - 2 * n8, n6 - n8, n6);
            }
            n10 = Arrays.med3(nArray, n7, n10, n6);
        }
        n7 = nArray[n10];
        n6 = n5 = n;
        int n11 = n4 = n2 - 1;
        while (true) {
            if (n5 <= n11 && nArray[n5] <= n7) {
                if (nArray[n5] == n7) {
                    n3 = nArray[n6];
                    nArray[n6++] = nArray[n5];
                    nArray[n5] = n3;
                }
                ++n5;
                continue;
            }
            while (n11 >= n5 && nArray[n11] >= n7) {
                if (nArray[n11] == n7) {
                    n3 = nArray[n11];
                    nArray[n11] = nArray[n4];
                    nArray[n4--] = n3;
                }
                --n11;
            }
            if (n5 > n11) break;
            n3 = nArray[n5];
            nArray[n5++] = nArray[n11];
            nArray[n11--] = n3;
        }
        n8 = n6 - n < n5 - n6 ? n6 - n : n5 - n6;
        int n12 = n;
        int n13 = n5 - n8;
        while (n8-- > 0) {
            n3 = nArray[n12];
            nArray[n12++] = nArray[n13];
            nArray[n13++] = n3;
        }
        n8 = n4 - n11 < n2 - 1 - n4 ? n4 - n11 : n2 - 1 - n4;
        n12 = n5;
        n13 = n2 - n8;
        while (n8-- > 0) {
            n3 = nArray[n12];
            nArray[n12++] = nArray[n13];
            nArray[n13++] = n3;
        }
        n8 = n5 - n6;
        if (n8 > 0) {
            Arrays.sort(n, n + n8, nArray);
        }
        if ((n8 = n4 - n11) > 0) {
            Arrays.sort(n2 - n8, n2, nArray);
        }
    }

    public static void sort(long[] lArray) {
        Arrays.sort(0, lArray.length, lArray);
    }

    public static void sort(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(lArray.length, n, n2);
        Arrays.sort(n, n2, lArray);
    }

    private static void sort(int n, int n2, long[] lArray) {
        long l;
        int n3;
        int n4;
        int n5 = n2 - n;
        if (n5 < 7) {
            for (int i = n + 1; i < n2; ++i) {
                for (int j = i; j > n && lArray[j - 1] > lArray[j]; --j) {
                    long l2 = lArray[j];
                    lArray[j] = lArray[j - 1];
                    lArray[j - 1] = l2;
                }
            }
            return;
        }
        int n6 = (n + n2) / 2;
        if (n5 > 7) {
            int n7 = n;
            int n8 = n2 - 1;
            if (n5 > 40) {
                n7 = Arrays.med3(lArray, n7, n7 + (n5 /= 8), n7 + 2 * n5);
                n6 = Arrays.med3(lArray, n6 - n5, n6, n6 + n5);
                n8 = Arrays.med3(lArray, n8 - 2 * n5, n8 - n5, n8);
            }
            n6 = Arrays.med3(lArray, n7, n6, n8);
        }
        long l3 = lArray[n6];
        int n9 = n4 = n;
        int n10 = n3 = n2 - 1;
        while (true) {
            if (n4 <= n10 && lArray[n4] <= l3) {
                if (lArray[n4] == l3) {
                    l = lArray[n9];
                    lArray[n9++] = lArray[n4];
                    lArray[n4] = l;
                }
                ++n4;
                continue;
            }
            while (n10 >= n4 && lArray[n10] >= l3) {
                if (lArray[n10] == l3) {
                    l = lArray[n10];
                    lArray[n10] = lArray[n3];
                    lArray[n3--] = l;
                }
                --n10;
            }
            if (n4 > n10) break;
            l = lArray[n4];
            lArray[n4++] = lArray[n10];
            lArray[n10--] = l;
        }
        n5 = n9 - n < n4 - n9 ? n9 - n : n4 - n9;
        int n11 = n;
        int n12 = n4 - n5;
        while (n5-- > 0) {
            l = lArray[n11];
            lArray[n11++] = lArray[n12];
            lArray[n12++] = l;
        }
        n5 = n3 - n10 < n2 - 1 - n3 ? n3 - n10 : n2 - 1 - n3;
        n11 = n4;
        n12 = n2 - n5;
        while (n5-- > 0) {
            l = lArray[n11];
            lArray[n11++] = lArray[n12];
            lArray[n12++] = l;
        }
        n5 = n4 - n9;
        if (n5 > 0) {
            Arrays.sort(n, n + n5, lArray);
        }
        if ((n5 = n3 - n10) > 0) {
            Arrays.sort(n2 - n5, n2, lArray);
        }
    }

    public static void sort(Object[] objectArray) {
        Arrays.sort(0, objectArray.length, objectArray);
    }

    public static void sort(Object[] objectArray, int n, int n2) {
        if (objectArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(objectArray.length, n, n2);
        Arrays.sort(n, n2, objectArray);
    }

    private static void sort(int n, int n2, Object[] objectArray) {
        int n3 = n2 - n;
        if (n3 <= 0) {
            return;
        }
        if (objectArray instanceof String[]) {
            Arrays.stableStringSort((String[])objectArray, n, n2);
        } else {
            Object[] objectArray2 = new Object[n2];
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            Arrays.mergeSort(objectArray2, objectArray, n, n2);
        }
    }

    private static void swap(int n, int n2, Object[] objectArray) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 7) {
            for (int i = n + 1; i < n2; ++i) {
                Comparable comparable = (Comparable)objectArray2[i];
                Object object = objectArray2[i - 1];
                if (comparable.compareTo(object) >= 0) continue;
                int n4 = i;
                do {
                    objectArray2[n4--] = object;
                } while (n4 > n && comparable.compareTo(object = objectArray2[n4 - 1]) < 0);
                objectArray2[n4] = comparable;
            }
            return;
        }
        int n5 = n2 + n >>> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n5);
        Arrays.mergeSort(objectArray2, objectArray, n5, n2);
        if (((Comparable)objectArray[n5 - 1]).compareTo(objectArray[n5]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n6 = n5;
        int n7 = n;
        do {
            int n8;
            int n9;
            Comparable comparable;
            Comparable comparable2;
            if ((comparable2 = (Comparable)objectArray[n]).compareTo(comparable = (Comparable)objectArray[n6]) <= 0) {
                n9 = Arrays.find(objectArray, comparable, -1, n + 1, n5 - 1);
                n8 = n9 - n + 1;
                System.arraycopy(objectArray, n, objectArray2, n7, n8);
                n7 += n8;
                objectArray2[n7++] = comparable;
                ++n6;
                n = n9 + 1;
                continue;
            }
            n9 = Arrays.find(objectArray, comparable2, 0, n6 + 1, n2 - 1);
            n8 = n9 - n6 + 1;
            System.arraycopy(objectArray, n6, objectArray2, n7, n8);
            n7 += n8;
            objectArray2[n7++] = comparable2;
            ++n;
            n6 = n9 + 1;
        } while (n2 - n6 > 0 && n5 - n > 0);
        if (n2 - n6 <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n7, n5 - n);
        } else {
            System.arraycopy(objectArray, n6, objectArray2, n7, n2 - n6);
        }
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, Comparator comparator) {
        int n3 = n2 - n;
        if (n3 <= 7) {
            for (int i = n + 1; i < n2; ++i) {
                Object object = objectArray2[i - 1];
                Object object2 = objectArray2[i];
                if (comparator.compare(object, object2) <= 0) continue;
                int n4 = i;
                do {
                    objectArray2[n4--] = object;
                } while (n4 > n && comparator.compare(object = objectArray2[n4 - 1], object2) > 0);
                objectArray2[n4] = object2;
            }
            return;
        }
        int n5 = n2 + n >>> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n5, comparator);
        Arrays.mergeSort(objectArray2, objectArray, n5, n2, comparator);
        if (comparator.compare(objectArray[n5 - 1], objectArray[n5]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n6 = n5;
        int n7 = n;
        do {
            int n8;
            int n9;
            Object object;
            Object object3;
            if (comparator.compare(object3 = objectArray[n], object = objectArray[n6]) <= 0) {
                n9 = Arrays.find(objectArray, object, -1, n + 1, n5 - 1, comparator);
                n8 = n9 - n + 1;
                System.arraycopy(objectArray, n, objectArray2, n7, n8);
                n7 += n8;
                objectArray2[n7++] = object;
                ++n6;
                n = n9 + 1;
                continue;
            }
            n9 = Arrays.find(objectArray, object3, 0, n6 + 1, n2 - 1, comparator);
            n8 = n9 - n6 + 1;
            System.arraycopy(objectArray, n6, objectArray2, n7, n8);
            n7 += n8;
            objectArray2[n7++] = object3;
            ++n;
            n6 = n9 + 1;
        } while (n2 - n6 > 0 && n5 - n > 0);
        if (n2 - n6 <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n7, n5 - n);
        } else {
            System.arraycopy(objectArray, n6, objectArray2, n7, n2 - n6);
        }
    }

    private static int find(Object[] objectArray, Comparable comparable, int n, int n2, int n3) {
        int n4 = n2;
        int n5 = 1;
        while (n4 <= n3) {
            if (comparable.compareTo(objectArray[n4]) <= n) {
                n3 = n4 - 1;
                break;
            }
            n2 = n4 + 1;
            n4 += n5;
            n5 <<= 1;
        }
        while (n2 <= n3) {
            n4 = n2 + n3 >>> 1;
            if (comparable.compareTo(objectArray[n4]) > n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2 - 1;
    }

    private static int find(Object[] objectArray, Object object, int n, int n2, int n3, Comparator comparator) {
        int n4 = n2;
        int n5 = 1;
        while (n4 <= n3) {
            if (comparator.compare(object, objectArray[n4]) <= n) {
                n3 = n4 - 1;
                break;
            }
            n2 = n4 + 1;
            n4 += n5;
            n5 <<= 1;
        }
        while (n2 <= n3) {
            n4 = n2 + n3 >>> 1;
            if (comparator.compare(object, objectArray[n4]) > n) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2 - 1;
    }

    private static int medChar(int n, int n2, int n3, String[] stringArray, int n4) {
        int n5 = Arrays.charAt(stringArray[n], n4);
        int n6 = Arrays.charAt(stringArray[n2], n4);
        int n7 = Arrays.charAt(stringArray[n3], n4);
        return n5 < n6 ? (n6 < n7 ? n2 : (n5 < n7 ? n3 : n)) : (n6 < n7 ? (n5 < n7 ? n : n3) : n2);
    }

    private static int charAt(String string, int n) {
        if (n >= string.length()) {
            return -1;
        }
        return string.charAt(n);
    }

    private static void copySwap(Object[] objectArray, int n, Object[] objectArray2, int n2, int n3) {
        if (objectArray == objectArray2 && n + n3 > n2) {
            int n4 = n2 + n3 - 1;
            while (n < n2) {
                objectArray2[n4] = objectArray[n];
                ++n;
                --n4;
                --n3;
            }
            while (n3 > 1) {
                Arrays.swap(n, n4, objectArray2);
                ++n;
                --n4;
                n3 -= 2;
            }
        } else {
            n2 = n2 + n3 - 1;
            while (n3 > 0) {
                objectArray2[n2] = objectArray[n];
                ++n;
                --n2;
                --n3;
            }
        }
    }

    private static void stableStringSort(String[] stringArray, int n, int n2) {
        Arrays.stableStringSort(stringArray, stringArray, new String[n2], n, n2, 0);
    }

    private static void stableStringSort(String[] stringArray, String[] stringArray2, String[] stringArray3, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6 = n2 - n;
        if (n6 < 7) {
            if (stringArray2 == stringArray) {
                for (int i = n + 1; i < n2; ++i) {
                    String string = stringArray[i];
                    String string2 = stringArray[i - 1];
                    if (string.compareTo(string2) >= 0) continue;
                    int n7 = i;
                    do {
                        stringArray[n7--] = string2;
                    } while (n7 > n && string.compareTo(string2 = stringArray[n7 - 1]) < 0);
                    stringArray[n7] = string;
                }
            } else {
                int n8 = n2 - 1;
                stringArray3[n] = stringArray2[n8--];
                int n9 = n + 1;
                while (n9 < n2) {
                    String string;
                    String string3 = stringArray2[n8];
                    int n10 = n9;
                    while (n10 > n && string3.compareTo(string = stringArray3[n10 - 1]) < 0) {
                        stringArray3[n10--] = string;
                    }
                    stringArray3[n10] = string3;
                    ++n9;
                    --n8;
                }
            }
            return;
        }
        int n11 = n + n6 / 2;
        int n12 = n;
        int n13 = n2 - 1;
        if (n6 > 40) {
            n5 = n6 / 8;
            n12 = Arrays.medChar(n12, n12 + n5, n12 + n5 * 2, stringArray2, n3);
            n11 = Arrays.medChar(n11 - n5, n11, n11 + n5, stringArray2, n3);
            n13 = Arrays.medChar(n13, n13 - n5, n13 - n5 * 2, stringArray2, n3);
        }
        n11 = Arrays.medChar(n12, n11, n13, stringArray2, n3);
        int n14 = Arrays.charAt(stringArray2[n11], n3);
        int n15 = n4 = n;
        int n16 = n2 - 1;
        for (int i = n; i < n2; ++i) {
            String string = stringArray2[i];
            int n17 = Arrays.charAt(string, n3) - n14;
            if (n17 < 0) {
                stringArray2[n15] = string;
                ++n15;
                continue;
            }
            if (n17 > 0) {
                stringArray3[n16] = string;
                --n16;
                continue;
            }
            stringArray3[n4] = string;
            ++n4;
        }
        n5 = n4 - n;
        if (n5 > 0) {
            if (stringArray == stringArray2) {
                System.arraycopy(stringArray3, n, stringArray, n15, n5);
            } else {
                Arrays.copySwap(stringArray3, n, stringArray, n15, n5);
            }
            if (n4 >= n2 && n14 == -1) {
                return;
            }
            Arrays.stableStringSort(stringArray, stringArray, stringArray == stringArray3 ? stringArray2 : stringArray3, n15, n15 + n5, n3 + 1);
        }
        if ((n5 = n15 - n) > 0) {
            Arrays.stableStringSort(stringArray, stringArray2, stringArray3, n, n15, n3);
        }
        if ((n5 = n2 - ++n16) > 0) {
            Arrays.stableStringSort(stringArray, stringArray3, stringArray2, n16, n2, n3);
        }
    }

    public static <T> void sort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        if (TArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(TArray.length, n, n2);
        Arrays.sort(n, n2, TArray, comparator);
    }

    private static <T> void sort(int n, int n2, T[] TArray, Comparator<? super T> comparator) {
        if (comparator == null) {
            Arrays.sort(n, n2, TArray);
        } else {
            int n3 = n2 - n;
            Object[] objectArray = new Object[n2];
            System.arraycopy(TArray, n, objectArray, n, n3);
            Arrays.mergeSort(objectArray, TArray, n, n2, comparator);
        }
    }

    public static <T> void sort(T[] TArray, Comparator<? super T> comparator) {
        Arrays.sort(0, TArray.length, TArray, comparator);
    }

    public static void sort(short[] sArray) {
        Arrays.sort(0, sArray.length, sArray);
    }

    public static void sort(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw new NullPointerException();
        }
        Arrays.checkBounds(sArray.length, n, n2);
        Arrays.sort(n, n2, sArray);
    }

    private static void sort(int n, int n2, short[] sArray) {
        short s;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n2 - n;
        if (n7 < 7) {
            for (int i = n + 1; i < n2; ++i) {
                for (int j = i; j > n && sArray[j - 1] > sArray[j]; --j) {
                    short s2 = sArray[j];
                    sArray[j] = sArray[j - 1];
                    sArray[j - 1] = s2;
                }
            }
            return;
        }
        int n8 = (n + n2) / 2;
        if (n7 > 7) {
            n6 = n;
            n5 = n2 - 1;
            if (n7 > 40) {
                n6 = Arrays.med3(sArray, n6, n6 + (n7 /= 8), n6 + 2 * n7);
                n8 = Arrays.med3(sArray, n8 - n7, n8, n8 + n7);
                n5 = Arrays.med3(sArray, n5 - 2 * n7, n5 - n7, n5);
            }
            n8 = Arrays.med3(sArray, n6, n8, n5);
        }
        n6 = sArray[n8];
        n5 = n4 = n;
        int n9 = n3 = n2 - 1;
        while (true) {
            if (n4 <= n9 && sArray[n4] <= n6) {
                if (sArray[n4] == n6) {
                    s = sArray[n5];
                    sArray[n5++] = sArray[n4];
                    sArray[n4] = s;
                }
                ++n4;
                continue;
            }
            while (n9 >= n4 && sArray[n9] >= n6) {
                if (sArray[n9] == n6) {
                    s = sArray[n9];
                    sArray[n9] = sArray[n3];
                    sArray[n3--] = s;
                }
                --n9;
            }
            if (n4 > n9) break;
            s = sArray[n4];
            sArray[n4++] = sArray[n9];
            sArray[n9--] = s;
        }
        n7 = n5 - n < n4 - n5 ? n5 - n : n4 - n5;
        int n10 = n;
        int n11 = n4 - n7;
        while (n7-- > 0) {
            s = sArray[n10];
            sArray[n10++] = sArray[n11];
            sArray[n11++] = s;
        }
        n7 = n3 - n9 < n2 - 1 - n3 ? n3 - n9 : n2 - 1 - n3;
        n10 = n4;
        n11 = n2 - n7;
        while (n7-- > 0) {
            s = sArray[n10];
            sArray[n10++] = sArray[n11];
            sArray[n11++] = s;
        }
        n7 = n4 - n5;
        if (n7 > 0) {
            Arrays.sort(n, n + n7, sArray);
        }
        if ((n7 = n3 - n9) > 0) {
            Arrays.sort(n2 - n7, n2, sArray);
        }
    }

    public static String toString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        if (blArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + blArray.length * 5);
        stringBuilder.append('[');
        stringBuilder.append(blArray[0]);
        for (int i = 1; i < blArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(blArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        if (byArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + byArray.length * 3);
        stringBuilder.append('[');
        stringBuilder.append(byArray[0]);
        for (int i = 1; i < byArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(byArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        if (cArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + cArray.length * 2);
        stringBuilder.append('[');
        stringBuilder.append(cArray[0]);
        for (int i = 1; i < cArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(cArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(double[] dArray) {
        if (dArray == null) {
            return "null";
        }
        if (dArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + dArray.length * 5);
        stringBuilder.append('[');
        stringBuilder.append(dArray[0]);
        for (int i = 1; i < dArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(dArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(float[] fArray) {
        if (fArray == null) {
            return "null";
        }
        if (fArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + fArray.length * 5);
        stringBuilder.append('[');
        stringBuilder.append(fArray[0]);
        for (int i = 1; i < fArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(fArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        if (nArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + nArray.length * 4);
        stringBuilder.append('[');
        stringBuilder.append(nArray[0]);
        for (int i = 1; i < nArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(nArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(long[] lArray) {
        if (lArray == null) {
            return "null";
        }
        if (lArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + lArray.length * 4);
        stringBuilder.append('[');
        stringBuilder.append(lArray[0]);
        for (int i = 1; i < lArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(lArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(short[] sArray) {
        if (sArray == null) {
            return "null";
        }
        if (sArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + sArray.length * 4);
        stringBuilder.append('[');
        stringBuilder.append(sArray[0]);
        for (int i = 1; i < sArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(sArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(2 + objectArray.length * 5);
        stringBuilder.append('[');
        stringBuilder.append(objectArray[0]);
        for (int i = 1; i < objectArray.length; ++i) {
            stringBuilder.append(", ");
            stringBuilder.append(objectArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static String deepToString(Object[] objectArray) {
        return Arrays.deepToStringImpl(objectArray, new Object[]{objectArray}, null);
    }

    private static String deepToStringImpl(Object[] objectArray, Object[] objectArray2, StringBuilder stringBuilder) {
        if (objectArray == null) {
            return "null";
        }
        if (objectArray.length == 0) {
            return "[]";
        }
        if (stringBuilder == null) {
            stringBuilder = new StringBuilder(2 + objectArray.length * 5);
        }
        stringBuilder.append('[');
        for (int i = 0; i < objectArray.length; ++i) {
            Object object;
            if (i != 0) {
                stringBuilder.append(", ");
            }
            if ((object = objectArray[i]) == null) {
                stringBuilder.append("null");
                continue;
            }
            Class<?> clazz = object.getClass();
            if (clazz.isArray()) {
                Class<?> clazz2 = clazz.getComponentType();
                if (clazz2.isPrimitive()) {
                    if (Boolean.TYPE.equals(clazz2)) {
                        stringBuilder.append(Arrays.toString((boolean[])object));
                        continue;
                    }
                    if (Byte.TYPE.equals(clazz2)) {
                        stringBuilder.append(Arrays.toString((byte[])object));
                        continue;
                    }
                    if (Character.TYPE.equals(clazz2)) {
                        stringBuilder.append(Arrays.toString((char[])object));
                        continue;
                    }
                    if (Double.TYPE.equals(clazz2)) {
                        stringBuilder.append(Arrays.toString((double[])object));
                        continue;
                    }
                    if (Float.TYPE.equals(clazz2)) {
                        stringBuilder.append(Arrays.toString((float[])object));
                        continue;
                    }
                    if (Integer.TYPE.equals(clazz2)) {
                        stringBuilder.append(Arrays.toString((int[])object));
                        continue;
                    }
                    if (Long.TYPE.equals(clazz2)) {
                        stringBuilder.append(Arrays.toString((long[])object));
                        continue;
                    }
                    if (Short.TYPE.equals(clazz2)) {
                        stringBuilder.append(Arrays.toString((short[])object));
                        continue;
                    }
                    throw new AssertionError();
                }
                assert (object instanceof Object[]);
                if (Arrays.deepToStringImplContains(objectArray2, object)) {
                    stringBuilder.append("[...]");
                    continue;
                }
                Object[] objectArray3 = (Object[])object;
                Object[] objectArray4 = new Object[objectArray2.length + 1];
                System.arraycopy(objectArray2, 0, objectArray4, 0, objectArray2.length);
                objectArray4[objectArray2.length] = objectArray3;
                Arrays.deepToStringImpl(objectArray3, objectArray4, stringBuilder);
                continue;
            }
            stringBuilder.append(objectArray[i]);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private static boolean deepToStringImplContains(Object[] objectArray, Object object) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        for (Object object2 : objectArray) {
            if (object2 != object) continue;
            return true;
        }
        return false;
    }

    public static boolean[] copyOf(boolean[] blArray, int n) {
        if (0 <= n) {
            return Arrays.copyOfRange(blArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static byte[] copyOf(byte[] byArray, int n) {
        if (0 <= n) {
            return Arrays.copyOfRange(byArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static char[] copyOf(char[] cArray, int n) {
        if (0 <= n) {
            return Arrays.copyOfRange(cArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static double[] copyOf(double[] dArray, int n) {
        if (0 <= n) {
            return Arrays.copyOfRange(dArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static float[] copyOf(float[] fArray, int n) {
        if (0 <= n) {
            return Arrays.copyOfRange(fArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static int[] copyOf(int[] nArray, int n) {
        if (0 <= n) {
            return Arrays.copyOfRange(nArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static long[] copyOf(long[] lArray, int n) {
        if (0 <= n) {
            return Arrays.copyOfRange(lArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static short[] copyOf(short[] sArray, int n) {
        if (0 <= n) {
            return Arrays.copyOfRange(sArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static <T> T[] copyOf(T[] TArray, int n) {
        if (null == TArray) {
            throw new NullPointerException();
        }
        if (0 <= n) {
            return Arrays.copyOfRange(TArray, 0, n);
        }
        throw new NegativeArraySizeException();
    }

    public static <T, U> T[] copyOf(U[] UArray, int n, Class<? extends T[]> clazz) {
        if (0 <= n) {
            return Arrays.copyOfRange(UArray, 0, n, clazz);
        }
        throw new NegativeArraySizeException();
    }

    public static boolean[] copyOfRange(boolean[] blArray, int n, int n2) {
        if (n <= n2) {
            if (blArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, blArray.length - n);
                boolean[] blArray2 = new boolean[n3];
                System.arraycopy(blArray, n, blArray2, 0, n4);
                return blArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static byte[] copyOfRange(byte[] byArray, int n, int n2) {
        if (n <= n2) {
            if (byArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, byArray.length - n);
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, n, byArray2, 0, n4);
                return byArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static char[] copyOfRange(char[] cArray, int n, int n2) {
        if (n <= n2) {
            if (cArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, cArray.length - n);
                char[] cArray2 = new char[n3];
                System.arraycopy(cArray, n, cArray2, 0, n4);
                return cArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static double[] copyOfRange(double[] dArray, int n, int n2) {
        if (n <= n2) {
            if (dArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, dArray.length - n);
                double[] dArray2 = new double[n3];
                System.arraycopy(dArray, n, dArray2, 0, n4);
                return dArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static float[] copyOfRange(float[] fArray, int n, int n2) {
        if (n <= n2) {
            if (fArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, fArray.length - n);
                float[] fArray2 = new float[n3];
                System.arraycopy(fArray, n, fArray2, 0, n4);
                return fArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static int[] copyOfRange(int[] nArray, int n, int n2) {
        if (n <= n2) {
            if (nArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, nArray.length - n);
                int[] nArray2 = new int[n3];
                System.arraycopy(nArray, n, nArray2, 0, n4);
                return nArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static long[] copyOfRange(long[] lArray, int n, int n2) {
        if (n <= n2) {
            if (lArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, lArray.length - n);
                long[] lArray2 = new long[n3];
                System.arraycopy(lArray, n, lArray2, 0, n4);
                return lArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static short[] copyOfRange(short[] sArray, int n, int n2) {
        if (n <= n2) {
            if (sArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, sArray.length - n);
                short[] sArray2 = new short[n3];
                System.arraycopy(sArray, n, sArray2, 0, n4);
                return sArray2;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    public static <T> T[] copyOfRange(T[] TArray, int n, int n2) {
        if (TArray.length >= n && 0 <= n) {
            if (n <= n2) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, TArray.length - n);
                Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n3);
                System.arraycopy(TArray, n, objectArray, 0, n4);
                return objectArray;
            }
            throw new IllegalArgumentException();
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static <T, U> T[] copyOfRange(U[] UArray, int n, int n2, Class<? extends T[]> clazz) {
        if (n <= n2) {
            if (UArray.length >= n && 0 <= n) {
                int n3 = n2 - n;
                int n4 = Math.min(n3, UArray.length - n);
                Object[] objectArray = (Object[])Array.newInstance(clazz.getComponentType(), n3);
                System.arraycopy(UArray, n, objectArray, 0, n4);
                return objectArray;
            }
            throw new ArrayIndexOutOfBoundsException();
        }
        throw new IllegalArgumentException();
    }

    private static class ArrayList<E>
    extends AbstractList<E>
    implements List<E>,
    Serializable,
    RandomAccess {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        ArrayList(E[] EArray) {
            if (EArray == null) {
                throw new NullPointerException();
            }
            this.a = EArray;
        }

        @Override
        public boolean contains(Object object) {
            if (object != null) {
                for (E e : this.a) {
                    if (!object.equals(e)) continue;
                    return true;
                }
            } else {
                for (E e : this.a) {
                    if (e != null) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public E get(int n) {
            try {
                return this.a[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
        }

        @Override
        public int indexOf(Object object) {
            if (object != null) {
                for (int i = 0; i < this.a.length; ++i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.a.length; ++i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object object) {
            if (object != null) {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            } else {
                for (int i = this.a.length - 1; i >= 0; --i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public E set(int n, E e) {
            try {
                E e2 = this.a[n];
                this.a[n] = e;
                return e2;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IndexOutOfBoundsException();
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new ClassCastException();
            }
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        @Override
        public <T> T[] toArray(T[] objectArray) {
            int n = this.size();
            if (n > objectArray.length) {
                Class<?> clazz = objectArray.getClass().getComponentType();
                objectArray = (Object[])Array.newInstance(clazz, n);
            }
            System.arraycopy(this.a, 0, objectArray, 0, n);
            if (n < objectArray.length) {
                objectArray[n] = null;
            }
            return objectArray;
        }
    }
}

