/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

public abstract class AbstractCollection<E>
implements Collection<E> {
    protected AbstractCollection() {
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public boolean contains(Object object) {
        Iterator<E> iterator = this.iterator();
        if (object != null) {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public boolean remove(Object object) {
        Iterator<E> iterator = this.iterator();
        if (object != null) {
            while (iterator.hasNext()) {
                if (!object.equals(iterator.next())) continue;
                iterator.remove();
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public abstract int size();

    @Override
    public Object[] toArray() {
        int n = this.size();
        int n2 = 0;
        Iterator<E> iterator = this.iterator();
        Object[] objectArray = new Object[n];
        while (n2 < n) {
            objectArray[n2++] = iterator.next();
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        int n = this.size();
        int n2 = 0;
        if (n > objectArray.length) {
            Class<?> clazz = objectArray.getClass().getComponentType();
            objectArray = (Object[])Array.newInstance(clazz, n);
        }
        for (Object e : this) {
            objectArray[n2++] = e;
        }
        if (n2 < objectArray.length) {
            objectArray[n2] = null;
        }
        return objectArray;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder(this.size() * 16);
        stringBuilder.append('[');
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            E e = iterator.next();
            if (e != this) {
                stringBuilder.append(e);
            } else {
                stringBuilder.append("(this Collection)");
            }
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

