/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.CommException;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.IllegalStateException;
import javax.resource.spi.LocalTransactionException;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.ResourceAllocationException;
import javax.resource.spi.SecurityException;

class ReasonCodeInfo
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/ReasonCodeInfo.java, java.classes, k700, k700-L080529 1.23.1.1 08/06/01 09:03:30";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int REC_RESOURCE = 0;
    public static final int REC_APPSERVERINTERNAL = 1;
    public static final int REC_COMM = 2;
    public static final int REC_EISSYSTEM = 3;
    public static final int REC_ILLEGALSTATE = 4;
    public static final int REC_LOCALTRANSACTION = 5;
    public static final int REC_NOTSUPPORTED = 6;
    public static final int REC_RESOURCEADAPTERINTERNAL = 7;
    public static final int REC_RESOURCEALLOCATION = 8;
    public static final int REC_SECURITY = 9;
    public static final int REC_UNKNOWN = 15;
    public static final int RCC_NORMAL = 0;
    public static final int RCC_USAGE = 1;
    public static final int RCC_CONFIGURATION = 2;
    public static final int RCC_SYSTEM = 3;
    public static final int RCC_ADAPTER = 4;
    public static final int RCC_RESOURCE_SHORTAGE = 5;
    public static final int RCC_UNKNOWN = 15;
    private static final byte RESOURCE = 0;
    private static final byte COMM = 2;
    private static final byte EIS = 3;
    private static final byte NOTSUPP = 6;
    private static final byte ADAPINT = 7;
    private static final byte ALLOC = 8;
    private static final byte SECURITY = 9;
    private static final byte NORM = 0;
    private static final byte USAGE = 16;
    private static final byte CONFIG = 32;
    private static final byte SYSTEM = 48;
    private static final byte ADAPTER = 64;
    private static final byte SHORT = 80;
    private static final byte REC_MASK = 15;
    private static final int REC_SHIFT = 0;
    private static final byte RCC_MASK = -16;
    private static final int RCC_SHIFT = 4;
    private static final byte UNKNOWN_REASON_CODE = -1;
    private static final int MINIMUM_REASON_CODE = 2001;
    private static final int MAXIMUM_REASON_CODE = 2362;
    private static final byte[] table = new byte[]{32, 0, 0, 71, 71, 16, 16, 16, 50, 16, 16, 0, 16, 16, -1, 32, 88, 71, 71, 16, 16, 16, 16, 80, 88, 22, 16, -1, 16, 32, 32, -1, 0, 0, 41, 16, 16, 16, 16, 16, 0, 0, 16, 71, 16, 16, 16, 16, 16, 16, 32, 32, 80, -1, 16, 88, 16, 19, 51, -1, 16, 16, 51, -1, 71, 16, 16, 16, 16, 0, 88, 22, -1, -1, 16, 16, 16, 16, 0, 16, -1, 32, -1, -1, 32, 71, 32, -1, -1, 16, 32, 32, 16, 16, 16, 16, 16, 16, 71, 16, 51, 88, 71, 16, 32, 16, 71, 71, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 71, 71, 88, 16, 55, 55, 55, 55, 55, 71, 16, 16, 16, 55, 71, 55, 16, 16, 32, 32, 32, 32, -1, 16, 16, 16, -1, 71, 71, 71, 71, 71, 71, 16, 71, 32, 51, 51, 32, -1, -1, -1, -1, -1, -1, -1, -1, -1, 22, -1, -1, -1, -1, -1, -1, -1, -1, 48, 48, 32, 16, 22, 71, 16, 32, 16, 16, 88, 35, 16, 51, 32, 32, 32, 32, -1, 16, 51, 51, 51, -1, 22, 22, 51, 16, -1, -1, -1, -1, -1, -1, 51, 41, 32, 71, 16, -1, 51, 51, 51, 51, 51, 51, -1, -1, -1, -1, 16, 51, 51, 16, 16, 16, 16, 16, -1, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, 16, -1, 16, 16, 16, 16, 16, 16, 16, 16, 51, 51, 16, 32, 32, 32, 51, 32, 16, 16, 51, 16, -1, -1, 66, 66, 51, 71, 71, 51, 51, 51, 32, 48, 48, 32, 48, 32, 0, 32, 32, 32, 51, 51, 16, 51, 51, 51, 16, 16, 16, 16, 16, 16, 71, 16, 16, 71, 0, 16, 16, 16, 16, 16, 16, 16, 71, 71, 16, 35, 71, 16, 16, 16, 71, 16, 16, 71, 16, 16, 16, 16, 16, 16, 16, 16, 16, 71, 71, 51, 35, 0, 51, 3, 3, 41, 35, 35, 16, 16, 16, 48, 16, 16, 48, 16, 0, 16, 71, 51, 51, 51};

    public ReasonCodeInfo() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 487;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 487);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 487);
        }
    }

    public static int getResourceExceptionClass(int reason) {
        int value = reason < 2001 || reason >= 2362 ? -1 : table[reason - 2001];
        value = (value & 0xF) >>> 0;
        return value;
    }

    public static int getReasonCodeCategory(int reason) {
        int value = reason < 2001 || reason >= 2362 ? -1 : table[reason - 2001];
        value = (value & 0xFFFFFFF0) >>> 4;
        return value;
    }

    public static ResourceException getResourceException(MQException e) {
        ResourceException out;
        String reason = e.getMessage();
        int reasonCode = e.reasonCode;
        int type = ReasonCodeInfo.getResourceExceptionClass(reasonCode);
        switch (type) {
            case 0: 
            case 15: {
                out = new ResourceException(reason, "" + reasonCode);
                break;
            }
            case 1: {
                out = new ApplicationServerInternalException(reason, "" + reasonCode);
                break;
            }
            case 2: {
                out = new CommException(reason, "" + reasonCode);
                break;
            }
            case 3: {
                out = new EISSystemException(reason, "" + reasonCode);
                break;
            }
            case 4: {
                out = new IllegalStateException(reason, "" + reasonCode);
                break;
            }
            case 5: {
                out = new LocalTransactionException(reason, "" + reasonCode);
                break;
            }
            case 6: {
                out = new NotSupportedException(reason, "" + reasonCode);
                break;
            }
            case 7: {
                out = new ResourceAdapterInternalException(reason, "" + reasonCode);
                break;
            }
            case 8: {
                out = new ResourceAllocationException(reason, "" + reasonCode);
                break;
            }
            case 9: {
                out = new SecurityException(reason, "" + reasonCode);
                break;
            }
            default: {
                out = new ResourceAdapterInternalException(reason, "" + reasonCode);
            }
        }
        out.setLinkedException((Exception)((Object)e));
        return out;
    }
}

