/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;
import java.io.IOException;

class MQS390PackedDecimalSupport
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQS390PackedDecimalSupport.java, java.classes, k700, k700-L080529 1.22.1.1 08/06/01 09:00:41";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public MQS390PackedDecimalSupport() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 390;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 390);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 390);
        }
    }

    protected static final long convertToBinary(byte[] packedDecimalBytes) throws IOException {
        long retVal = 0L;
        long multiplier = 1L;
        boolean positive = true;
        for (int b = packedDecimalBytes.length - 1; b >= 0; --b) {
            byte thisByte = packedDecimalBytes[b];
            int leastSignificantDigit = thisByte & 0xF;
            int mostSignificantDigit = thisByte >>> 4 & 0xF;
            if (b == packedDecimalBytes.length - 1) {
                switch (leastSignificantDigit) {
                    case 12: {
                        positive = true;
                        break;
                    }
                    case 13: {
                        positive = false;
                        break;
                    }
                    case 15: {
                        positive = true;
                        break;
                    }
                    default: {
                        throw new IOException("Invalid sign nibble in packed decimal");
                    }
                }
                leastSignificantDigit = mostSignificantDigit;
                mostSignificantDigit = 0;
            }
            if (leastSignificantDigit > 9 || mostSignificantDigit > 9) {
                throw new IOException("Packed Decimal digit outside of range 0-9");
            }
            int binaryValue = leastSignificantDigit + 10 * mostSignificantDigit;
            retVal += multiplier * (long)binaryValue;
            if (b == packedDecimalBytes.length - 1) {
                multiplier *= 10L;
                continue;
            }
            multiplier *= 100L;
        }
        if (!positive) {
            retVal = -retVal;
        }
        return retVal;
    }

    protected static final byte[] convertToPackedDecimal(short binary) throws IOException {
        if (binary > 999 || binary < -999) {
            throw new IOException("Outside of range for short packed decimal (+/-999)");
        }
        byte[] retVal = new byte[2];
        boolean positive = binary >= 0;
        int decimalDigit = Math.abs(binary % 10);
        binary = (short)(binary / 10);
        byte signByte = positive ? (byte)(decimalDigit << 4 | 0xC) : (byte)(decimalDigit << 4 | 0xD);
        retVal[1] = signByte;
        for (int byteIndex = 0; byteIndex >= 0; --byteIndex) {
            byte thisByte;
            int leastSignificantDigit = Math.abs(binary % 10);
            binary = (short)(binary / 10);
            int mostSignificantDigit = Math.abs(binary % 10);
            binary = (short)(binary / 10);
            retVal[byteIndex] = thisByte = (byte)(leastSignificantDigit | mostSignificantDigit << 4);
        }
        return retVal;
    }

    protected static final byte[] convertToPackedDecimal(int binary) throws IOException {
        if (binary > 9999999 || binary < -9999999) {
            throw new IOException("Outside of range for integer packed decimal (+/-9999999)");
        }
        byte[] retVal = new byte[4];
        boolean positive = binary >= 0;
        int decimalDigit = Math.abs(binary % 10);
        binary /= 10;
        byte signByte = positive ? (byte)(decimalDigit << 4 | 0xC) : (byte)(decimalDigit << 4 | 0xD);
        retVal[3] = signByte;
        for (int byteIndex = 2; byteIndex >= 0; --byteIndex) {
            byte thisByte;
            int leastSignificantDigit = Math.abs(binary % 10);
            int mostSignificantDigit = Math.abs((binary /= 10) % 10);
            binary /= 10;
            retVal[byteIndex] = thisByte = (byte)(leastSignificantDigit | mostSignificantDigit << 4);
        }
        return retVal;
    }

    protected static final byte[] convertToPackedDecimal(long binary) throws IOException {
        if (binary > 999999999999999L || binary < -999999999999999L) {
            throw new IOException("Outside of range for long packed decimal (0+/-999999999999999)");
        }
        byte[] retVal = new byte[8];
        boolean positive = binary >= 0L;
        int decimalDigit = (int)Math.abs(binary % 10L);
        binary /= 10L;
        byte signByte = positive ? (byte)(decimalDigit << 4 | 0xC) : (byte)(decimalDigit << 4 | 0xD);
        retVal[7] = signByte;
        for (int byteIndex = 6; byteIndex >= 0; --byteIndex) {
            byte thisByte;
            int leastSignificantDigit = (int)Math.abs(binary % 10L);
            int mostSignificantDigit = (int)Math.abs((binary /= 10L) % 10L);
            binary /= 10L;
            retVal[byteIndex] = thisByte = (byte)(leastSignificantDigit | mostSignificantDigit << 4);
        }
        return retVal;
    }
}

