/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQOD;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.Pint;

public class MQProcess
extends MQManagedObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQProcess.java, java.classes, k700, k700-L080529 1.30.1.1 08/06/01 08:58:59";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MQOT_PROCESS = 3;
    private Pint completionCode = new Pint();
    private Pint reason = new Pint();
    private MQSESSION osession = null;

    protected MQProcess() {
        int traceContext = 0;
        int fid = 302;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 302);
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 302, "sccsid = ", (Object)sccsid);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 302);
        }
    }

    public MQProcess(MQQueueManager qMgr, String processName, int openOptions) throws MQException {
        this(qMgr, processName, openOptions, null, null);
        int traceContext = 0;
        int fid = 596;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 596, new Object[]{qMgr, processName, new Integer(openOptions)});
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 596);
        }
    }

    public MQProcess(MQQueueManager qMgr, String processName, int openOptions, String queueManagerName, String alternateUserId) throws MQException {
        int traceContext = 0;
        int fid = 303;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 303, new Object[]{qMgr, processName, new Integer(openOptions), queueManagerName, alternateUserId});
        }
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 303, "sccsid = ", (Object)sccsid);
        }
        if (qMgr == null) {
            MQException traceRet1 = new MQException(2, 2018, (Object)this, "MQJI001");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 303, (Throwable)traceRet1, 1);
            }
            throw traceRet1;
        }
        if (this.osession == null) {
            this.osession = qMgr.getSession();
        }
        if (!qMgr.connected || this.osession == null) {
            MQException traceRet2 = new MQException(2, 2018, (Object)this, "MQJI002");
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 303, (Throwable)traceRet2, 2);
            }
            throw traceRet2;
        }
        MQOD od = new MQOD();
        od.ObjectType = 3;
        if (processName != null && processName.length() > 0) {
            od.ObjectName = processName;
        }
        if (queueManagerName != null && queueManagerName.length() > 0) {
            od.ObjectQMgrName = queueManagerName;
        }
        if (alternateUserId != null && alternateUserId.length() > 0) {
            od.AlternateUserId = alternateUserId;
        }
        this.Hconn = qMgr.Hconn;
        this.connected = qMgr.connected;
        openOptions |= 0x20;
        if (this.trace.isOn) {
            this.trace.dataFmt(this.env, COMP_JN, 303, "process = " + od.ObjectName + "\nqueue manager = " + od.ObjectQMgrName + "\nalternate user id = " + od.AlternateUserId + "\noptions = " + openOptions, (Object)"");
        }
        this.osession.MQOPEN(this.Hconn.getHconn(), od, openOptions, this.Hobj, this.completionCode, this.reason);
        if (this.completionCode.x != 0 || this.reason.x != 0) {
            this.resourceOpen = false;
            MQException mqe = new MQException(this.completionCode.x, this.reason.x, (Object)this, this.osession.getLastJmqiException());
            qMgr.errorOccurred(mqe);
            if (this.trace.isOn) {
                this.trace.throwing((Object)this, COMP_JN, 303, (Throwable)mqe, 3);
            }
            throw mqe;
        }
        this.resourceOpen = true;
        qMgr.registerProcess(this);
        this.name = processName;
        this.openOptions = openOptions;
        this.isOpen = true;
        this.openStatus = true;
        this.parentQmgr = qMgr;
        this.connectionReference = qMgr;
        if (alternateUserId != null) {
            this.alternateUserId = alternateUserId;
        }
        this.mqca_description = 2011;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 303);
        }
    }

    public synchronized void close() throws MQException {
        int traceContext = 0;
        int fid = 304;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 304);
        }
        super.close();
        if (this.connectionReference != null) {
            this.connectionReference.unregisterProcess(this);
        }
        this.connectionReference = null;
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 304);
        }
    }

    public String getApplicationId() throws MQException {
        String traceRet1 = this.getString(2001, 256);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getApplicationId()", (Object)traceRet1);
        }
        return traceRet1;
    }

    public int getApplicationType() throws MQException {
        int traceRet1 = this.getInt(1);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getApplicationType()", (Object)new Integer(traceRet1));
        }
        return traceRet1;
    }

    public String getEnvironmentData() throws MQException {
        String traceRet1 = this.getString(2007, 128);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getEnvironmentData()", (Object)traceRet1);
        }
        return traceRet1;
    }

    public String getUserData() throws MQException {
        String traceRet1 = this.getString(2021, 128);
        if (this.trace.isOn) {
            this.trace.data((Object)this, COMP_JN, 0, "getUserData()", (Object)traceRet1);
        }
        return traceRet1;
    }
}

