/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQConnectionManager;
import com.ibm.mq.MQEnvironmentPropertiesHashtable;
import com.ibm.mq.MQException;
import com.ibm.mq.MQPoolServices;
import com.ibm.mq.MQPoolToken;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSESSION;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.MQSimpleConnectionManager;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.internal.MQCommonServices;
import com.ibm.mq.jmqi.JmqiEnvironment;
import com.ibm.mq.jmqi.JmqiObject;
import com.ibm.mq.jmqi.system.JmqiCodepage;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.resource.spi.ConnectionManager;

public class MQEnvironment
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQEnvironment.java, java.classes, k700, k700-L080529 1.38.1.1 08/06/01 08:54:33";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static int COMP_JN = JmqiObject.COMP_JN;
    public static final String version_notice = "Websphere MQ classes for Java V6.0.0";
    public static MQSecurityExit securityExit = null;
    public static String securityExitUserData = null;
    public static Object channelSecurityExit = null;
    public static String channelSecurityExitUserData = null;
    public static MQSendExit sendExit = null;
    public static String sendExitUserData = null;
    public static Object channelSendExit = null;
    public static String channelSendExitUserData = null;
    public static MQReceiveExit receiveExit = null;
    public static String receiveExitUserData = null;
    public static Object channelReceiveExit = null;
    public static String channelReceiveExitUserData = null;
    public static String exitClasspath = null;
    public static String hostname = "";
    public static int port = 1414;
    public static String channel = "";
    public static String userID = "";
    public static String password = "";
    public static int CCSID = 819;
    public static Collection hdrCompList = null;
    public static Collection msgCompList = null;
    public static String sslCipherSuite = null;
    public static String sslPeerName = null;
    public static Collection sslCertStores = null;
    public static Object sslSocketFactory = null;
    public static int sslResetCount = 0;
    public static boolean sslFipsRequired = false;
    public static String localAddressSetting = null;
    public static byte[] connTag = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static int connOptions = 0;
    public static int sharingConversations = 10;
    public static Hashtable properties = new MQEnvironmentPropertiesHashtable();
    static Vector poolTokenSet = new Vector();
    static Vector poolServices = new Vector();
    static MQConnectionManager defaultMQCxManager = new MQSimpleConnectionManager();
    static ConnectionManager defaultCxManager = null;
    static boolean xaClientEnabled = false;
    static int xaLicenseMsg = 0;
    protected static boolean runningInWebSphere = false;
    protected static boolean forceAllowClient = false;

    public MQEnvironment() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 692;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 692);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 692);
        }
    }

    public static final String getVersionNotice() {
        return version_notice;
    }

    public static void enableTracing(int level) {
        MQCommonServices.enableTrace();
    }

    public static void enableTracing(int level, OutputStream stream) {
        MQCommonServices.enableTrace();
    }

    public static void disableTracing() {
        MQCommonServices.disableTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConnectionManager(MQConnectionManager mqCxMan) {
        if (mqCxMan == null) {
            throw new NullPointerException(MQException.getNLSMsg((String)"MQNULLPOINTER", (String)"MQConnectionManager"));
        }
        Vector vector = poolTokenSet;
        synchronized (vector) {
            defaultMQCxManager = mqCxMan;
            defaultCxManager = null;
            poolTokenSet.removeAllElements();
        }
        Vector v = (Vector)poolServices.clone();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            MQPoolServices ps = (MQPoolServices)((Object)e.nextElement());
            ps.fireDefaultConnectionManagerChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultConnectionManager(ConnectionManager cxMan) {
        if (cxMan == null) {
            throw new NullPointerException(MQException.getNLSMsg((String)"MQNULLPOINTER", (String)"ConnectionManager"));
        }
        Vector vector = poolTokenSet;
        synchronized (vector) {
            defaultCxManager = cxMan;
            defaultMQCxManager = null;
            poolTokenSet.removeAllElements();
        }
        Vector v = (Vector)poolServices.clone();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            MQPoolServices ps = (MQPoolServices)((Object)e.nextElement());
            ps.fireDefaultConnectionManagerChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionManager getDefaultConnectionManager() {
        Vector vector = poolTokenSet;
        synchronized (vector) {
            return defaultCxManager;
        }
    }

    public static void addConnectionPoolToken(MQPoolToken token) {
        if (token == null) {
            throw new NullPointerException(MQException.getNLSMsg((String)"MQNULLPOINTER", (String)"MQPoolToken"));
        }
        poolTokenSet.addElement(token);
        Vector v = (Vector)poolServices.clone();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            MQPoolServices ps = (MQPoolServices)((Object)e.nextElement());
            ps.fireTokenAdded(token);
        }
    }

    public static MQPoolToken addConnectionPoolToken() {
        MQPoolToken token = new MQPoolToken();
        poolTokenSet.addElement(token);
        Vector v = (Vector)poolServices.clone();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            MQPoolServices ps = (MQPoolServices)((Object)e.nextElement());
            ps.fireTokenAdded(token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnectionPoolToken(MQPoolToken token) {
        if (token == null) {
            throw new NullPointerException(MQException.getNLSMsg((String)"MQNULLPOINTER", (String)"MQPoolToken"));
        }
        boolean fire = false;
        Vector vector = poolTokenSet;
        synchronized (vector) {
            int oldSize = poolTokenSet.size();
            poolTokenSet.removeElement((Object)token);
            if (poolTokenSet.size() < oldSize) {
                fire = true;
            }
        }
        if (fire) {
            Vector v = (Vector)poolServices.clone();
            Enumeration e = v.elements();
            while (e.hasMoreElements()) {
                MQPoolServices ps = (MQPoolServices)((Object)e.nextElement());
                ps.fireTokenRemoved(token);
            }
        }
    }

    public static Thread createThread(Runnable r, boolean daemon) throws SecurityException {
        return MQEnvironment.createThread(r, null, daemon);
    }

    public static Thread createThread(final Runnable r, final String name, final boolean daemon) throws SecurityException {
        Thread t = null;
        Thread thread = t = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Thread t2 = new Thread(r, name);
                t2.setDaemon(daemon);
                return t2;
            }
        });
        return thread;
    }

    public static boolean runningInWS() {
        return runningInWebSphere;
    }

    public static boolean forceAllowClientConnection() {
        return forceAllowClient;
    }

    public static MQQueueManager getQueueManagerReference(int scope) {
        return MQEnvironment.getQueueManagerReference(scope, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MQQueueManager getQueueManagerReference(int scope, Object context) {
        MQQueueManager mgr = null;
        Hashtable<String, Integer> h = new Hashtable<String, Integer>();
        if (scope != 8 && scope != 32 && scope != 0) {
            MQQueueManager mQQueueManager = null;
            return mQQueueManager;
        }
        h.put("QMgr_Association", new Integer(~scope));
        try {
            if (context == null) {
                mgr = new MQQueueManager(null, h);
            } else if (context instanceof String) {
                mgr = new MQQueueManager((String)context, h);
            }
        }
        catch (MQException me) {}
        return mgr;
    }

    protected static final String stringFromBytes(byte[] bData) {
        String retVal;
        try {
            JmqiEnvironment env = MQSESSION.getJmqiEnv();
            JmqiCodepage cp = env.getNativeCharSet();
            retVal = new String(bData, cp.charsetId);
        }
        catch (UnsupportedEncodingException ex) {
            retVal = new String(bData);
        }
        return retVal;
    }

    protected static final byte[] bytesFromString(String aValue) {
        byte[] retVal = null;
        try {
            JmqiEnvironment env = MQSESSION.getJmqiEnv();
            JmqiCodepage cp = env.getNativeCharSet();
            retVal = aValue.getBytes(cp.charsetId);
        }
        catch (UnsupportedEncodingException ex) {
            retVal = aValue.getBytes();
        }
        return retVal;
    }

    static void registerPoolServices(MQPoolServices ps) {
        poolServices.addElement(ps);
    }

    static void deregisterPoolServices(MQPoolServices ps) {
        poolServices.removeElement((Object)ps);
    }

    static Object getDefaultProperty(Object key) {
        Object property = properties.get(key);
        if (property == null) {
            if (key.equals("CCSID")) {
                property = new Integer(CCSID);
            }
            if (key.equals("channel")) {
                property = channel;
            }
            if (key.equals("connectOptions")) {
                property = new Integer(connOptions);
            }
            if (key.equals("hostname")) {
                property = hostname;
            }
            if (key.equals("password")) {
                property = password;
            }
            if (key.equals("port")) {
                property = new Integer(port);
            }
            if (key.equals("receiveExit")) {
                property = receiveExit;
            }
            if (key.equals("channelReceiveExit")) {
                property = channelReceiveExit;
            }
            if (key.equals("securityExit")) {
                property = securityExit;
            }
            if (key.equals("channelSecurityExit")) {
                property = channelSecurityExit;
            }
            if (key.equals("sendExit")) {
                property = sendExit;
            }
            if (key.equals("channelSendExit")) {
                property = channelSendExit;
            }
            if (key.equals("receiveExitUserData")) {
                property = receiveExitUserData;
            }
            if (key.equals("channelReceiveExitUserData")) {
                property = channelReceiveExitUserData;
            }
            if (key.equals("securityExitUserData")) {
                property = securityExitUserData;
            }
            if (key.equals("channelSecurityExitUserData")) {
                property = channelSecurityExitUserData;
            }
            if (key.equals("securityExitUserData")) {
                property = securityExitUserData;
            }
            if (key.equals("sendExitUserData")) {
                property = sendExitUserData;
            }
            if (key.equals("channelSendExitUserData")) {
                property = channelSendExitUserData;
            }
            if (key.equals("transport")) {
                property = "MQSeries";
            }
            if (key.equals("userID")) {
                property = userID;
            }
            if (key.equals("SSL Cipher Suite")) {
                property = sslCipherSuite;
            }
            if (key.equals("SSL Peer Name")) {
                property = sslPeerName;
            }
            if (key.equals("SSL CertStores")) {
                property = sslCertStores;
            }
            if (key.equals("SSL Socket Factory")) {
                property = sslSocketFactory;
            }
            if (key.equals("Local Address Property")) {
                property = localAddressSetting;
            }
            if (key.equals("Header Compression Property")) {
                property = hdrCompList;
            }
            if (key.equals("Message Compression Property")) {
                property = msgCompList;
            }
            if (key.equals("ConnTag Property")) {
                property = connTag;
            }
            if (key.equals("KeyResetCount")) {
                property = new Integer(sslResetCount);
            }
            if (key.equals("SSL Fips Required")) {
                property = new Boolean(sslFipsRequired);
            }
            if (key.equals("sharingConversations")) {
                property = new Integer(sharingConversations);
            }
        }
        return property;
    }

    static Object getObjectProperty(String key, Hashtable properties) {
        Object property = null;
        if (properties != null) {
            property = properties.get(key);
        }
        if (property == null) {
            property = MQEnvironment.getDefaultProperty(key);
        }
        return property;
    }

    static String getStringProperty(String key, Hashtable properties) {
        Object object = MQEnvironment.getObjectProperty(key, properties);
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    static int getIntegerProperty(String key, Hashtable properties) {
        Object object = MQEnvironment.getObjectProperty(key, properties);
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return 0;
    }

    static boolean getXaClientEnabled() {
        return xaClientEnabled;
    }

    static int getXaLicenseMsg() {
        return xaLicenseMsg;
    }

    static void setXaLicenseMsg(int newValue) {
        xaLicenseMsg = newValue;
    }

    public static void traceSystemProperties() {
    }

    static {
        try {
            Class.forName("com.ibm.mq.OSE");
        }
        catch (Exception e) {
            // empty catch block
        }
        String fwprop = (String)AccessController.doPrivileged(new PrivilegedActionImpl());
        if (fwprop != null && !fwprop.trim().equals("")) {
            localAddressSetting = fwprop;
        }
        CommonServices.setWMQJavaTraceClass((Class)MQEnvironment.class);
    }

    private static class PrivilegedActionImpl
    implements PrivilegedAction {
        private PrivilegedActionImpl() {
        }

        public Object run() {
            try {
                return System.getProperty("com.ibm.mq.localAddress");
            }
            catch (AccessControlException ace) {
                return "";
            }
        }
    }
}

