/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq;

import com.ibm.mq.MQSESSION;
import com.ibm.mq.jmqi.JmqiObject;
import java.util.GregorianCalendar;
import java.util.TimeZone;

class MQDateConverter
extends JmqiObject {
    static final String sccsid = "@(#) com.ibm.mq/src/com/ibm/mq/MQDateConverter.java, java.classes, k700, k700-L080529 1.32.1.1 08/06/01 08:54:02";
    static final String copyright_notice = "Licensed Materials - Property of IBM 5724-H72, 5655-R36, 5724-L26, 5655-L82                (c) Copyright IBM Corp. 2008 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private GregorianCalendar calendar = null;
    private long[] millisAtMonthStart;
    private int firstMonthInTable;
    private static MQDateConverter instance = null;

    private MQDateConverter() {
        super(MQSESSION.getJmqiEnv());
        int traceContext = 0;
        int fid = 84;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 84);
        }
        this.calendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        this.calendar.set(14, 0);
        this.firstMonthInTable = this.calendar.get(2) > 6 ? (this.calendar.get(1) - 1970) * 12 : (this.calendar.get(1) - 1970) * 12 - 6;
        this.millisAtMonthStart = new long[12];
        for (int i = this.firstMonthInTable; i < this.firstMonthInTable + 12; ++i) {
            this.calendar.set(i / 12 + 1970, i % 12, 1, 0, 0, 0);
            this.millisAtMonthStart[i - this.firstMonthInTable] = this.calendar.getTime().getTime();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 84);
        }
    }

    private void updateTable() {
        int i;
        int traceContext = 0;
        int fid = 85;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 85);
        }
        for (i = 6; i < 12; ++i) {
            this.millisAtMonthStart[i - 6] = this.millisAtMonthStart[i];
        }
        this.calendar.set(14, 0);
        this.firstMonthInTable += 6;
        for (i = this.firstMonthInTable + 6; i < this.firstMonthInTable + 12; ++i) {
            this.calendar.set(i / 12 + 1970, i % 12, 1, 0, 0, 0);
            this.millisAtMonthStart[i - this.firstMonthInTable] = this.calendar.getTime().getTime();
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 85);
        }
    }

    private long fastDateToMillis(byte[] time, byte[] date) {
        int traceContext = 0;
        int fid = 86;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 86, new Object[]{time, date});
        }
        int dateYear = (date[0] - 48) * 1000 + (date[1] - 48) * 100 + (date[2] - 48) * 10 + (date[3] - 48);
        int dateMonth = (date[4] - 48) * 10 + (date[5] - 48);
        long dateDay = (date[6] - 48) * 10 + (date[7] - 48);
        long timeHour = (time[0] - 48) * 10 + (time[1] - 48);
        long timeMinute = (time[2] - 48) * 10 + (time[3] - 48);
        long timeSecond = (time[4] - 48) * 10 + (time[5] - 48);
        long timeMillis = (time[6] - 48) * 100 + (time[7] - 48) * 10;
        int monthsSince1970 = (dateYear - 1970) * 12 + dateMonth;
        long retValue = 0L;
        if (monthsSince1970 > this.firstMonthInTable + 12) {
            if (this.trace.isOn) {
                this.trace.dataFmt(this.env, COMP_JN, 86, "date beyond last in table", (Object)"");
            }
            if (System.currentTimeMillis() > this.millisAtMonthStart[11]) {
                this.updateTable();
                retValue = monthsSince1970 > this.firstMonthInTable + 12 ? this.slowDateToMillis(dateYear, dateMonth, dateDay, timeHour, timeMinute, timeSecond, timeMillis) : this.millisAtMonthStart[monthsSince1970 - this.firstMonthInTable - 1] + (dateDay - 1L) * 86400000L + timeHour * 3600000L + timeMinute * 60000L + timeSecond * 1000L + timeMillis;
            } else {
                retValue = this.slowDateToMillis(dateYear, dateMonth, dateDay, timeHour, timeMinute, timeSecond, timeMillis);
            }
        } else {
            retValue = monthsSince1970 > this.firstMonthInTable ? this.millisAtMonthStart[monthsSince1970 - this.firstMonthInTable - 1] + (dateDay - 1L) * 86400000L + timeHour * 3600000L + timeMinute * 60000L + timeSecond * 1000L + timeMillis : this.slowDateToMillis(dateYear, dateMonth, dateDay, timeHour, timeMinute, timeSecond, timeMillis);
        }
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 86, (Object)new Long(retValue));
        }
        return retValue;
    }

    private long slowDateToMillis(int year, int month, long day, long hour, long minute, long second, long millis) {
        int traceContext = 0;
        int fid = 87;
        if (this.trace.isOn) {
            traceContext = this.trace.entry_OO((Object)this, COMP_JN, 87, new Object[]{new Integer(year), new Integer(month), new Long(day), new Long(hour), new Long(minute), new Long(second), new Long(millis)});
        }
        this.calendar.set(year, month - 1, (int)day, (int)hour, (int)minute, (int)second);
        this.calendar.set(14, (int)millis);
        long traceRet1 = this.calendar.getTime().getTime();
        if (this.trace.isOn) {
            this.trace.exit(traceContext, (Object)this, COMP_JN, 87, (Object)new Long(traceRet1));
        }
        return traceRet1;
    }

    public static synchronized long mqDateTimeToMillis(byte[] time, byte[] date) {
        return instance.fastDateToMillis(time, date);
    }

    public static synchronized long mqDateTimeToMillis(String time, String date) {
        return instance.fastDateToMillis(time.getBytes(), date.getBytes());
    }

    static {
        instance = new MQDateConverter();
    }
}

