/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Hash;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.crypto.pkcs11impl.provider.Signature;
import com.ibm.misc.Debug;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;

final class GeneralSignatureSingleRSA
extends SignatureSpi {
    static final String MD2_RSA = "1.2.840.113549.2.2";
    static final String MD5_RSA = "1.2.840.113549.2.5";
    static final String SHA1_RSA = "1.3.14.3.2.26";
    static final String SHA256_RSA = "2.16.840.1.101.3.4.2.1";
    static final String SHA384_RSA = "2.16.840.1.101.3.4.2.2";
    static final String SHA512_RSA = "2.16.840.1.101.3.4.2.3";
    private Signature sig;
    private Hash hash;
    String oid;
    PrivateKey privateKey;
    PublicKey publicKey;
    private boolean reset = false;
    private boolean initialized;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralSignatureSingleRSA";
    private SessionManager sessionManager;

    public GeneralSignatureSingleRSA(Provider provider, String algorithm) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (debug != null) {
            debug.entry(16384L, (Object)className, "GeneralSignatureSingleRSA");
        }
        int mechanism = 0;
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        if (algorithm.equalsIgnoreCase("MD2withRSA")) {
            mechanism = 4;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(512, this.sessionManager);
            this.oid = MD2_RSA;
        } else if (algorithm.equalsIgnoreCase("MD5withRSA")) {
            mechanism = 5;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(528, this.sessionManager);
            this.oid = MD5_RSA;
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            mechanism = 6;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(544, this.sessionManager);
            this.oid = SHA1_RSA;
        } else if (algorithm.equalsIgnoreCase("SHA256withRSA")) {
            mechanism = 64;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(592, this.sessionManager);
            this.oid = SHA256_RSA;
        } else if (algorithm.equalsIgnoreCase("SHA384withRSA")) {
            mechanism = 65;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(608, this.sessionManager);
            this.oid = SHA384_RSA;
        } else if (algorithm.equalsIgnoreCase("SHA512withRSA")) {
            mechanism = 66;
            this.sig = new Signature(1, provider);
            this.hash = new Hash(624, this.sessionManager);
            this.oid = SHA512_RSA;
        } else {
            throw new NoSuchAlgorithmException(algorithm + " is not found");
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "GeneralSignatureSingleRSA");
        }
    }

    @Override
    protected void engineSetParameter(String key, Object param) {
    }

    @Override
    protected Object engineGetParameter(String key) {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        this.privateKey = privateKey;
        if (this.reset) {
            this.hash.engineReset();
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.publicKey = publicKey;
        if (this.reset) {
            this.hash.engineReset();
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        byte[] onebyte = new byte[]{b};
        this.hash.engineUpdate(onebyte, 0, 1);
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) {
        this.hash.engineUpdate(data, off, len);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        Object[] value;
        byte[] result = this.hash.engineDigest();
        DerOutputStream out = null;
        try {
            out = new DerOutputStream();
            DerOutputStream out1 = new DerOutputStream();
            AlgorithmId algid = AlgorithmId.getAlgorithmId((String)this.oid);
            algid.encode(out1);
            value = new DerValue[]{new DerValue(out1.toByteArray()), new DerValue(4, result)};
            out.putSequence(value);
        }
        catch (IOException e) {
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException ee) {
            throw new SignatureException("error encoding signature");
        }
        byte[] digest = out.toByteArray();
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            this.sig.engineInitSign(session, this.privateKey);
            this.reset = true;
            value = this.sig.engineSign(session, digest, digest.length);
            return value;
        }
        catch (InvalidKeyException ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)"GeneralSignatureSingleRSA", "engineSign", (Throwable)ex);
            }
            throw new SignatureException(ex);
        }
        finally {
            if (session != null) {
                this.sessionManager.releaseSession(session);
            }
        }
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        byte[] result = this.hash.engineDigest();
        DerOutputStream out = null;
        try {
            out = new DerOutputStream();
            DerOutputStream out1 = new DerOutputStream();
            AlgorithmId algid = AlgorithmId.getAlgorithmId((String)this.oid);
            algid.encode(out1);
            DerValue[] value = new DerValue[]{new DerValue(out1.toByteArray()), new DerValue(4, result)};
            out.putSequence(value);
        }
        catch (IOException e) {
            throw new SignatureException("error encoding signature");
        }
        catch (NoSuchAlgorithmException ee) {
            throw new SignatureException("error encoding signature");
        }
        byte[] digest = out.toByteArray();
        Session session = null;
        try {
            session = this.sessionManager.getOpSession();
            this.sig.engineInitVerify(session, this.publicKey);
            this.reset = true;
            boolean value = this.sig.engineVerify(session, signature, digest, digest.length);
            return value;
        }
        catch (InvalidKeyException ex) {
            if (debug != null) {
                debug.exception(16384L, (Object)"GeneralSignatureSingleRSA", "engineVerify", (Throwable)ex);
            }
            throw new SignatureException(ex);
        }
        finally {
            if (session != null) {
                this.sessionManager.releaseSession(session);
            }
        }
    }
}

