/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DESPKCS11KeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.DESedePKCS11KeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.GeneralKey;
import com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilderImpl;
import com.ibm.crypto.pkcs11impl.provider.PKCS11SecretKeyParameterSpec;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.misc.Debug;
import com.ibm.pkcs11.PKCS11Object;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class GeneralPKCS11KeyGenerator
extends KeyGeneratorSpi {
    private SessionManager sessionManager = null;
    private Config config = null;
    private byte[] id = null;
    private String label = null;
    private Boolean isToken = null;
    private Boolean isSensitive = null;
    private Boolean encrypt = null;
    private Boolean wrapping = null;
    private Boolean extractable = null;
    private boolean keySpecUsed = false;
    private int keySize = 0;
    private KeyMechanismBuilder mechanismBuilder;
    private static Debug debug = Debug.getInstance((String)"pkcs11impl");
    private static String className = "com.ibm.crypto.pkcs11impl.provider.GeneralPKCS11KeyGenerator";

    public GeneralPKCS11KeyGenerator(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
        this.mechanismBuilder = MechanismBuilderImpl.createKeyMechanismBuilder(algorithm);
    }

    @Override
    protected void engineInit(SecureRandom random) {
        this.keySize = this.mechanismBuilder.getDefaultKeySize() / 8;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (params == null || !(params instanceof PKCS11SecretKeyParameterSpec)) {
            throw new InvalidAlgorithmParameterException("PKCS11 Secret Key Parameters must be specified");
        }
        PKCS11SecretKeyParameterSpec spec = (PKCS11SecretKeyParameterSpec)params;
        try {
            this.id = spec.getKeyID().getBytes("8859_1");
        }
        catch (Exception e) {
            this.id = spec.getKeyID().getBytes();
        }
        this.label = spec.getLabel();
        this.isToken = spec.getToken();
        this.isSensitive = spec.getSensitive();
        this.encrypt = spec.getEncrypt();
        this.wrapping = spec.getWrap();
        this.extractable = spec.getExtractable();
        if (params instanceof GeneralPKCS11KeyParameterSpec) {
            GeneralPKCS11KeyParameterSpec gSpec = (GeneralPKCS11KeyParameterSpec)params;
            if (gSpec.getKeyType() != this.mechanismBuilder.getKeyType()) throw new InvalidAlgorithmParameterException("The Secret Key type must be " + this.mechanismBuilder.getAlgorithm());
            this.keySize = gSpec.getKeySizeInBytes();
        } else if (params instanceof DESPKCS11KeyParameterSpec) {
            this.keySize = 8;
        } else if (params instanceof DESedePKCS11KeyParameterSpec) {
            this.keySize = 24;
        }
        this.keySpecUsed = true;
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        int mechanism = this.mechanismBuilder.getMechanism();
        switch (mechanism) {
            case 288: {
                if (keysize == 64) break;
                throw new InvalidParameterException("DES key length must be 64 bits");
            }
            case 305: {
                if (keysize == 192) break;
                throw new InvalidParameterException("DESede key length must be 192 bits");
            }
            case 4224: {
                if (keysize == 128 || keysize == 192 || keysize == 256) break;
                throw new InvalidParameterException("AES key length must be 128, 192, or 256 bits");
            }
            case 272: {
                if (keysize >= 40 && keysize <= 1024) break;
                throw new InvalidParameterException("ARCFOUR key length must be between 40 and 1024 bits");
            }
            case 4240: {
                if (keysize >= 40 && keysize <= 448) break;
                throw new InvalidParameterException("Blowfish key length must be between 40 and 448 bits");
            }
        }
        this.keySize = keysize / 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected SecretKey engineGenerateKey() {
        GeneralKey genKey;
        PKCS11Object obj = null;
        HashMap<Integer, Object> hattrs = new HashMap<Integer, Object>();
        if (this.config != null) {
            hattrs.putAll(this.config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, this.mechanismBuilder.getKeyType()));
        } else if (!this.keySpecUsed) {
            this.isToken = new Boolean(false);
            this.isSensitive = new Boolean(false);
            this.encrypt = new Boolean(true);
            this.wrapping = new Boolean(true);
        }
        if (this.id != null) {
            hattrs.put(258, this.id);
        }
        if (this.label != null) {
            hattrs.put(3, this.label);
        }
        if (this.isToken != null) {
            hattrs.put(1, this.isToken);
        }
        if (this.isSensitive != null) {
            hattrs.put(259, this.isSensitive);
        }
        if (this.encrypt != null) {
            hattrs.put(260, this.encrypt);
            hattrs.put(261, this.encrypt);
        }
        if (this.wrapping != null) {
            hattrs.put(262, this.wrapping);
            hattrs.put(263, this.wrapping);
        }
        if (this.extractable != null) {
            hattrs.put(354, this.extractable);
        }
        if (this.keySize > 0) {
            hattrs.put(353, this.keySize);
        } else {
            this.engineInit(null);
            hattrs.put(353, this.keySize);
        }
        int[] attrTypes = new int[hattrs.size()];
        Object[] attrValues = new Object[hattrs.size()];
        Set keys = hattrs.keySet();
        Iterator it = keys.iterator();
        int count = 0;
        while (it.hasNext()) {
            Integer key = (Integer)it.next();
            attrTypes[count] = key;
            attrValues[count++] = hattrs.get(key);
            if (debug == null) continue;
            debug.text(16384L, (Object)className, "engineGenerateKey_0.5", "attrType = " + attrTypes[count - 1]);
            debug.text(16384L, (Object)className, "engineGenerateKey_0.5", "attrValue = " + attrValues[count - 1]);
        }
        Session session = null;
        try {
            session = this.sessionManager.getObjSession();
            obj = session.generateKey(this.mechanismBuilder.getMechanism(), null, attrTypes, attrValues);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(16384L, (Object)className, "engineGenerateKey_1", (Throwable)e);
            }
            this.sessionManager.releaseSession(session);
            throw new RuntimeException(e.getMessage());
        }
        try {
            genKey = new GeneralKey(session, obj, this.mechanismBuilder.getAlgorithm());
            if (!session.getBoolAttributeValue(obj, 1)) {
                session.addObject();
                genKey.setSession(session);
            }
        }
        catch (Exception e) {
            genKey = null;
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
        return genKey;
    }

    private Object getValue(PKCS11Object pkcs11obj, int attr) {
        Object rtn;
        if (debug != null) {
            debug.entry(16384L, (Object)className, "getValue", (Object)pkcs11obj, (Object)new Integer(attr));
        }
        try {
            rtn = pkcs11obj.getAttributeValue(attr);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)className, "getValue", e.getMessage());
            }
            rtn = null;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)className, "getValue");
        }
        return rtn;
    }
}

