/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.Config;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11KeyFactory;
import com.ibm.crypto.pkcs11impl.provider.DHPKCS11PrivateKey;
import com.ibm.crypto.pkcs11impl.provider.IBMPKCS11Impl;
import com.ibm.crypto.pkcs11impl.provider.Session;
import com.ibm.crypto.pkcs11impl.provider.SessionManager;
import com.ibm.pkcs11.PKCS11Object;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.SecretKeySpec;

public final class DHPKCS11KeyAgreement
extends KeyAgreementSpi {
    private SessionManager sessionManager = null;
    private Provider provider = null;
    private Config config = null;
    private BigInteger P = null;
    private BigInteger G = null;
    private BigInteger Y = null;
    private PKCS11Object p11ObjX = null;
    private int secretLen = 0;

    public DHPKCS11KeyAgreement(Provider provider, String algorithm) {
        IBMPKCS11Impl.verifyJceJar();
        this.provider = provider;
        this.sessionManager = ((IBMPKCS11Impl)provider).getSessionManager();
        this.config = ((IBMPKCS11Impl)provider).getConfig();
    }

    public DHPKCS11KeyAgreement(Provider provider) {
        this(provider, null);
    }

    @Override
    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof DHPrivateKey)) {
            throw new InvalidKeyException("Only DH PrivateKeys expected.");
        }
        DHPKCS11KeyFactory factory = new DHPKCS11KeyFactory(this.provider);
        DHPKCS11PrivateKey p11Private = (DHPKCS11PrivateKey)factory.engineTranslateKey(key);
        this.p11ObjX = p11Private.getObject();
        this.P = p11Private.getParams().getP();
        this.G = p11Private.getParams().getG();
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not supported");
        }
        this.engineInit(key, random);
    }

    @Override
    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (!(key instanceof DHPublicKey)) {
            throw new InvalidKeyException("Diffie-Hellman public key expected");
        }
        DHPublicKey dhPubKey = (DHPublicKey)key;
        if (this.P == null || this.G == null) {
            throw new IllegalStateException("Not initialized");
        }
        if (!lastPhase) {
            // empty if block
        }
        BigInteger pub_p = dhPubKey.getParams().getP();
        BigInteger pub_g = dhPubKey.getParams().getG();
        if (pub_p != null && !this.P.equals(pub_p)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        if (pub_g != null && !this.G.equals(pub_g)) {
            throw new InvalidKeyException("Incompatible parameters");
        }
        this.Y = dhPubKey.getY();
        this.secretLen = this.P.bitLength() + 7 >> 3;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        HashMap<Integer, Object> attributes = new HashMap<Integer, Object>();
        attributes.put(0, PKCS11Object.SECRET_KEY);
        attributes.put(256, PKCS11Object.GENERIC_SECRET);
        attributes.put(353, this.secretLen);
        if (this.config != null) {
            attributes.putAll(this.config.getAttributes("GENERATE", PKCS11Object.SECRET_KEY, PKCS11Object.GENERIC_SECRET));
        }
        int[] secretKeyTypes = new int[attributes.size()];
        Object[] secretKeyValues = new Object[attributes.size()];
        Iterator it = attributes.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            secretKeyTypes[i] = (Integer)entry.getKey();
            secretKeyValues[i++] = entry.getValue();
        }
        Session session = this.sessionManager.getOpSession();
        byte[] secret = null;
        try {
            PKCS11Object generatedSecret = session.deriveKey(33, this.Y, this.p11ObjX, secretKeyTypes, secretKeyValues);
            secret = (byte[])session.getAttrValue(generatedSecret, 17);
            session.destroyObject(generatedSecret);
        }
        finally {
            this.sessionManager.releaseSession(session);
        }
        return secret;
    }

    @Override
    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        if (sharedSecret == null) {
            throw new ShortBufferException("No buffer provided for shared secret");
        }
        byte[] secret = this.engineGenerateSecret();
        if (secret.length << 3 != this.P.bitLength()) {
            if (sharedSecret.length - offset < secret.length - 1) {
                throw new ShortBufferException("Buffer too short for shared secret");
            }
            System.arraycopy(secret, 1, sharedSecret, offset, secret.length - 1);
            return secret.length - 1;
        }
        if (sharedSecret.length - offset < secret.length) {
            throw new ShortBufferException("Buffer too short to hold shared secret");
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    @Override
    protected SecretKey engineGenerateSecret(String algorithm) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        int keyLen;
        if (algorithm == null) {
            return null;
        }
        byte[] secret = this.engineGenerateSecret();
        if (algorithm.equalsIgnoreCase("DES")) {
            keyLen = 8;
        } else if (algorithm.equalsIgnoreCase("DESede")) {
            keyLen = 24;
        } else if (algorithm.equalsIgnoreCase("Blowfish")) {
            keyLen = Math.min(56, secret.length);
        } else if (algorithm.equalsIgnoreCase("AES")) {
            keyLen = secret.length >= 32 ? 32 : 16;
        } else {
            throw new NoSuchAlgorithmException("Unknown algorithm " + algorithm);
        }
        if (secret.length < keyLen) {
            throw new InvalidKeyException("Secret too short");
        }
        return new SecretKeySpec(secret, 0, keyLen, algorithm);
    }
}

