/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDIdentityConstraintDefinition;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDInclude;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDNotationDeclaration;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDRedefine;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTerm;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.XSDXPathDefinition;
import org.eclipse.xsd.util.XSDResourceFactoryImpl;
import org.w3c.dom.Element;

public abstract class XSDSchemaBuildingTools {
    protected static XSDPackage m_xsdPackage = null;
    protected static XSDFactory m_xsdFactory = null;

    public static XSDSimpleTypeDefinition addSimpleTypeDefinition(XSDSchema schema, String localName, String type, String userInfo) {
        if (schema == null || localName == null || type == null) {
            throw new IllegalArgumentException("addSimpleTypeDefinition called with null schema/type/name");
        }
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDSimpleTypeDefinition simpleType = xsdFactory.createXSDSimpleTypeDefinition();
        simpleType.setName(localName);
        simpleType.setBaseTypeDefinition(schema.resolveSimpleTypeDefinition(type));
        schema.getContents().add(simpleType);
        if (userInfo != null) {
            XSDSchemaBuildingTools.addUserInformation(simpleType, null, userInfo);
        }
        return simpleType;
    }

    public static XSDComplexTypeDefinition addComplexTypeDefinition(XSDSchema schema, String localName, String type, HashMap attrs, String userInfo) {
        if (schema == null || localName == null || type == null) {
            throw new IllegalArgumentException("addComplexTypeDefinition called with null schema/type/name");
        }
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDComplexTypeDefinition complexType = xsdFactory.createXSDComplexTypeDefinition();
        complexType.setName(localName);
        complexType.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        schema.getContents().add(complexType);
        XSDSimpleTypeDefinition anonSimpleType = xsdFactory.createXSDSimpleTypeDefinition();
        complexType.setBaseTypeDefinition(schema.resolveSimpleTypeDefinition(type));
        complexType.setContent(anonSimpleType);
        if (attrs != null) {
            Iterator iter = attrs.keySet().iterator();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                Object attrType = attrs.get(attrName);
                XSDSchemaBuildingTools.addAttributeDeclaration(complexType, attrName, attrType);
            }
        }
        if (userInfo != null) {
            XSDSchemaBuildingTools.addUserInformation(complexType, null, userInfo);
        }
        return complexType;
    }

    public static XSDAttributeDeclaration addAttributeDeclaration(XSDConcreteComponent component2, String localName, Object type) {
        if (component2 == null || localName == null || type == null) {
            throw new IllegalArgumentException("addAttributeDeclaration called with null component/type/name");
        }
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDAttributeDeclaration attrDecl = xsdFactory.createXSDAttributeDeclaration();
        attrDecl.setName(localName);
        if (type instanceof XSDAttributeDeclaration) {
            attrDecl.setResolvedAttributeDeclaration((XSDAttributeDeclaration)type);
        } else if (type instanceof String) {
            attrDecl.setTypeDefinition(component2.getSchema().resolveSimpleTypeDefinition((String)type));
        } else {
            throw new IllegalArgumentException("addAttributeDeclaration illegal type, is: " + type);
        }
        if (component2 instanceof XSDSchema) {
            ((XSDSchema)component2).getContents().add(attrDecl);
        } else if (component2 instanceof XSDComplexTypeDefinition) {
            XSDAttributeUse attrUse = xsdFactory.createXSDAttributeUse();
            attrUse.setContent(attrDecl);
            ((XSDComplexTypeDefinition)component2).getAttributeContents().add(attrUse);
        } else {
            throw new IllegalArgumentException("Unable to addAttributeDeclaration to type: " + component2);
        }
        return attrDecl;
    }

    public static XSDAnnotation addUserInformation(XSDConcreteComponent component2, String sourceURI, String text) {
        if (component2 == null || text == null) {
            throw new IllegalArgumentException("addUserInformation called with null component or text");
        }
        try {
            XSDFactory xsdFactory = XSDFactory.eINSTANCE;
            XSDAnnotation xsdAnnotation = xsdFactory.createXSDAnnotation();
            if (component2 instanceof XSDAttributeDeclaration) {
                ((XSDAttributeDeclaration)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDAttributeGroupDefinition) {
                ((XSDAttributeGroupDefinition)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDElementDeclaration) {
                ((XSDElementDeclaration)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDFacet) {
                ((XSDFacet)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDIdentityConstraintDefinition) {
                ((XSDIdentityConstraintDefinition)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDImport) {
                ((XSDImport)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDInclude) {
                ((XSDInclude)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDModelGroup) {
                ((XSDModelGroup)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDModelGroupDefinition) {
                ((XSDModelGroupDefinition)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDNotationDeclaration) {
                ((XSDNotationDeclaration)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDTypeDefinition) {
                ((XSDTypeDefinition)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDWildcard) {
                ((XSDWildcard)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDXPathDefinition) {
                ((XSDXPathDefinition)component2).setAnnotation(xsdAnnotation);
            } else if (component2 instanceof XSDSchema) {
                ((XSDSchema)component2).getContents().add(xsdAnnotation);
            } else {
                throw new IllegalArgumentException("Unable to addUserInformation onto type: " + component2);
            }
            Element userInfo = xsdAnnotation.createUserInformation(sourceURI);
            userInfo.appendChild(userInfo.getOwnerDocument().createTextNode(text));
            xsdAnnotation.getElement().appendChild(userInfo);
            return xsdAnnotation;
        }
        catch (Exception e) {
            System.err.println("addUserInformation threw an Exception:");
            e.printStackTrace();
            return null;
        }
    }

    public static XSDModelGroup addModelGroupDefinition(XSDConcreteComponent component2, String localName, XSDCompositor compositor, List groupTerms) {
        if (component2 == null || localName == null || groupTerms == null) {
            throw new IllegalArgumentException("addModelGroupDefinition called with null component/name/list");
        }
        XSDFactory xsdFactory = XSDFactory.eINSTANCE;
        XSDModelGroup modelGroup = xsdFactory.createXSDModelGroup();
        modelGroup.setCompositor(compositor);
        Iterator terms = groupTerms.iterator();
        while (terms.hasNext()) {
            Object tmp = terms.next();
            try {
                XSDTerm termItem = (XSDTerm)tmp;
                XSDParticle termParticle = xsdFactory.createXSDParticle();
                termParticle.setContent(termItem);
                modelGroup.getContents().add(termParticle);
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("addModelGroupDefinition illegal list type: " + tmp);
            }
        }
        if (component2 instanceof XSDComplexTypeDefinition) {
            XSDParticle modelGroupParticle = xsdFactory.createXSDParticle();
            modelGroupParticle.setContent(modelGroup);
            ((XSDComplexTypeDefinition)component2).setContent(modelGroupParticle);
        } else if (component2 instanceof XSDSchema) {
            XSDModelGroupDefinition modelGroupDef = xsdFactory.createXSDModelGroupDefinition();
            modelGroupDef.setName(localName);
            modelGroupDef.setModelGroup(modelGroup);
            ((XSDSchema)component2).getContents().add(modelGroupDef);
        } else if (component2 instanceof XSDModelGroupDefinition) {
            ((XSDModelGroupDefinition)component2).setModelGroup(modelGroup);
        } else if (component2 instanceof XSDModelGroup) {
            XSDParticle particle = xsdFactory.createXSDParticle();
            particle.setContent(modelGroup);
            ((XSDModelGroup)component2).getContents().add(particle);
        } else {
            throw new IllegalArgumentException("addModelGroupDefinition doesn't know how to add it to component: " + component2);
        }
        return modelGroup;
    }

    public static boolean removeTypeDefinition(XSDSchema schema, String namespace, String localName) {
        if (schema == null || localName == null) {
            throw new IllegalArgumentException("removeTypeDefinition called with null schema/localName");
        }
        XSDTypeDefinition typeDefinition = schema.resolveTypeDefinition(namespace, localName);
        XSDConcreteComponent container2 = typeDefinition.getContainer();
        if (container2 == null) {
            return false;
        }
        if (container2 instanceof XSDSchema) {
            return ((XSDSchema)container2).getContents().remove(typeDefinition);
        }
        if (container2 instanceof XSDRedefine) {
            return ((XSDRedefine)container2).getContents().remove(typeDefinition);
        }
        return false;
    }

    public static XSDSchema getBlankSchema(XSDFactory factory, String targetPrefix, String targetNS, String annotationText, String annotationSource) {
        if (factory == null) {
            factory = XSDSchemaBuildingTools.getXSDFactory();
        }
        XSDSchema schema = factory.createXSDSchema();
        schema.setTargetNamespace(targetNS);
        schema.setSchemaForSchemaQNamePrefix("xsd");
        Map namespaces = schema.getQNamePrefixToNamespaceMap();
        namespaces.put(targetPrefix, schema.getTargetNamespace());
        namespaces.put(schema.getSchemaForSchemaQNamePrefix(), "http://www.w3.org/2001/XMLSchema");
        if (annotationText != null) {
            XSDSchemaBuildingTools.addUserInformation(schema, annotationSource, annotationText);
        }
        return schema;
    }

    public static XSDFactory getXSDFactory() {
        if (m_xsdFactory != null) {
            return m_xsdFactory;
        }
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xsd", new XSDResourceFactoryImpl());
        m_xsdPackage = XSDPackage.eINSTANCE;
        m_xsdFactory = XSDFactory.eINSTANCE;
        return m_xsdFactory;
    }
}

