/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.compiler;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerNotAvailableException;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompilerPostProcessor;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.FastXPathClassGenerator;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerHelper;

public class CompilerHelper
implements ICompilerHelper {
    protected Class objectClass = null;
    protected String outputFilePath = null;
    protected String className = null;
    protected static boolean keepJavaFile = false;
    protected static final String VERBOSE_COMPILATION = "FXP_VERBOSE_COMPILATION";
    public static boolean verboseOutput;
    protected static FastXPathClassGenerator compiler;
    protected static HashMap classesAsByteArrays;
    protected char[] javaSource;
    protected StringBuffer sb = new StringBuffer();
    protected CompilerPostProcessor compilerPostProcessor;
    protected String returnTypeAndMethodName = "Object eval";
    protected String compiledExpressionEvaluatorExtension;
    protected String classComment;
    protected static final String DEFAULT_FILEPATH;
    protected static final int RETRY_COUNT = 10;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        classesAsByteArrays = new HashMap();
        keepJavaFile = verboseOutput = System.getProperty(VERBOSE_COMPILATION) != null;
        DEFAULT_FILEPATH = "." + File.separator;
    }

    public CompilerHelper(Class clas) {
        StringBuffer stringBuffer = new StringBuffer(" extends ");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.tptp.platform.provisional.fastxpath.compiler.CompiledExpressionEvaluator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.compiledExpressionEvaluatorExtension = stringBuffer.append(clazz.getName()).toString();
        this.objectClass = clas;
    }

    protected void writeJavaCode(StringBuffer sb, String expr, String classname) {
        sb.append("\n");
        sb.append("public class " + classname + this.compiledExpressionEvaluatorExtension + " {\n");
        StringBuffer stringBuffer = new StringBuffer("\tpublic ").append(this.returnTypeAndMethodName).append("(");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append(" object, ");
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.tptp.platform.provisional.fastxpath.IFastXPathEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        sb.append(stringBuffer2.append(clazz2.getName()).append(" ").append("fastXPathEngine").append(" ) {\n").toString());
        this.writeJavaBodyCode(sb, expr);
        sb.append("\t}\n");
        sb.append("}\n");
    }

    protected void writeJavaBodyCode(StringBuffer sb, String expr) {
        StringBuffer bodySB = new StringBuffer();
        bodySB.append("\t\t" + this.objectClass.getName() + " obj = (" + this.objectClass.getName() + ")object;" + "\n");
        bodySB.append("\t\t" + expr + "\n");
        sb.append(bodySB);
    }

    protected char[] getJavaSource(String compiledExpression, String xpathExpression, String cName) {
        StringBuffer sb = new StringBuffer();
        if (this.classComment == null) {
            sb.append("// This class has been auto generated for the XPath: \n");
            sb.append("// " + xpathExpression + "\n");
        } else {
            sb.append(this.classComment);
        }
        this.writeJavaCode(sb, compiledExpression, cName);
        return sb.toString().toCharArray();
    }

    public CompiledExpressionEvaluator getCompiledExpressionEvaluator(String compiledExpression, String xpathExpression) throws CodeGenerationError, CompilerNotAvailableException {
        Class compilerOutput = this.buildCompiledExpression(compiledExpression, xpathExpression, true);
        if (keepJavaFile) {
            String cName = this.className == null ? this.createClassName(xpathExpression) : this.className;
            String fileName = this.outputFilePath == null ? String.valueOf(DEFAULT_FILEPATH) + cName : String.valueOf(this.outputFilePath) + cName;
            fileName = fileName.concat(".java");
            try {
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File(fileName)));
                bw.write(this.javaSource);
                bw.close();
            }
            catch (IOException e2) {
                System.err.println("Error writing java file. Compilation successful!!!");
                e2.printStackTrace();
            }
        }
        try {
            return (CompiledExpressionEvaluator)compilerOutput.newInstance();
        }
        catch (Exception e) {
            throw new CodeGenerationError("Compiled class not found", e);
        }
    }

    public Class buildCompiledExpression(String compiledExpression, String xpathExpression, boolean cacheByteCode) throws CodeGenerationError, CompilerNotAvailableException {
        String cName;
        String string = cName = this.className == null ? this.createClassName(xpathExpression) : this.className;
        if (compiler == null) {
            CompilerHelper.initCompiler();
        }
        compiler.addClassLoader(this.objectClass.getClassLoader());
        this.javaSource = this.getJavaSource(compiledExpression, xpathExpression, cName);
        int retryCount = 10;
        while (retryCount-- > 0) {
            try {
                Class compilerOutput = compiler.generateClass(this.javaSource, cName);
                if (cacheByteCode) {
                    classesAsByteArrays.put(xpathExpression, compiler.getBytes());
                }
                return compilerOutput;
            }
            catch (CodeGenerationError error) {
                this.sb.setLength(0);
                this.sb.append(this.javaSource);
                this.compilerPostProcessor = this.compilerPostProcessor == null ? new CompilerPostProcessor("").setSb(this.sb) : this.compilerPostProcessor.setSb(this.sb);
                this.compilerPostProcessor.fixCompileError(error);
                this.javaSource = new CompilerPostProcessor(new String(this.javaSource)).fixCompileError(error);
                if (this.javaSource != null) continue;
                throw error;
            }
            catch (Exception e) {
                throw new CodeGenerationError("Compiled class not found", e);
            }
        }
        throw new CodeGenerationError("Cannot compile code for expression: " + xpathExpression);
    }

    /*
     * Exception decompiling
     */
    private static void initCompiler() throws CompilerNotAvailableException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [3 : 93->97)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String createClassName(String xpathExpression) {
        return "Compiled" + String.valueOf(Math.abs(xpathExpression.hashCode()));
    }

    public String getOutputFilePath() {
        return this.outputFilePath;
    }

    public void setOutputFilePath(String outputPath) {
        this.outputFilePath = outputPath.endsWith(File.separator) ? outputPath : outputPath.concat(File.separator);
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public Class getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class objectClass) {
        this.objectClass = objectClass;
    }

    public boolean isKeepJavaFile() {
        return keepJavaFile;
    }

    public void setKeepJavaFile(boolean keepFile) {
        keepJavaFile = keepFile;
    }

    public static HashMap getClassesAsByteArrays() {
        return classesAsByteArrays;
    }

    public static FastXPathClassGenerator getCompiler() throws CompilerNotAvailableException {
        if (compiler == null) {
            CompilerHelper.initCompiler();
        }
        return compiler;
    }

    public char[] getJavaSource() {
        return this.javaSource;
    }

    public String getReturnTypeAndMethodName() {
        return this.returnTypeAndMethodName;
    }

    public void setReturnTypeAndMethodName(String returnTypeAndMethodName) {
        this.returnTypeAndMethodName = returnTypeAndMethodName;
    }

    public String getCompiledExpressionEvaluatorExtension() {
        return this.compiledExpressionEvaluatorExtension;
    }

    public void setCompiledExpressionEvaluatorExtension(String compiledExpressionEvaluatorExtension) {
        this.compiledExpressionEvaluatorExtension = compiledExpressionEvaluatorExtension;
    }

    public String getClassComment() {
        return this.classComment;
    }

    public void setClassComment(String classComment) {
        this.classComment = classComment;
    }
}

