/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes;

import org.apache.xpath.Expression;
import org.apache.xpath.axes.PredicatedNodeTest;
import org.apache.xpath.patterns.NodeTest;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EExpression;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EExpressionFactory;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.patterns.ENodeTest;

public class EPredicatedNodeTest
extends ENodeTest {
    private PredicatedNodeTest node;
    protected IExpression[] ePredicates;
    protected int m_position = 0;

    public IExpression instance(Expression e) {
        return new EPredicatedNodeTest((PredicatedNodeTest)e);
    }

    public EPredicatedNodeTest(PredicatedNodeTest node) {
        super((NodeTest)node);
        this.node = node;
    }

    public void printGraph(int level) {
        super.printGraph(level);
        IExpression[] ePred = this.getEPredicates();
        int count = ePred.length;
        if (count > 0) {
            String indent = this.indent(level);
            int nextLevel = level + 1;
            int i = 0;
            while (i < count) {
                System.out.println(String.valueOf(indent) + "predicate [" + i + "]");
                ePred[i].printGraph(nextLevel);
                ++i;
            }
        }
    }

    public IExpression[] getEPredicates() {
        if (this.ePredicates == null) {
            int count = this.node.getPredicateCount();
            this.ePredicates = new EExpression[count];
            int i = 0;
            while (i < count) {
                this.ePredicates[i] = EExpressionFactory.INSTANCE.createEExprNode(this.node.getPredicate(i));
                ++i;
            }
        }
        return this.ePredicates;
    }

    public void setEPredicates(EExpression[] expressions) {
        this.ePredicates = expressions;
    }

    public static EPredicatedNodeTest getParentAsEPredicatedNodeTest(EExpression expr) {
        IExpression parent = expr.getParent();
        while (parent != null) {
            if (parent instanceof EPredicatedNodeTest) {
                return (EPredicatedNodeTest)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    public int getPosition() {
        return this.m_position + 1;
    }
}

