/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes;

import java.util.ArrayList;
import javax.xml.transform.TransformerException;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.DescendantIterator;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.objects.XBoolean;
import org.eclipse.tptp.platform.provisional.fastxpath.ExpressionEvaluationException;
import org.eclipse.tptp.platform.provisional.fastxpath.FastXPathContext;
import org.eclipse.tptp.platform.provisional.fastxpath.IExpression;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.CodeGenerationError;
import org.eclipse.tptp.platform.provisional.fastxpath.compiler.ICompilerContext;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.EExpression;
import org.eclipse.tptp.platform.provisional.jre14.fastxpath.axes.ELocPathIterator;

public class EDescendantIterator
extends ELocPathIterator {
    private DescendantIterator node;

    public void printGraph(int level) {
        String indent = this.indent(level);
        System.out.print(String.valueOf(indent) + "AXIS = " + this.getAxis(this.getAxis()));
        super.printGraph(level);
    }

    public IExpression instance(Expression e) {
        return new EDescendantIterator((DescendantIterator)e);
    }

    public EDescendantIterator(DescendantIterator node) {
        super((LocPathIterator)node);
        this.node = node;
    }

    public int getAxis() {
        return this.node.getAxis();
    }

    public void linkParent(EExpression parent) {
        super.linkParent(parent);
        int count = this.node.getPredicateCount();
        int i = 0;
        while (i < count) {
            this.getEPredicates()[i].linkParent(parent);
            ++i;
        }
    }

    public Object[] execute(FastXPathContext context) throws TransformerException, ExpressionEvaluationException {
        String name = this.getLocalName();
        if (!name.equals("")) {
            Object[] arr = context.getAll(name, 2, true);
            if (arr.length == 0) {
                return arr;
            }
            int count = this.node.getPredicateCount();
            if (count > 0) {
                ArrayList<Object> vec = new ArrayList<Object>();
                int i = 0;
                while (i < arr.length) {
                    vec.add(arr[i]);
                    ++i;
                }
                i = 0;
                while (i < vec.size()) {
                    int j = 0;
                    while (j < count) {
                        Object tmpObj = vec.get(i);
                        Object[] resultArr = this.getEPredicates()[j].execute(context.createContext(tmpObj));
                        if (resultArr.length == 0 || resultArr[0] instanceof XBoolean && !((XBoolean)resultArr[0]).bool()) {
                            vec.remove(i--);
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                return vec.toArray();
            }
            return arr;
        }
        return new Object[0];
    }

    public void compile(ICompilerContext compilationContext) throws CodeGenerationError {
        throw new CodeGenerationError("Unable to generate code for iterators");
    }
}

