/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.hyades.collection.framework.channel.DataChannelHelper;
import org.eclipse.hyades.collection.framework.channel.DataChannelImpl;
import org.eclipse.hyades.execution.core.DataChannelCreationException;
import org.eclipse.hyades.execution.core.InvalidDataChannelAccessException;
import org.eclipse.tptp.platform.agentcontroller.internal.ACStrings;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.CircularBuffer;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ExecutionPlugin;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class SharedMemoryCircularBufferInputStream
extends InputStream {
    private static boolean _isNativeAvailable = false;
    private int _dataChannelSize = ExecutionPlugin.getInstance().getInt(ACStrings.PREF_SHARED_MEMORY_SIZE);
    private CircularBuffer _buffer = new CircularBuffer(this._dataChannelSize * 1024 * 1024 / 4);
    private DataChannelImpl _dataChannel;

    static {
        try {
            System.loadLibrary("tptpShm");
            _isNativeAvailable = true;
        }
        catch (UnsatisfiedLinkError e1) {
            TPTPLoggerImpl.log(0, "Cannot load native library: " + e1.getMessage());
        }
        catch (SecurityException e2) {
            TPTPLoggerImpl.log(0, "Not allowed to load native library: " + e2.getMessage());
        }
    }

    public SharedMemoryCircularBufferInputStream(String name) {
        if (_isNativeAvailable) {
            DataChannelHelper helper = new DataChannelHelper();
            try {
                this._dataChannel = helper.createDataChannel(name, this._dataChannelSize * 1024 * 1024);
                this._dataChannel.setFlushable();
                this._dataChannel.startFlushingToStream(new OutputStream(){

                    public void write(int b) throws IOException {
                        byte[] bb = new byte[]{(byte)b};
                        if (SharedMemoryCircularBufferInputStream.this._buffer != null) {
                            SharedMemoryCircularBufferInputStream.this._buffer.write(bb, 0, bb.length);
                        }
                    }

                    public void write(byte[] b) throws IOException {
                        if (SharedMemoryCircularBufferInputStream.this._buffer != null) {
                            SharedMemoryCircularBufferInputStream.this._buffer.write(b, 0, b.length);
                        }
                    }

                    public void write(byte[] b, int off, int len) throws IOException {
                        if (SharedMemoryCircularBufferInputStream.this._buffer != null) {
                            SharedMemoryCircularBufferInputStream.this._buffer.write(b, off, len);
                        }
                    }

                    public void close() throws IOException {
                        while (SharedMemoryCircularBufferInputStream.this._buffer != null && SharedMemoryCircularBufferInputStream.this._buffer.available() > 0) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (SharedMemoryCircularBufferInputStream.this._buffer != null) {
                            SharedMemoryCircularBufferInputStream.this._buffer.destroy();
                            SharedMemoryCircularBufferInputStream.this._buffer = null;
                        }
                    }

                    public void flush() throws IOException {
                        super.flush();
                    }
                });
                TPTPLoggerImpl.log(3, "Created shared memory buffer: " + name + " of size: " + this._dataChannelSize + " MB");
            }
            catch (DataChannelCreationException e) {
                TPTPLoggerImpl.log(0, "Cannot create shared memory: " + name + ", " + e.getMessage());
            }
            catch (InvalidDataChannelAccessException e) {
                TPTPLoggerImpl.log(0, "Cannot change shared memory access to flushable: " + name + ", " + e.getMessage());
            }
        }
    }

    public int available() {
        if (this._buffer != null) {
            return this._buffer.available();
        }
        return 0;
    }

    public void close() {
        if (this._dataChannel != null) {
            this._dataChannel.stopFlushing();
            this._dataChannel.destroy();
            this._dataChannel = null;
        }
        if (this._buffer != null) {
            this._buffer.destroy();
            this._buffer = null;
        }
    }

    public void mark(int readlimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        byte[] buffer = new byte[1];
        return this.read(buffer, 0, 1);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this._buffer != null) {
            int byteRead = this._buffer.read(b, off, len);
            return byteRead;
        }
        return -1;
    }

    public void reset() {
    }

    public long skip(long n) {
        return 0L;
    }
}

