/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tptp.platform.agentcontroller.internal.impl;

import java.io.IOException;
import org.eclipse.tptp.platform.agentcontroller.internal.Connection;
import org.eclipse.tptp.platform.agentcontroller.internal.MessageDispatcher;
import org.eclipse.tptp.platform.agentcontroller.internal.Queue;
import org.eclipse.tptp.platform.agentcontroller.internal.TPTPMessage;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.ConnectionFactoryImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.HyadesSerializer;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.NamedPipeConnectionImpl;
import org.eclipse.tptp.platform.agentcontroller.internal.impl.TPTPLoggerImpl;

public class HyadesMessageDispatcherImpl
extends Thread
implements MessageDispatcher {
    private Queue _queue = null;
    private boolean _stop = false;

    public HyadesMessageDispatcherImpl() {
        super("Agent Controller Message Dispatcher");
    }

    public void interrupt() {
        this._stop = true;
    }

    public void run() {
        if (this._queue != null) {
            while (!this._stop || !this._queue.isEmpty()) {
                TPTPMessage message;
                String destination;
                Object obj = null;
                obj = this._queue.getItem();
                if (obj == null) {
                    return;
                }
                if (!(obj instanceof TPTPMessage) || (destination = (message = (TPTPMessage)obj).getDestination()) == null) continue;
                Connection connection = ConnectionFactoryImpl.getConnection(destination);
                if (connection == null) {
                    if (destination.startsWith("TPTP_NAMED_PIPE_CONTROL_CONNECTION")) {
                        String pipeName = destination.substring(destination.indexOf(":") + 1);
                        connection = ConnectionFactoryImpl.createNamedPipeConnection(pipeName, false);
                        ((NamedPipeConnectionImpl)connection).setSerializer(new HyadesSerializer());
                    } else if (destination.startsWith("TPTP_DIRECT_CONTROL_CONNECTION")) {
                        connection = ConnectionFactoryImpl.createDirectControlConnection();
                    }
                }
                try {
                    connection.objectReceived(message);
                }
                catch (IOException iOException) {
                    TPTPLoggerImpl.log(this, 1, "Connection lost. Cannot forward message to " + connection.getConnectionId());
                }
            }
        }
    }

    public void setInputQueue(Queue q) {
        this._queue = q;
    }
}

